/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.GivensParameters;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class MatrixUtil {
    private static final float G = 3.0f + 2.0f * Math.sqrt((float)2.0f);
    private static final GivensParameters PI_4 = GivensParameters.fromPositiveAngle(0.7853982f);

    private MatrixUtil() {
    }

    public static Matrix4f mulComponentWise(Matrix4f matrix, float scalar) {
        return matrix.set(matrix.m00() * scalar, matrix.m01() * scalar, matrix.m02() * scalar, matrix.m03() * scalar, matrix.m10() * scalar, matrix.m11() * scalar, matrix.m12() * scalar, matrix.m13() * scalar, matrix.m20() * scalar, matrix.m21() * scalar, matrix.m22() * scalar, matrix.m23() * scalar, matrix.m30() * scalar, matrix.m31() * scalar, matrix.m32() * scalar, matrix.m33() * scalar);
    }

    private static GivensParameters approxGivensQuat(float topCorner, float oppositeDiagonalAverage, float bottomCorner) {
        float f = 2.0f * (topCorner - bottomCorner);
        return G * oppositeDiagonalAverage * oppositeDiagonalAverage < f * f ? GivensParameters.fromUnnormalized(oppositeDiagonalAverage, f) : PI_4;
    }

    private static GivensParameters qrGivensQuat(float input1, float input2) {
        float f = (float)java.lang.Math.hypot(input1, input2);
        float f1 = f > 1.0E-6f ? input2 : 0.0f;
        float f2 = Math.abs((float)input1) + Math.max((float)f, (float)1.0E-6f);
        if (input1 < 0.0f) {
            float f3 = f1;
            f1 = f2;
            f2 = f3;
        }
        return GivensParameters.fromUnnormalized(f1, f2);
    }

    private static void similarityTransform(Matrix3f input, Matrix3f tempStorage) {
        input.mul((Matrix3fc)tempStorage);
        tempStorage.transpose();
        tempStorage.mul((Matrix3fc)input);
        input.set((Matrix3fc)tempStorage);
    }

    private static void stepJacobi(Matrix3f input, Matrix3f tempStorage, Quaternionf resultEigenvector, Quaternionf resultEigenvalue) {
        Quaternionf quaternionf;
        GivensParameters givensParameters;
        if (input.m01 * input.m01 + input.m10 * input.m10 > 1.0E-6f) {
            givensParameters = MatrixUtil.approxGivensQuat(input.m00, 0.5f * (input.m01 + input.m10), input.m11);
            quaternionf = givensParameters.aroundZ(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.aroundZ(tempStorage);
            MatrixUtil.similarityTransform(input, tempStorage);
        }
        if (input.m02 * input.m02 + input.m20 * input.m20 > 1.0E-6f) {
            givensParameters = MatrixUtil.approxGivensQuat(input.m00, 0.5f * (input.m02 + input.m20), input.m22).inverse();
            quaternionf = givensParameters.aroundY(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.aroundY(tempStorage);
            MatrixUtil.similarityTransform(input, tempStorage);
        }
        if (input.m12 * input.m12 + input.m21 * input.m21 > 1.0E-6f) {
            givensParameters = MatrixUtil.approxGivensQuat(input.m11, 0.5f * (input.m12 + input.m21), input.m22);
            quaternionf = givensParameters.aroundX(resultEigenvector);
            resultEigenvalue.mul((Quaternionfc)quaternionf);
            givensParameters.aroundX(tempStorage);
            MatrixUtil.similarityTransform(input, tempStorage);
        }
    }

    public static Quaternionf eigenvalueJacobi(Matrix3f input, int iterations) {
        Quaternionf quaternionf = new Quaternionf();
        Matrix3f matrix3f = new Matrix3f();
        Quaternionf quaternionf1 = new Quaternionf();
        for (int i = 0; i < iterations; ++i) {
            MatrixUtil.stepJacobi(input, matrix3f, quaternionf1, quaternionf);
        }
        quaternionf.normalize();
        return quaternionf;
    }

    public static Triple<Quaternionf, Vector3f, Quaternionf> svdDecompose(Matrix3f matrix) {
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrix);
        matrix3f.transpose();
        matrix3f.mul((Matrix3fc)matrix);
        Quaternionf quaternionf = MatrixUtil.eigenvalueJacobi(matrix3f, 5);
        float f = matrix3f.m00;
        float f1 = matrix3f.m11;
        boolean flag = (double)f < 1.0E-6;
        boolean flag1 = (double)f1 < 1.0E-6;
        Matrix3f matrix3f2 = matrix.rotate((Quaternionfc)quaternionf);
        Quaternionf quaternionf1 = new Quaternionf();
        Quaternionf quaternionf2 = new Quaternionf();
        GivensParameters givensParameters = flag ? MatrixUtil.qrGivensQuat(matrix3f2.m11, -matrix3f2.m10) : MatrixUtil.qrGivensQuat(matrix3f2.m00, matrix3f2.m01);
        Quaternionf quaternionf3 = givensParameters.aroundZ(quaternionf2);
        Matrix3f matrix3f3 = givensParameters.aroundZ(matrix3f);
        quaternionf1.mul((Quaternionfc)quaternionf3);
        matrix3f3.transpose().mul((Matrix3fc)matrix3f2);
        givensParameters = flag ? MatrixUtil.qrGivensQuat(matrix3f3.m22, -matrix3f3.m20) : MatrixUtil.qrGivensQuat(matrix3f3.m00, matrix3f3.m02);
        givensParameters = givensParameters.inverse();
        Quaternionf quaternionf4 = givensParameters.aroundY(quaternionf2);
        Matrix3f matrix3f4 = givensParameters.aroundY(matrix3f2);
        quaternionf1.mul((Quaternionfc)quaternionf4);
        matrix3f4.transpose().mul((Matrix3fc)matrix3f3);
        givensParameters = flag1 ? MatrixUtil.qrGivensQuat(matrix3f4.m22, -matrix3f4.m21) : MatrixUtil.qrGivensQuat(matrix3f4.m11, matrix3f4.m12);
        Quaternionf quaternionf5 = givensParameters.aroundX(quaternionf2);
        Matrix3f matrix3f5 = givensParameters.aroundX(matrix3f3);
        quaternionf1.mul((Quaternionfc)quaternionf5);
        matrix3f5.transpose().mul((Matrix3fc)matrix3f4);
        Vector3f vector3f = new Vector3f(matrix3f5.m00, matrix3f5.m11, matrix3f5.m22);
        return Triple.of((Object)quaternionf1, (Object)vector3f, (Object)quaternionf.conjugate());
    }

    public static boolean isIdentity(Matrix4f matrix) {
        return (matrix.properties() & 4) != 0;
    }

    public static boolean isPureTranslation(Matrix4f matrix) {
        return (matrix.properties() & 8) != 0;
    }

    public static boolean isOrthonormal(Matrix4f matrix) {
        return (matrix.properties() & 0x10) != 0;
    }
}

