/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.JavaOps;
import io.netty.util.AttributeKey;
import io.papermc.paper.adventure.AdventureCodecs;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.DataComponentValue;
import net.kyori.adventure.text.event.DataComponentValueConverterRegistry;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaperAdventure {
    private static final Pattern LOCALIZATION_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?s");
    public static final ComponentFlattener FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, (translatable, consumer) -> {
        if (!Language.getInstance().has(translatable.key())) {
            for (Translator source : GlobalTranslator.translator().sources()) {
                TranslationRegistry registry;
                if (!(source instanceof TranslationRegistry) || !(registry = (TranslationRegistry)source).contains(translatable.key())) continue;
                consumer.accept(GlobalTranslator.render((Component)translatable, (Locale)Locale.US));
                return;
            }
        }
        @Nullable String fallback = translatable.fallback();
        @NotNull String translated = Language.getInstance().getOrDefault(translatable.key(), fallback != null ? fallback : translatable.key());
        Matcher matcher = LOCALIZATION_PATTERN.matcher(translated);
        List args = translatable.arguments();
        int argPosition = 0;
        int lastIdx = 0;
        while (matcher.find()) {
            int idx;
            if (lastIdx < matcher.start()) {
                consumer.accept(Component.text((String)translated.substring(lastIdx, matcher.start())));
            }
            lastIdx = matcher.end();
            @Nullable String argIdx = matcher.group(1);
            if (argIdx != null) {
                try {
                    idx = Integer.parseInt(argIdx) - 1;
                    if (idx >= args.size()) continue;
                    consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
                }
                catch (NumberFormatException idx2) {}
                continue;
            }
            if ((idx = argPosition++) >= args.size()) continue;
            consumer.accept(((TranslationArgument)args.get(idx)).asComponent());
        }
        if (lastIdx < translated.length()) {
            consumer.accept(Component.text((String)translated.substring(lastIdx)));
        }
    }).build();
    public static final AttributeKey<Locale> LOCALE_ATTRIBUTE = AttributeKey.valueOf((String)"adventure:locale");
    @Deprecated
    public static final PlainComponentSerializer PLAIN = (PlainComponentSerializer)PlainComponentSerializer.builder().flattener(FLATTENER).build();
    public static final ANSIComponentSerializer ANSI_SERIALIZER = ANSIComponentSerializer.builder().flattener(FLATTENER).build();
    public static final Codec<Tag, String, CommandSyntaxException, RuntimeException> NBT_CODEC = new Codec<Tag, String, CommandSyntaxException, RuntimeException>(){

        @NotNull
        public Tag decode(@NotNull String encoded) throws CommandSyntaxException {
            return new TagParser(new StringReader(encoded)).readValue();
        }

        @NotNull
        public String encode(@NotNull Tag decoded) {
            return decoded.toString();
        }
    };
    public static final ComponentSerializer<Component, Component, net.minecraft.network.chat.Component> WRAPPER_AWARE_SERIALIZER = new WrapperAwareSerializer(() -> CraftRegistry.getMinecraftRegistry().createSerializationContext(JavaOps.INSTANCE));
    private static final Map<Locale, com.mojang.serialization.Codec<Component>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, com.mojang.serialization.Codec<Component>>();

    private PaperAdventure() {
    }

    public static Key asAdventure(ResourceLocation key) {
        return Key.key((String)key.getNamespace(), (String)key.getPath());
    }

    public static ResourceLocation asVanilla(Key key) {
        return ResourceLocation.fromNamespaceAndPath(key.namespace(), key.value());
    }

    public static <T> ResourceKey<T> asVanilla(ResourceKey<? extends Registry<T>> registry, Key key) {
        return ResourceKey.create(registry, PaperAdventure.asVanilla(key));
    }

    public static Key asAdventureKey(ResourceKey<?> key) {
        return PaperAdventure.asAdventure(key.location());
    }

    @Nullable
    public static ResourceLocation asVanillaNullable(Key key) {
        if (key == null) {
            return null;
        }
        return PaperAdventure.asVanilla(key);
    }

    public static Holder<SoundEvent> resolveSound(Key key) {
        ResourceLocation id = PaperAdventure.asVanilla(key);
        Optional<Holder.Reference<SoundEvent>> vanilla = BuiltInRegistries.SOUND_EVENT.get(id);
        if (vanilla.isPresent()) {
            return vanilla.get();
        }
        return Holder.direct(SoundEvent.createVariableRangeEvent(id));
    }

    @NotNull
    public static Component asAdventure(@Nullable net.minecraft.network.chat.Component component) {
        return component == null ? Component.empty() : WRAPPER_AWARE_SERIALIZER.deserialize((Object)component);
    }

    public static ArrayList<Component> asAdventure(List<? extends net.minecraft.network.chat.Component> vanillas) {
        ArrayList<Component> adventures = new ArrayList<Component>(vanillas.size());
        for (net.minecraft.network.chat.Component component : vanillas) {
            adventures.add(PaperAdventure.asAdventure(component));
        }
        return adventures;
    }

    public static ArrayList<Component> asAdventureFromJson(List<String> jsonStrings) {
        ArrayList<Component> adventures = new ArrayList<Component>(jsonStrings.size());
        for (String json : jsonStrings) {
            adventures.add(GsonComponentSerializer.gson().deserialize((Object)json));
        }
        return adventures;
    }

    public static List<String> asJson(List<? extends Component> adventures) {
        ArrayList<String> jsons = new ArrayList<String>(adventures.size());
        for (Component component : adventures) {
            jsons.add((String)GsonComponentSerializer.gson().serialize(component));
        }
        return jsons;
    }

    public static @NotNull net.minecraft.network.chat.Component asVanillaNullToEmpty(@Nullable Component component) {
        if (component == null) {
            return CommonComponents.EMPTY;
        }
        return PaperAdventure.asVanilla(component);
    }

    @Contract(value="null -> null; !null -> !null")
    public static net.minecraft.network.chat.Component asVanilla(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        return new AdventureComponent(component);
    }

    public static List<net.minecraft.network.chat.Component> asVanilla(List<? extends Component> adventures) {
        ArrayList<net.minecraft.network.chat.Component> vanillas = new ArrayList<net.minecraft.network.chat.Component>(adventures.size());
        for (Component component : adventures) {
            vanillas.add(PaperAdventure.asVanilla(component));
        }
        return vanillas;
    }

    public static String asJsonString(Component component, Locale locale) {
        return (String)GsonComponentSerializer.gson().serialize(PaperAdventure.translated(component, locale));
    }

    public static boolean hasAnyTranslations() {
        return StreamSupport.stream(GlobalTranslator.translator().sources().spliterator(), false).anyMatch(t -> t.hasAnyTranslations().toBooleanOrElse(true));
    }

    public static com.mojang.serialization.Codec<Component> localizedCodec(@Nullable Locale l) {
        if (l == null) {
            return AdventureCodecs.COMPONENT_CODEC;
        }
        return LOCALIZED_CODECS.computeIfAbsent(l, locale -> AdventureCodecs.COMPONENT_CODEC.xmap(component -> component, component -> PaperAdventure.translated(component, locale)));
    }

    public static String asPlain(Component component, Locale locale) {
        return PlainTextComponentSerializer.plainText().serialize(PaperAdventure.translated(component, locale));
    }

    private static Component translated(Component component, Locale locale) {
        return GlobalTranslator.render((Component)component, (Locale)(locale != null ? locale : Locale.US));
    }

    public static Component resolveWithContext(@NotNull Component component, @Nullable CommandSender context, @Nullable Entity scoreboardSubject, boolean bypassPermissions) throws IOException {
        CommandSourceStack css = context != null ? VanillaCommandWrapper.getListener(context) : null;
        Boolean previous = null;
        if (css != null && bypassPermissions) {
            previous = css.bypassSelectorPermissions;
            css.bypassSelectorPermissions = true;
        }
        try {
            Component component2 = PaperAdventure.asAdventure(ComponentUtils.updateForEntity(css, PaperAdventure.asVanilla(component), scoreboardSubject == null ? null : ((CraftEntity)scoreboardSubject).getHandle(), 0));
            return component2;
        }
        catch (CommandSyntaxException e) {
            throw new IOException(e);
        }
        finally {
            if (css != null && previous != null) {
                css.bypassSelectorPermissions = previous;
            }
        }
    }

    public static BossEvent.BossBarColor asVanilla(BossBar.Color color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case BossBar.Color.PINK -> BossEvent.BossBarColor.PINK;
            case BossBar.Color.BLUE -> BossEvent.BossBarColor.BLUE;
            case BossBar.Color.RED -> BossEvent.BossBarColor.RED;
            case BossBar.Color.GREEN -> BossEvent.BossBarColor.GREEN;
            case BossBar.Color.YELLOW -> BossEvent.BossBarColor.YELLOW;
            case BossBar.Color.PURPLE -> BossEvent.BossBarColor.PURPLE;
            case BossBar.Color.WHITE -> BossEvent.BossBarColor.WHITE;
        };
    }

    public static BossBar.Color asAdventure(BossEvent.BossBarColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case BossEvent.BossBarColor.PINK -> BossBar.Color.PINK;
            case BossEvent.BossBarColor.BLUE -> BossBar.Color.BLUE;
            case BossEvent.BossBarColor.RED -> BossBar.Color.RED;
            case BossEvent.BossBarColor.GREEN -> BossBar.Color.GREEN;
            case BossEvent.BossBarColor.YELLOW -> BossBar.Color.YELLOW;
            case BossEvent.BossBarColor.PURPLE -> BossBar.Color.PURPLE;
            case BossEvent.BossBarColor.WHITE -> BossBar.Color.WHITE;
        };
    }

    public static BossEvent.BossBarOverlay asVanilla(BossBar.Overlay overlay) {
        return switch (overlay) {
            default -> throw new MatchException(null, null);
            case BossBar.Overlay.PROGRESS -> BossEvent.BossBarOverlay.PROGRESS;
            case BossBar.Overlay.NOTCHED_6 -> BossEvent.BossBarOverlay.NOTCHED_6;
            case BossBar.Overlay.NOTCHED_10 -> BossEvent.BossBarOverlay.NOTCHED_10;
            case BossBar.Overlay.NOTCHED_12 -> BossEvent.BossBarOverlay.NOTCHED_12;
            case BossBar.Overlay.NOTCHED_20 -> BossEvent.BossBarOverlay.NOTCHED_20;
        };
    }

    public static BossBar.Overlay asAdventure(BossEvent.BossBarOverlay overlay) {
        return switch (overlay) {
            default -> throw new MatchException(null, null);
            case BossEvent.BossBarOverlay.PROGRESS -> BossBar.Overlay.PROGRESS;
            case BossEvent.BossBarOverlay.NOTCHED_6 -> BossBar.Overlay.NOTCHED_6;
            case BossEvent.BossBarOverlay.NOTCHED_10 -> BossBar.Overlay.NOTCHED_10;
            case BossEvent.BossBarOverlay.NOTCHED_12 -> BossBar.Overlay.NOTCHED_12;
            case BossEvent.BossBarOverlay.NOTCHED_20 -> BossBar.Overlay.NOTCHED_20;
        };
    }

    public static void setFlag(BossBar bar, BossBar.Flag flag, boolean value) {
        if (value) {
            bar.addFlag(flag);
        } else {
            bar.removeFlag(flag);
        }
    }

    public static ItemStack asItemStack(Book book, Locale locale) {
        ItemStack item = new ItemStack(Items.WRITTEN_BOOK, 1);
        item.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(Filterable.passThrough(PaperAdventure.validateField(PaperAdventure.asPlain(book.title(), locale), 32, "title")), PaperAdventure.asPlain(book.author(), locale), 0, book.pages().stream().map(c -> Filterable.passThrough(PaperAdventure.asVanilla(c))).toList(), false));
        return item;
    }

    private static String validateField(String content, int length, String name) {
        int actual = content.length();
        if (actual > length) {
            throw new IllegalArgumentException("Field '" + name + "' has a maximum length of " + length + " but was passed '" + content + "', which was " + actual + " characters long.");
        }
        return content;
    }

    public static SoundSource asVanilla(Sound.Source source) {
        return switch (source) {
            default -> throw new MatchException(null, null);
            case Sound.Source.MASTER -> SoundSource.MASTER;
            case Sound.Source.MUSIC -> SoundSource.MUSIC;
            case Sound.Source.RECORD -> SoundSource.RECORDS;
            case Sound.Source.WEATHER -> SoundSource.WEATHER;
            case Sound.Source.BLOCK -> SoundSource.BLOCKS;
            case Sound.Source.HOSTILE -> SoundSource.HOSTILE;
            case Sound.Source.NEUTRAL -> SoundSource.NEUTRAL;
            case Sound.Source.PLAYER -> SoundSource.PLAYERS;
            case Sound.Source.AMBIENT -> SoundSource.AMBIENT;
            case Sound.Source.VOICE -> SoundSource.VOICE;
        };
    }

    @Nullable
    public static SoundSource asVanillaNullable(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Sound.Source source) {
        if (source == null) {
            return null;
        }
        return PaperAdventure.asVanilla(source);
    }

    public static Packet<?> asSoundPacket(Sound sound, double x, double y, double z, long seed, @Nullable BiConsumer<Packet<?>, Float> packetConsumer) {
        ResourceLocation name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEvent> soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(name);
        SoundSource source = PaperAdventure.asVanilla(sound.source());
        Holder soundEventHolder = soundEvent.map(BuiltInRegistries.SOUND_EVENT::wrapAsHolder).orElseGet(() -> Holder.direct(SoundEvent.createVariableRangeEvent(name)));
        ClientboundSoundPacket packet = new ClientboundSoundPacket(soundEventHolder, source, x, y, z, sound.volume(), sound.pitch(), seed);
        if (packetConsumer != null) {
            packetConsumer.accept(packet, Float.valueOf(((SoundEvent)soundEventHolder.value()).getRange(sound.volume())));
        }
        return packet;
    }

    public static Packet<?> asSoundPacket(Sound sound, net.minecraft.world.entity.Entity emitter, long seed, @Nullable BiConsumer<Packet<?>, Float> packetConsumer) {
        ResourceLocation name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEvent> soundEvent = BuiltInRegistries.SOUND_EVENT.getOptional(name);
        SoundSource source = PaperAdventure.asVanilla(sound.source());
        Holder soundEventHolder = soundEvent.map(BuiltInRegistries.SOUND_EVENT::wrapAsHolder).orElseGet(() -> Holder.direct(SoundEvent.createVariableRangeEvent(name)));
        ClientboundSoundEntityPacket packet = new ClientboundSoundEntityPacket(soundEventHolder, source, emitter, sound.volume(), sound.pitch(), seed);
        if (packetConsumer != null) {
            packetConsumer.accept(packet, Float.valueOf(((SoundEvent)soundEventHolder.value()).getRange(sound.volume())));
        }
        return packet;
    }

    public static Map<Key, ? extends DataComponentValue> asAdventure(DataComponentPatch patch) {
        if (patch.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Key, Object> map = new HashMap<Key, Object>();
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : patch.entrySet()) {
            if (entry.getKey().isTransient()) continue;
            String typeKey = Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(entry.getKey())).toString();
            if (entry.getValue().isEmpty()) {
                map.put(Key.key((String)typeKey), DataComponentValue.removed());
                continue;
            }
            map.put(Key.key((String)typeKey), new DataComponentValueImpl(entry.getKey().codec(), entry.getValue().get()));
        }
        return map;
    }

    public static DataComponentPatch asVanilla(Map<? extends Key, ? extends DataComponentValue> map) {
        if (map.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        map.forEach((key, dataComponentValue) -> {
            DataComponentType<?> type = Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(PaperAdventure.asVanilla(key)));
            if (dataComponentValue instanceof DataComponentValue.Removed) {
                builder.remove(type);
                return;
            }
            DataComponentValueImpl converted = (DataComponentValueImpl)DataComponentValueConverterRegistry.convert(DataComponentValueImpl.class, (Key)key, (DataComponentValue)dataComponentValue);
            builder.set(type, converted.value());
        });
        return builder.build();
    }

    @Nullable
    public static BinaryTagHolder asBinaryTagHolder(@Nullable CompoundTag tag) {
        if (tag == null) {
            return null;
        }
        return BinaryTagHolder.encode((Object)tag, NBT_CODEC);
    }

    @NotNull
    public static TextColor asAdventure(ChatFormatting formatting) {
        Integer color = formatting.getColor();
        if (color == null) {
            throw new IllegalArgumentException("Not a valid color");
        }
        return TextColor.color((int)color);
    }

    @Nullable
    public static ChatFormatting asVanilla(TextColor color) {
        return ChatFormatting.getByHexValue(color.value());
    }

    public static Style asVanilla(net.kyori.adventure.text.format.Style style) {
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JavaOps.INSTANCE);
        Object encoded = AdventureCodecs.STYLE_MAP_CODEC.codec().encodeStart(ops, (Object)style).getOrThrow(IllegalStateException::new);
        return (Style)Style.Serializer.CODEC.parse(ops, encoded).getOrThrow(IllegalStateException::new);
    }

    public static net.kyori.adventure.text.format.Style asAdventure(Style style) {
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext(JavaOps.INSTANCE);
        Object encoded = Style.Serializer.CODEC.encodeStart(ops, (Object)style).getOrThrow(IllegalStateException::new);
        return (net.kyori.adventure.text.format.Style)AdventureCodecs.STYLE_MAP_CODEC.codec().parse(ops, encoded).getOrThrow(IllegalStateException::new);
    }

    public record DataComponentValueImpl<T>(com.mojang.serialization.Codec<T> codec, T value) implements DataComponentValue.TagSerializable
    {
        @NotNull
        public BinaryTagHolder asBinaryTag() {
            return BinaryTagHolder.encode((Object)((Tag)this.codec.encodeStart(CraftRegistry.getMinecraftRegistry().createSerializationContext(NbtOps.INSTANCE), this.value).getOrThrow(IllegalArgumentException::new)), NBT_CODEC);
        }
    }
}

