/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier.argument;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.command.brigadier.argument.SignedMessageResolver;
import io.papermc.paper.command.brigadier.argument.SignedMessageResolverImpl;
import io.papermc.paper.command.brigadier.argument.VanillaArgumentProvider;
import io.papermc.paper.command.brigadier.argument.predicate.ItemStackPredicate;
import io.papermc.paper.command.brigadier.argument.range.DoubleRangeProvider;
import io.papermc.paper.command.brigadier.argument.range.IntegerRangeProvider;
import io.papermc.paper.command.brigadier.argument.range.RangeProvider;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.PlayerProfileListResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.math.Rotation;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.HeightMap;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.CraftHeightMap;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class VanillaArgumentProviderImpl
implements VanillaArgumentProvider {
    public ArgumentType<EntitySelectorArgumentResolver> entity() {
        return this.wrap(EntityArgument.entity(), result -> sourceStack -> List.of(result.findSingleEntity((CommandSourceStack)sourceStack).getBukkitEntity()));
    }

    public ArgumentType<EntitySelectorArgumentResolver> entities() {
        return this.wrap(EntityArgument.entities(), result -> sourceStack -> Lists.transform(result.findEntities((CommandSourceStack)sourceStack), Entity::getBukkitEntity));
    }

    public ArgumentType<PlayerSelectorArgumentResolver> player() {
        return this.wrap(EntityArgument.player(), result -> sourceStack -> List.of(result.findSinglePlayer((CommandSourceStack)sourceStack).getBukkitEntity()));
    }

    public ArgumentType<PlayerSelectorArgumentResolver> players() {
        return this.wrap(EntityArgument.players(), result -> sourceStack -> Lists.transform(result.findPlayers((CommandSourceStack)sourceStack), ServerPlayer::getBukkitEntity));
    }

    public ArgumentType<PlayerProfileListResolver> playerProfiles() {
        return this.wrap(GameProfileArgument.gameProfile(), result -> {
            if (result instanceof GameProfileArgument.SelectorResult) {
                return sourceStack -> Collections.unmodifiableCollection(Collections2.transform(result.getNames((CommandSourceStack)sourceStack), CraftPlayerProfile::new));
            }
            return sourceStack -> Collections.unmodifiableCollection(Collections2.transform(result.getNames((CommandSourceStack)sourceStack), CraftPlayerProfile::new));
        });
    }

    public ArgumentType<BlockPositionResolver> blockPosition() {
        return this.wrap(BlockPosArgument.blockPos(), result -> sourceStack -> {
            BlockPos pos = result.getBlockPos((CommandSourceStack)sourceStack);
            return MCUtil.toPosition(pos);
        });
    }

    public ArgumentType<FinePositionResolver> finePosition(boolean centerIntegers) {
        return this.wrap(Vec3Argument.vec3(centerIntegers), result -> sourceStack -> {
            Vec3 vec3 = result.getPosition((CommandSourceStack)sourceStack);
            return MCUtil.toPosition(vec3);
        });
    }

    public ArgumentType<RotationResolver> rotation() {
        return this.wrap(RotationArgument.rotation(), result -> sourceStack -> {
            Vec2 vec2 = result.getRotation((CommandSourceStack)sourceStack);
            return Rotation.rotation((float)vec2.y, (float)vec2.x);
        });
    }

    public ArgumentType<BlockState> blockState() {
        return this.wrap(BlockStateArgument.block(PaperCommands.INSTANCE.getBuildContext()), result -> CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), BlockPos.ZERO, result.getState(), result.tag));
    }

    public ArgumentType<ItemStack> itemStack() {
        return this.wrap(ItemArgument.item(PaperCommands.INSTANCE.getBuildContext()), result -> CraftItemStack.asBukkitCopy(result.createItemStack(1, true)));
    }

    public ArgumentType<ItemStackPredicate> itemStackPredicate() {
        return this.wrap(ItemPredicateArgument.itemPredicate(PaperCommands.INSTANCE.getBuildContext()), type -> itemStack -> type.test(CraftItemStack.asNMSCopy(itemStack)));
    }

    public ArgumentType<NamedTextColor> namedColor() {
        return this.wrap(ColorArgument.color(), result -> Objects.requireNonNull(NamedTextColor.namedColor((int)Objects.requireNonNull(result.getColor(), () -> String.valueOf(result) + " didn't have a color")), () -> result.getColor() + " didn't map to an adventure named color"));
    }

    public ArgumentType<Component> component() {
        return this.wrap(ComponentArgument.textComponent(PaperCommands.INSTANCE.getBuildContext()), PaperAdventure::asAdventure);
    }

    public ArgumentType<Style> style() {
        return this.wrap(StyleArgument.style(PaperCommands.INSTANCE.getBuildContext()), PaperAdventure::asAdventure);
    }

    public ArgumentType<SignedMessageResolver> signedMessage() {
        return this.wrap(MessageArgument.message(), SignedMessageResolverImpl::new);
    }

    public ArgumentType<DisplaySlot> scoreboardDisplaySlot() {
        return this.wrap(ScoreboardSlotArgument.displaySlot(), CraftScoreboardTranslations::toBukkitSlot);
    }

    public ArgumentType<NamespacedKey> namespacedKey() {
        return this.wrap(ResourceLocationArgument.id(), CraftNamespacedKey::fromMinecraft);
    }

    public ArgumentType<Key> key() {
        return this.wrap(ResourceLocationArgument.id(), CraftNamespacedKey::fromMinecraft);
    }

    public ArgumentType<IntegerRangeProvider> integerRange() {
        return this.wrap(RangeArgument.intRange(), type -> VanillaArgumentProviderImpl.convertToRange(type, integerRange -> () -> integerRange));
    }

    public ArgumentType<DoubleRangeProvider> doubleRange() {
        return this.wrap(RangeArgument.floatRange(), type -> VanillaArgumentProviderImpl.convertToRange(type, doubleRange -> () -> doubleRange));
    }

    private static <C extends Number, T extends RangeProvider<C>> T convertToRange(MinMaxBounds<C> bounds, Function<Range<C>, T> converter) {
        if (bounds.isAny()) {
            return (T)((RangeProvider)converter.apply(Range.all()));
        }
        if (bounds.min().isPresent() && bounds.max().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.closed((Comparable)((Object)((Number)bounds.min().get())), (Comparable)((Object)((Number)bounds.max().get())))));
        }
        if (bounds.max().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.atMost((Comparable)((Object)((Number)bounds.max().get())))));
        }
        if (bounds.min().isPresent()) {
            return (T)((RangeProvider)converter.apply(Range.atLeast((Comparable)((Object)((Number)bounds.min().get())))));
        }
        throw new IllegalStateException("This is a bug: " + String.valueOf(bounds));
    }

    public ArgumentType<World> world() {
        return this.wrap(DimensionArgument.dimension(), dimensionLocation -> {
            ResourceKey<Level> resourceKey = ResourceKey.create(Registries.DIMENSION, dimensionLocation);
            @Nullable ServerLevel serverLevel = MinecraftServer.getServer().getLevel(resourceKey);
            if (serverLevel == null) {
                throw DimensionArgument.ERROR_INVALID_VALUE.create(dimensionLocation);
            }
            return serverLevel.getWorld();
        });
    }

    public ArgumentType<GameMode> gameMode() {
        return this.wrap(GameModeArgument.gameMode(), type -> Objects.requireNonNull(GameMode.getByValue((int)type.getId())));
    }

    public ArgumentType<HeightMap> heightMap() {
        return this.wrap(HeightmapTypeArgument.heightmap(), CraftHeightMap::fromNMS);
    }

    public ArgumentType<UUID> uuid() {
        return this.wrap(UuidArgument.uuid());
    }

    public ArgumentType<Criteria> objectiveCriteria() {
        return this.wrap(ObjectiveCriteriaArgument.criteria(), CraftCriteria::getFromNMS);
    }

    public ArgumentType<LookAnchor> entityAnchor() {
        return this.wrap(EntityAnchorArgument.anchor(), type -> LookAnchor.valueOf((String)type.name()));
    }

    public ArgumentType<Integer> time(int minTicks) {
        return this.wrap(TimeArgument.time(minTicks));
    }

    public ArgumentType<Mirror> templateMirror() {
        return this.wrap(TemplateMirrorArgument.templateMirror(), mirror -> Mirror.valueOf((String)mirror.name()));
    }

    public ArgumentType<StructureRotation> templateRotation() {
        return this.wrap(TemplateRotationArgument.templateRotation(), mirror -> StructureRotation.valueOf((String)mirror.name()));
    }

    public <T> ArgumentType<TypedKey<T>> resourceKey(RegistryKey<T> registryKey) {
        return this.wrap(ResourceKeyArgument.key(PaperRegistries.registryToNms(registryKey)), nmsRegistryKey -> TypedKey.create((RegistryKey)registryKey, (Key)CraftNamespacedKey.fromMinecraft(nmsRegistryKey.location())));
    }

    public <T> ArgumentType<T> resource(RegistryKey<T> registryKey) {
        return this.resourceRaw(registryKey);
    }

    private <T, K extends Keyed> ArgumentType<T> resourceRaw(RegistryKey registryKeyRaw) {
        RegistryKey registryKey = registryKeyRaw;
        return this.wrap(ResourceArgument.resource(PaperCommands.INSTANCE.getBuildContext(), PaperRegistries.registryToNms(registryKey)), resource -> Objects.requireNonNull(RegistryAccess.registryAccess().getRegistry(registryKey).get(CraftNamespacedKey.fromMinecraft(resource.key().location()))));
    }

    private <T> ArgumentType<T> wrap(ArgumentType<T> base) {
        return this.wrap(base, identity -> identity);
    }

    private <B, C> ArgumentType<C> wrap(ArgumentType<B> base, ResultConverter<B, C> converter) {
        return new NativeWrapperArgumentType<B, C>(base, converter);
    }

    @FunctionalInterface
    static interface ResultConverter<T, R> {
        public R convert(T var1) throws CommandSyntaxException;
    }

    public static final class NativeWrapperArgumentType<M, P>
    implements ArgumentType<P> {
        private final ArgumentType<M> nmsBase;
        private final ResultConverter<M, P> converter;

        private NativeWrapperArgumentType(ArgumentType<M> nmsBase, ResultConverter<M, P> converter) {
            this.nmsBase = nmsBase;
            this.converter = converter;
        }

        public ArgumentType<M> nativeNmsArgumentType() {
            return this.nmsBase;
        }

        public P parse(StringReader reader) throws CommandSyntaxException {
            return this.converter.convert(this.nmsBase.parse(reader));
        }

        public <S> P parse(StringReader reader, S source) throws CommandSyntaxException {
            return this.converter.convert(this.nmsBase.parse(reader, source));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return this.nmsBase.listSuggestions(context, builder);
        }

        public Collection<String> getExamples() {
            return this.nmsBase.getExamples();
        }
    }
}

