/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import io.papermc.paper.datacomponent.item.consumable.PaperConsumableEffects;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.bukkit.craftbukkit.util.Handleable;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.Unmodifiable;

public record PaperConsumable(net.minecraft.world.item.component.Consumable impl) implements Consumable,
Handleable<net.minecraft.world.item.component.Consumable>
{
    private static final ItemUseAnimation[] VALUES = ItemUseAnimation.values();

    @Override
    public net.minecraft.world.item.component.Consumable getHandle() {
        return this.impl;
    }

    public @NonNegative float consumeSeconds() {
        return this.impl.consumeSeconds();
    }

    public ItemUseAnimation animation() {
        return VALUES[this.impl.animation().ordinal()];
    }

    public Key sound() {
        return PaperAdventure.asAdventure(this.impl.sound().value().location());
    }

    public boolean hasConsumeParticles() {
        return this.impl.hasConsumeParticles();
    }

    public @Unmodifiable List<ConsumeEffect> consumeEffects() {
        return MCUtil.transformUnmodifiable(this.impl.onConsumeEffects(), PaperConsumableEffects::fromNms);
    }

    public Consumable.Builder toBuilder() {
        return new BuilderImpl().consumeSeconds(this.consumeSeconds()).animation(this.animation()).sound(this.sound()).addEffects(this.consumeEffects());
    }

    static final class BuilderImpl
    implements Consumable.Builder {
        private static final net.minecraft.world.item.ItemUseAnimation[] VALUES = net.minecraft.world.item.ItemUseAnimation.values();
        private float consumeSeconds = 1.6f;
        private net.minecraft.world.item.ItemUseAnimation consumeAnimation = net.minecraft.world.item.ItemUseAnimation.EAT;
        private Holder<SoundEvent> eatSound = SoundEvents.GENERIC_EAT;
        private boolean hasConsumeParticles = true;
        private final List<net.minecraft.world.item.consume_effects.ConsumeEffect> effects = new ObjectArrayList();

        BuilderImpl() {
        }

        public Consumable.Builder consumeSeconds(@NonNegative float consumeSeconds) {
            Preconditions.checkArgument((consumeSeconds >= 0.0f ? 1 : 0) != 0, (String)"consumeSeconds must be non-negative, was %s", (Object)Float.valueOf(consumeSeconds));
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        public Consumable.Builder animation(ItemUseAnimation animation) {
            this.consumeAnimation = VALUES[animation.ordinal()];
            return this;
        }

        public Consumable.Builder sound(Key sound) {
            this.eatSound = PaperAdventure.resolveSound(sound);
            return this;
        }

        public Consumable.Builder hasConsumeParticles(boolean hasConsumeParticles) {
            this.hasConsumeParticles = hasConsumeParticles;
            return this;
        }

        public Consumable.Builder addEffect(ConsumeEffect effect) {
            this.effects.add(PaperConsumableEffects.toNms(effect));
            return this;
        }

        public Consumable.Builder addEffects(List<ConsumeEffect> effects) {
            for (ConsumeEffect effect : effects) {
                this.effects.add(PaperConsumableEffects.toNms(effect));
            }
            return this;
        }

        public Consumable build() {
            return new PaperConsumable(new net.minecraft.world.item.component.Consumable(this.consumeSeconds, this.consumeAnimation, this.eatSound, this.hasConsumeParticles, (List<net.minecraft.world.item.consume_effects.ConsumeEffect>)new ObjectArrayList(this.effects)));
        }
    }
}

