/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.Unmodifiable;

public record PaperItemAttributeModifiers(net.minecraft.world.item.component.ItemAttributeModifiers impl) implements ItemAttributeModifiers,
Handleable<net.minecraft.world.item.component.ItemAttributeModifiers>
{
    private static List<ItemAttributeModifiers.Entry> convert(net.minecraft.world.item.component.ItemAttributeModifiers nmsModifiers) {
        return MCUtil.transformUnmodifiable(nmsModifiers.modifiers(), nms -> new PaperEntry(CraftAttribute.minecraftHolderToBukkit(nms.attribute()), CraftAttributeInstance.convert(nms.modifier(), nms.slot())));
    }

    @Override
    public net.minecraft.world.item.component.ItemAttributeModifiers getHandle() {
        return this.impl;
    }

    public boolean showInTooltip() {
        return this.impl.showInTooltip();
    }

    public ItemAttributeModifiers showInTooltip(boolean showInTooltip) {
        return new PaperItemAttributeModifiers(this.impl.withTooltip(showInTooltip));
    }

    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    ItemAttributeModifiers.Entry> modifiers() {
        return PaperItemAttributeModifiers.convert(this.impl);
    }

    public record PaperEntry(Attribute attribute, AttributeModifier modifier) implements ItemAttributeModifiers.Entry
    {
    }

    static final class BuilderImpl
    implements ItemAttributeModifiers.Builder {
        private final List<ItemAttributeModifiers.Entry> entries = new ObjectArrayList();
        private boolean showInTooltip = net.minecraft.world.item.component.ItemAttributeModifiers.EMPTY.showInTooltip();

        BuilderImpl() {
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier) {
            return this.addModifier(attribute, modifier, modifier.getSlotGroup());
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup equipmentSlotGroup) {
            Preconditions.checkArgument((boolean)this.entries.stream().noneMatch(e -> e.modifier().id().equals(CraftNamespacedKey.toMinecraft(modifier.getKey())) && e.attribute().is(CraftNamespacedKey.toMinecraft(attribute.getKey()))), (String)"Cannot add 2 modifiers with identical keys on the same attribute (modifier %s for attribute %s)", (Object)modifier.getKey(), (Object)attribute.getKey());
            this.entries.add(new ItemAttributeModifiers.Entry(CraftAttribute.bukkitToMinecraftHolder(attribute), CraftAttributeInstance.convert(modifier), CraftEquipmentSlot.getNMSGroup(equipmentSlotGroup)));
            return this;
        }

        public ItemAttributeModifiers.Builder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public ItemAttributeModifiers build() {
            if (this.entries.isEmpty()) {
                return new PaperItemAttributeModifiers(net.minecraft.world.item.component.ItemAttributeModifiers.EMPTY.withTooltip(this.showInTooltip));
            }
            return new PaperItemAttributeModifiers(new net.minecraft.world.item.component.ItemAttributeModifiers((List<ItemAttributeModifiers.Entry>)new ObjectArrayList(this.entries), this.showInTooltip));
        }
    }
}

