/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.entity.activation;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.phys.AABB;

public enum ActivationType {
    WATER,
    FLYING_MONSTER,
    VILLAGER,
    MONSTER,
    ANIMAL,
    RAIDER,
    MISC;

    AABB boundingBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public static ActivationType activationTypeFor(Entity entity) {
        if (entity instanceof WaterAnimal || entity instanceof AgeableWaterCreature) {
            return WATER;
        }
        if (entity instanceof Villager) {
            return VILLAGER;
        }
        if (entity instanceof FlyingMob && entity instanceof Enemy) {
            return FLYING_MONSTER;
        }
        if (entity instanceof Raider) {
            return RAIDER;
        }
        if (entity instanceof Enemy) {
            return MONSTER;
        }
        if (entity instanceof PathfinderMob || entity instanceof AmbientCreature) {
            return ANIMAL;
        }
        return MISC;
    }
}

