/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.mojang.serialization.Lifecycle;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperRegistryBuilderFactory;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.event.WritableRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.CraftRegistry;

public class WritableCraftRegistry<M, T extends Keyed, B extends PaperRegistryBuilder<M, T>>
extends CraftRegistry<T, M> {
    private static final RegistrationInfo FROM_PLUGIN = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private final RegistryEntryMeta.Buildable<M, T, B> meta;
    private final MappedRegistry<M> registry;

    public WritableCraftRegistry(MappedRegistry<M> registry, RegistryEntryMeta.Buildable<M, T, B> meta) {
        super(meta, registry);
        this.registry = registry;
        this.meta = meta;
    }

    public void register(TypedKey<T> key, Consumer<RegistryBuilderFactory<T, B>> value, Conversions conversions) {
        ResourceKey resourceKey = PaperRegistries.toNms(key);
        this.registry.validateWrite(resourceKey);
        PaperRegistryBuilderFactory<Object, T, B> builderFactory = new PaperRegistryBuilderFactory<Object, T, B>(conversions, this.meta.builderFiller(), this.registry.temporaryUnfrozenMap::get);
        value.accept(builderFactory);
        PaperRegistryListenerManager.INSTANCE.registerWithListeners(this.registry, this.meta, resourceKey, builderFactory.requireBuilder(), FROM_PLUGIN, conversions);
    }

    public WritableRegistry<T, B> createApiWritableRegistry(Conversions conversions) {
        return new ApiWritableRegistry(conversions);
    }

    public class ApiWritableRegistry
    implements WritableRegistry<T, B> {
        private final Conversions conversions;

        public ApiWritableRegistry(Conversions conversions) {
            this.conversions = conversions;
        }

        public void registerWith(TypedKey<T> key, Consumer<RegistryBuilderFactory<T, B>> value) {
            WritableCraftRegistry.this.register(key, value, this.conversions);
        }
    }
}

