/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.util;

import com.google.common.base.Preconditions;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class Conversions {
    private static @Nullable Conversions globalInstance;
    private final RegistryOps.RegistryInfoLookup lookup;
    private final WrapperAwareSerializer serializer;

    public static Conversions global() {
        if (globalInstance == null) {
            final RegistryAccess globalAccess = CraftRegistry.getMinecraftRegistry();
            Preconditions.checkState((globalAccess != null ? 1 : 0) != 0, (Object)"Global registry access is not available");
            globalInstance = new Conversions(new RegistryOps.RegistryInfoLookup(){

                @Override
                public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryRef) {
                    HolderLookup.RegistryLookup registry = globalAccess.lookupOrThrow((ResourceKey)registryRef);
                    return Optional.of(new RegistryOps.RegistryInfo(registry, registry, registry.registryLifecycle()));
                }
            });
        }
        return globalInstance;
    }

    public Conversions(RegistryOps.RegistryInfoLookup lookup) {
        this.lookup = lookup;
        this.serializer = new WrapperAwareSerializer(() -> RegistryOps.create(JavaOps.INSTANCE, lookup));
    }

    public RegistryOps.RegistryInfoLookup lookup() {
        return this.lookup;
    }

    @Contract(value="null -> null; !null -> !null")
    public @Nullable Component asVanilla(@Nullable net.kyori.adventure.text.Component adventure) {
        if (adventure == null) {
            return null;
        }
        return this.serializer.serialize(adventure);
    }

    public net.kyori.adventure.text.Component asAdventure(@Nullable Component vanilla) {
        return vanilla == null ? net.kyori.adventure.text.Component.empty() : this.serializer.deserialize(vanilla);
    }
}

