/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record NamedRegistryKeySetImpl<T extends Keyed, M>(TagKey<T> tagKey, HolderSet.Named<M> namedSet) implements io.papermc.paper.registry.tag.Tag<T>,
Tag<T>
{
    public NamedRegistryKeySetImpl(HolderSet.Named<M> namedSet) {
        this(PaperRegistries.fromNms(namedSet.key()), namedSet);
    }

    public @Unmodifiable Collection<TypedKey<T>> values() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder holder : this.namedSet) {
            builder.add((Object)TypedKey.create((RegistryKey)this.tagKey.registryKey(), (Key)CraftNamespacedKey.fromMinecraft(((Holder.Reference)holder).key().location())));
        }
        return builder.build();
    }

    public RegistryKey<T> registryKey() {
        return this.tagKey.registryKey();
    }

    public boolean contains(TypedKey<T> valueKey) {
        return Iterables.any(this.namedSet, h -> PaperRegistries.fromNms(((Holder.Reference)h).key()).equals((Object)valueKey));
    }

    public @Unmodifiable Collection<T> resolve(Registry<T> registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Holder holder : this.namedSet) {
            builder.add((Object)registry.getOrThrow(CraftNamespacedKey.fromMinecraft(((Holder.Reference)holder).key().location())));
        }
        return builder.build();
    }

    public boolean isTagged(T item) {
        return this.getValues().contains(item);
    }

    public Set<T> getValues() {
        return Set.copyOf(this.resolve(RegistryAccess.registryAccess().getRegistry(this.registryKey())));
    }

    public NamespacedKey getKey() {
        Key key = this.tagKey().key();
        return new NamespacedKey(key.namespace(), key.value());
    }
}

