/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Optional<T> min();

    public Optional<T> max();

    default public boolean isAny() {
        return this.min().isEmpty() && this.max().isEmpty();
    }

    default public Optional<T> unwrapPoint() {
        Optional<T> optional1;
        Optional<T> optional = this.min();
        return optional.equals(optional1 = this.max()) ? optional : Optional.empty();
    }

    public static <T extends Number, R extends MinMaxBounds<T>> Codec<R> createCodec(Codec<T> codec, BoundsFactory<T, R> boundsFactory) {
        Codec codec1 = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min").forGetter(MinMaxBounds::min), (App)codec.optionalFieldOf("max").forGetter(MinMaxBounds::max)).apply((Applicative)instance, boundsFactory::create));
        return Codec.either((Codec)codec1, codec).xmap(either -> either.map(min -> min, max -> boundsFactory.create(Optional.of(max), Optional.of(max))), bounds -> {
            Optional optional = bounds.unwrapPoint();
            return optional.isPresent() ? Either.right((Number)optional.get()) : Either.left(bounds);
        });
    }

    public static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader reader, BoundsFromReaderFactory<T, R> boundedFactory, Function<String, T> valueFactory, Supplier<DynamicCommandExceptionType> commandExceptionSupplier, Function<T, T> formatter) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
        }
        int cursor = reader.getCursor();
        try {
            Optional<T> optional1;
            Optional<T> optional = MinMaxBounds.readNumber(reader, valueFactory, commandExceptionSupplier).map(formatter);
            if (reader.canRead(2) && reader.peek() == '.' && reader.peek(1) == '.') {
                reader.skip();
                reader.skip();
                optional1 = MinMaxBounds.readNumber(reader, valueFactory, commandExceptionSupplier).map(formatter);
                if (optional.isEmpty() && optional1.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
                }
            } else {
                optional1 = optional;
            }
            if (optional.isEmpty() && optional1.isEmpty()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
            }
            return boundedFactory.create(reader, optional, optional1);
        }
        catch (CommandSyntaxException var8) {
            reader.setCursor(cursor);
            throw new CommandSyntaxException(var8.getType(), var8.getRawMessage(), var8.getInput(), cursor);
        }
    }

    private static <T extends Number> Optional<T> readNumber(StringReader reader, Function<String, T> stringToValueFunction, Supplier<DynamicCommandExceptionType> commandExceptionSupplier) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && MinMaxBounds.isAllowedInputChat(reader)) {
            reader.skip();
        }
        String sub = reader.getString().substring(cursor, reader.getCursor());
        if (sub.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)stringToValueFunction.apply(sub));
        }
        catch (NumberFormatException var6) {
            throw commandExceptionSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)sub);
        }
    }

    private static boolean isAllowedInputChat(StringReader reader) {
        char c = reader.peek();
        return c >= '0' && c <= '9' || c == '-' || c == '.' && (!reader.canRead(2) || reader.peek(1) != '.');
    }

    @FunctionalInterface
    public static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public record Ints(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Optional.empty(), Optional.empty());
        public static final Codec<Ints> CODEC = MinMaxBounds.createCodec(Codec.INT, Ints::new);

        private Ints(Optional<Integer> min, Optional<Integer> max) {
            this(min, max, min.map(integer -> integer.longValue() * integer.longValue()), Ints.squareOpt(max));
        }

        private static Ints create(StringReader reader, Optional<Integer> min, Optional<Integer> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Ints(min, max);
        }

        private static Optional<Long> squareOpt(Optional<Integer> value) {
            return value.map(integer -> integer.longValue() * integer.longValue());
        }

        public static Ints exactly(int value) {
            return new Ints(Optional.of(value), Optional.of(value));
        }

        public static Ints between(int min, int max) {
            return new Ints(Optional.of(min), Optional.of(max));
        }

        public static Ints atLeast(int min) {
            return new Ints(Optional.of(min), Optional.empty());
        }

        public static Ints atMost(int max) {
            return new Ints(Optional.empty(), Optional.of(max));
        }

        public boolean matches(int value) {
            return !(this.min.isPresent() && this.min.get() > value || !this.max.isEmpty() && this.max.get() < value);
        }

        public boolean matchesSqr(long value) {
            return !(this.minSq.isPresent() && this.minSq.get() > value || !this.maxSq.isEmpty() && this.maxSq.get() < value);
        }

        public static Ints fromReader(StringReader reader) throws CommandSyntaxException {
            return Ints.fromReader(reader, integer -> integer);
        }

        public static Ints fromReader(StringReader reader, Function<Integer, Integer> valueFunction) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(reader, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), valueFunction);
        }
    }

    public record Doubles(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Optional.empty(), Optional.empty());
        public static final Codec<Doubles> CODEC = MinMaxBounds.createCodec(Codec.DOUBLE, Doubles::new);

        private Doubles(Optional<Double> min, Optional<Double> max) {
            this(min, max, Doubles.squareOpt(min), Doubles.squareOpt(max));
        }

        private static Doubles create(StringReader reader, Optional<Double> min, Optional<Double> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Doubles(min, max);
        }

        private static Optional<Double> squareOpt(Optional<Double> value) {
            return value.map(val -> val * val);
        }

        public static Doubles exactly(double value) {
            return new Doubles(Optional.of(value), Optional.of(value));
        }

        public static Doubles between(double min, double max) {
            return new Doubles(Optional.of(min), Optional.of(max));
        }

        public static Doubles atLeast(double min) {
            return new Doubles(Optional.of(min), Optional.empty());
        }

        public static Doubles atMost(double max) {
            return new Doubles(Optional.empty(), Optional.of(max));
        }

        public boolean matches(double value) {
            return !(this.min.isPresent() && this.min.get() > value || !this.max.isEmpty() && this.max.get() < value);
        }

        public boolean matchesSqr(double value) {
            return !(this.minSq.isPresent() && this.minSq.get() > value || !this.maxSq.isEmpty() && this.maxSq.get() < value);
        }

        public static Doubles fromReader(StringReader reader) throws CommandSyntaxException {
            return Doubles.fromReader(reader, _double -> _double);
        }

        public static Doubles fromReader(StringReader reader, Function<Double, Double> formatter) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(reader, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), formatter);
        }
    }
}

