/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;

public interface SharedSuggestionProvider {
    public static final CharMatcher MATCH_SPLITTER = CharMatcher.anyOf((CharSequence)"._/");

    public Collection<String> getOnlinePlayerNames();

    default public Collection<String> getCustomTabSugggestions() {
        return this.getOnlinePlayerNames();
    }

    default public Collection<String> getSelectedEntities() {
        return Collections.emptyList();
    }

    public Collection<String> getAllTeams();

    public Stream<ResourceLocation> getAvailableSounds();

    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> var1);

    default public Collection<TextCoordinates> getRelevantCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    default public Collection<TextCoordinates> getAbsoluteCoordinates() {
        return Collections.singleton(TextCoordinates.DEFAULT_GLOBAL);
    }

    public Set<ResourceKey<Level>> levels();

    public RegistryAccess registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public void suggestRegistryElements(Registry<?> registry, ElementSuggestionType type, SuggestionsBuilder builder) {
        if (type.shouldSuggestTags()) {
            SharedSuggestionProvider.suggestResource(registry.getTags().map(named -> named.key().location()), builder, "#");
        }
        if (type.shouldSuggestElements()) {
            SharedSuggestionProvider.suggestResource(registry.keySet(), builder);
        }
    }

    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> var1, ElementSuggestionType var2, SuggestionsBuilder var3, CommandContext<?> var4);

    public boolean hasPermission(int var1);

    public static <T> void filterResources(Iterable<T> resources, String input, Function<T, ResourceLocation> locationFunction, Consumer<T> resourceConsumer) {
        boolean flag = input.indexOf(58) > -1;
        for (T object : resources) {
            ResourceLocation resourceLocation = locationFunction.apply(object);
            if (flag) {
                String string = resourceLocation.toString();
                if (!SharedSuggestionProvider.matchesSubStr(input, string)) continue;
                resourceConsumer.accept(object);
                continue;
            }
            if (!SharedSuggestionProvider.matchesSubStr(input, resourceLocation.getNamespace()) && (!resourceLocation.getNamespace().equals("minecraft") || !SharedSuggestionProvider.matchesSubStr(input, resourceLocation.getPath()))) continue;
            resourceConsumer.accept(object);
        }
    }

    public static <T> void filterResources(Iterable<T> resources, String remaining, String prefix, Function<T, ResourceLocation> locationFunction, Consumer<T> resourceConsumer) {
        if (remaining.isEmpty()) {
            resources.forEach(resourceConsumer);
        } else {
            String string = Strings.commonPrefix((CharSequence)remaining, (CharSequence)prefix);
            if (!string.isEmpty()) {
                String sub = remaining.substring(string.length());
                SharedSuggestionProvider.filterResources(resources, sub, locationFunction, resourceConsumer);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> resources, SuggestionsBuilder builder, String prefix) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(resources, string, prefix, resourceLocation -> resourceLocation, resourceLocation -> builder.suggest(prefix + String.valueOf(resourceLocation)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> resources, SuggestionsBuilder builder, String prefix) {
        return SharedSuggestionProvider.suggestResource(resources::iterator, builder, prefix);
    }

    public static CompletableFuture<Suggestions> suggestResource(Iterable<ResourceLocation> resources, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(resources, string, resourceLocation -> resourceLocation, resourceLocation -> builder.suggest(resourceLocation.toString()));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Iterable<T> resources, SuggestionsBuilder builder, Function<T, ResourceLocation> locationFunction, Function<T, Message> suggestionFunction) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        SharedSuggestionProvider.filterResources(resources, string, locationFunction, object -> builder.suggest(((ResourceLocation)locationFunction.apply(object)).toString(), (Message)suggestionFunction.apply(object)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggestResource(Stream<ResourceLocation> resourceLocations, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource(resourceLocations::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> suggestResource(Stream<T> resources, SuggestionsBuilder builder, Function<T, ResourceLocation> locationFunction, Function<T, Message> suggestionFunction) {
        return SharedSuggestionProvider.suggestResource(resources::iterator, builder, locationFunction, suggestionFunction);
    }

    public static CompletableFuture<Suggestions> suggestCoordinates(String remaining, Collection<TextCoordinates> coordinates, SuggestionsBuilder builder, Predicate<String> validator) {
        ArrayList list;
        block4: {
            String[] parts;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)remaining)) break block3;
                    for (TextCoordinates textCoordinates : coordinates) {
                        String string = textCoordinates.x + " " + textCoordinates.y + " " + textCoordinates.z;
                        if (!validator.test(string)) continue;
                        list.add(textCoordinates.x);
                        list.add(textCoordinates.x + " " + textCoordinates.y);
                        list.add(string);
                    }
                    break block4;
                }
                parts = remaining.split(" ");
                if (parts.length != 1) break block5;
                for (TextCoordinates textCoordinates1 : coordinates) {
                    String string1 = parts[0] + " " + textCoordinates1.y + " " + textCoordinates1.z;
                    if (!validator.test(string1)) continue;
                    list.add(parts[0] + " " + textCoordinates1.y);
                    list.add(string1);
                }
                break block4;
            }
            if (parts.length != 2) break block4;
            for (TextCoordinates textCoordinates1x : coordinates) {
                String string1 = parts[0] + " " + parts[1] + " " + textCoordinates1x.z;
                if (!validator.test(string1)) continue;
                list.add(string1);
            }
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> suggest2DCoordinates(String remaining, Collection<TextCoordinates> coordinates, SuggestionsBuilder builder, Predicate<String> validator) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)remaining)) break block2;
                for (TextCoordinates textCoordinates : coordinates) {
                    String string = textCoordinates.x + " " + textCoordinates.z;
                    if (!validator.test(string)) continue;
                    list.add(textCoordinates.x);
                    list.add(string);
                }
                break block3;
            }
            String[] parts = remaining.split(" ");
            if (parts.length != 1) break block3;
            for (TextCoordinates textCoordinates1 : coordinates) {
                String string1 = parts[0] + " " + textCoordinates1.z;
                if (!validator.test(string1)) continue;
                list.add(string1);
            }
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string1 : strings) {
            if (!SharedSuggestionProvider.matchesSubStr(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Stream<String> strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        strings.filter(string1 -> SharedSuggestionProvider.matchesSubStr(string, string1.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(String[] strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string1 : strings) {
            if (!SharedSuggestionProvider.matchesSubStr(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1);
        }
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> suggest(Iterable<T> resources, SuggestionsBuilder builder, Function<T, String> stringFunction, Function<T, Message> suggestionFunction) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (T object : resources) {
            String string1 = stringFunction.apply(object);
            if (!SharedSuggestionProvider.matchesSubStr(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1, suggestionFunction.apply(object));
        }
        return builder.buildFuture();
    }

    public static boolean matchesSubStr(String input, String substring) {
        int i = 0;
        while (!substring.startsWith(input, i)) {
            int i1 = MATCH_SPLITTER.indexIn((CharSequence)substring, i);
            if (i1 < 0) {
                return false;
            }
            i = i1 + 1;
        }
        return true;
    }

    public static class TextCoordinates {
        public static final TextCoordinates DEFAULT_LOCAL = new TextCoordinates("^", "^", "^");
        public static final TextCoordinates DEFAULT_GLOBAL = new TextCoordinates("~", "~", "~");
        public final String x;
        public final String y;
        public final String z;

        public TextCoordinates(String x, String y, String z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static enum ElementSuggestionType {
        TAGS,
        ELEMENTS,
        ALL;


        public boolean shouldSuggestTags() {
            return this == TAGS || this == ALL;
        }

        public boolean shouldSuggestElements() {
            return this == ELEMENTS || this == ALL;
        }
    }
}

