/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NbtPathArgument
implements ArgumentType<NbtPath> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType ERROR_INVALID_NODE = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.node.invalid"));
    public static final SimpleCommandExceptionType ERROR_DATA_TOO_DEEP = new SimpleCommandExceptionType((Message)Component.translatable("arguments.nbtpath.too_deep"));
    public static final DynamicCommandExceptionType ERROR_NOTHING_FOUND = new DynamicCommandExceptionType(path -> Component.translatableEscape("arguments.nbtpath.nothing_found", path));
    static final DynamicCommandExceptionType ERROR_EXPECTED_LIST = new DynamicCommandExceptionType(actualType -> Component.translatableEscape("commands.data.modify.expected_list", actualType));
    static final DynamicCommandExceptionType ERROR_INVALID_INDEX = new DynamicCommandExceptionType(invalidIndex -> Component.translatableEscape("commands.data.modify.invalid_index", invalidIndex));
    private static final char INDEX_MATCH_START = '[';
    private static final char INDEX_MATCH_END = ']';
    private static final char KEY_MATCH_START = '{';
    private static final char KEY_MATCH_END = '}';
    private static final char QUOTED_KEY_START = '\"';
    private static final char SINGLE_QUOTED_KEY_START = '\'';

    public static NbtPathArgument nbtPath() {
        return new NbtPathArgument();
    }

    public static NbtPath getPath(CommandContext<CommandSourceStack> context, String name) {
        return (NbtPath)context.getArgument(name, NbtPath.class);
    }

    public NbtPath parse(StringReader reader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int cursor = reader.getCursor();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        boolean flag = true;
        while (reader.canRead() && reader.peek() != ' ') {
            char c;
            Node node = NbtPathArgument.parseNode(reader, flag);
            list.add(node);
            map.put((Object)node, reader.getCursor() - cursor);
            flag = false;
            if (!reader.canRead() || (c = reader.peek()) == ' ' || c == '[' || c == '{') continue;
            reader.expect('.');
        }
        return new NbtPath(reader.getString().substring(cursor, reader.getCursor()), list.toArray(new Node[0]), (Object2IntMap<Node>)map);
    }

    private static Node parseNode(StringReader reader, boolean first) throws CommandSyntaxException {
        return switch (reader.peek()) {
            case '\"', '\'' -> NbtPathArgument.readObjectNode(reader, reader.readString());
            case '[' -> {
                reader.skip();
                char i = reader.peek();
                if (i == '{') {
                    CompoundTag struct1 = new TagParser(reader).readStruct();
                    reader.expect(']');
                    yield new MatchElementNode(struct1);
                }
                if (i == ']') {
                    reader.skip();
                    yield AllElementsNode.INSTANCE;
                }
                int _int = reader.readInt();
                reader.expect(']');
                yield new IndexedElementNode(_int);
            }
            case '{' -> {
                if (!first) {
                    throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)reader);
                }
                CompoundTag struct = new TagParser(reader).readStruct();
                yield new MatchRootObjectNode(struct);
            }
            default -> NbtPathArgument.readObjectNode(reader, NbtPathArgument.readUnquotedName(reader));
        };
    }

    private static Node readObjectNode(StringReader reader, String name) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            CompoundTag struct = new TagParser(reader).readStruct();
            return new MatchObjectNode(name, struct);
        }
        return new CompoundChildNode(name);
    }

    private static String readUnquotedName(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && NbtPathArgument.isAllowedInUnquotedName(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == cursor) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)reader);
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isAllowedInUnquotedName(char ch) {
        return ch != ' ' && ch != '\"' && ch != '\'' && ch != '[' && ch != ']' && ch != '.' && ch != '{' && ch != '}';
    }

    static Predicate<Tag> createTagPredicate(CompoundTag tag) {
        return other -> NbtUtils.compareNbt(tag, other, true);
    }

    public static class NbtPath {
        private final String original;
        private final Object2IntMap<Node> nodeToOriginalPosition;
        private final Node[] nodes;
        public static final Codec<NbtPath> CODEC = Codec.STRING.comapFlatMap(string -> {
            try {
                NbtPath nbtPath = new NbtPathArgument().parse(new StringReader(string));
                return DataResult.success((Object)nbtPath);
            }
            catch (CommandSyntaxException var2) {
                return DataResult.error(() -> "Failed to parse path " + string + ": " + var2.getMessage());
            }
        }, NbtPath::asString);

        public static NbtPath of(String path) throws CommandSyntaxException {
            return new NbtPathArgument().parse(new StringReader(path));
        }

        public NbtPath(String original, Node[] nodes, Object2IntMap<Node> nodeToOriginPosition) {
            this.original = original;
            this.nodes = nodes;
            this.nodeToOriginalPosition = nodeToOriginPosition;
        }

        public List<Tag> get(Tag tag) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(tag);
            for (Node node : this.nodes) {
                if (!(list = node.get(list)).isEmpty()) continue;
                throw this.createNotFoundException(node);
            }
            return list;
        }

        public int countMatching(Tag tag) {
            List<Tag> list = Collections.singletonList(tag);
            for (Node node : this.nodes) {
                if (!(list = node.get(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<Tag> getOrCreateParents(Tag tag) throws CommandSyntaxException {
            List<Tag> list = Collections.singletonList(tag);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                Node node = this.nodes[i];
                int i1 = i + 1;
                if (!(list = node.getOrCreate(list, this.nodes[i1]::createPreferredParentTag)).isEmpty()) continue;
                throw this.createNotFoundException(node);
            }
            return list;
        }

        public List<Tag> getOrCreate(Tag tag, Supplier<Tag> supplier) throws CommandSyntaxException {
            List<Tag> parents = this.getOrCreateParents(tag);
            Node node = this.nodes[this.nodes.length - 1];
            return node.getOrCreate(parents, supplier);
        }

        private static int apply(List<Tag> tags, Function<Tag, Integer> function) {
            return tags.stream().map(function).reduce(0, (integer, integer1) -> integer + integer1);
        }

        public static boolean isTooDeep(Tag tag, int currentDepth) {
            block4: {
                block3: {
                    if (currentDepth >= 512) {
                        return true;
                    }
                    if (!(tag instanceof CompoundTag)) break block3;
                    CompoundTag compoundTag = (CompoundTag)tag;
                    for (String string : compoundTag.getAllKeys()) {
                        Tag tag1 = compoundTag.get(string);
                        if (tag1 == null || !NbtPath.isTooDeep(tag1, currentDepth + 1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(tag instanceof ListTag)) break block4;
                for (Tag tag2 : (ListTag)tag) {
                    if (!NbtPath.isTooDeep(tag2, currentDepth + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        public int set(Tag tag, Tag other) throws CommandSyntaxException {
            if (NbtPath.isTooDeep(other, this.estimatePathDepth())) {
                throw ERROR_DATA_TOO_DEEP.create();
            }
            Tag tag1 = other.copy();
            List<Tag> parents = this.getOrCreateParents(tag);
            if (parents.isEmpty()) {
                return 0;
            }
            Node node = this.nodes[this.nodes.length - 1];
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            return NbtPath.apply(parents, tag2 -> node.setTag((Tag)tag2, () -> {
                if (mutableBoolean.isFalse()) {
                    mutableBoolean.setTrue();
                    return tag1;
                }
                return tag1.copy();
            }));
        }

        private int estimatePathDepth() {
            return this.nodes.length;
        }

        public int insert(int index, CompoundTag rootTag, List<Tag> tagsToInsert) throws CommandSyntaxException {
            ArrayList<Tag> list = new ArrayList<Tag>(tagsToInsert.size());
            for (Tag tag : tagsToInsert) {
                Tag tag1 = tag.copy();
                list.add(tag1);
                if (!NbtPath.isTooDeep(tag1, this.estimatePathDepth())) continue;
                throw ERROR_DATA_TOO_DEEP.create();
            }
            List<Tag> collection = this.getOrCreate(rootTag, ListTag::new);
            int i = 0;
            boolean flag = false;
            for (Tag tag2 : collection) {
                if (!(tag2 instanceof CollectionTag)) {
                    throw ERROR_EXPECTED_LIST.create((Object)tag2);
                }
                CollectionTag collectionTag = (CollectionTag)tag2;
                boolean flag1 = false;
                int i1 = index < 0 ? collectionTag.size() + index + 1 : index;
                for (Tag tag3 : list) {
                    try {
                        if (!collectionTag.addTag(i1, flag ? tag3.copy() : tag3)) continue;
                        ++i1;
                        flag1 = true;
                    }
                    catch (IndexOutOfBoundsException var16) {
                        throw ERROR_INVALID_INDEX.create((Object)i1);
                    }
                }
                flag = true;
                i += flag1 ? 1 : 0;
            }
            return i;
        }

        public int remove(Tag tag) {
            List<Tag> list = Collections.singletonList(tag);
            for (int i = 0; i < this.nodes.length - 1; ++i) {
                list = this.nodes[i].get(list);
            }
            Node node = this.nodes[this.nodes.length - 1];
            return NbtPath.apply(list, node::removeTag);
        }

        private CommandSyntaxException createNotFoundException(Node node) {
            int _int = this.nodeToOriginalPosition.getInt((Object)node);
            return ERROR_NOTHING_FOUND.create((Object)this.original.substring(0, _int));
        }

        public String toString() {
            return this.original;
        }

        public String asString() {
            return this.original;
        }
    }

    static interface Node {
        public void getTag(Tag var1, List<Tag> var2);

        public void getOrCreateTag(Tag var1, Supplier<Tag> var2, List<Tag> var3);

        public Tag createPreferredParentTag();

        public int setTag(Tag var1, Supplier<Tag> var2);

        public int removeTag(Tag var1);

        default public List<Tag> get(List<Tag> tags) {
            return this.collect(tags, this::getTag);
        }

        default public List<Tag> getOrCreate(List<Tag> tags, Supplier<Tag> supplier) {
            return this.collect(tags, (tag, tagList) -> this.getOrCreateTag((Tag)tag, supplier, (List<Tag>)tagList));
        }

        default public List<Tag> collect(List<Tag> tags, BiConsumer<Tag, List<Tag>> consumer) {
            ArrayList list = Lists.newArrayList();
            for (Tag tag : tags) {
                consumer.accept(tag, list);
            }
            return list;
        }
    }

    static class MatchElementNode
    implements Node {
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchElementNode(CompoundTag pattern) {
            this.pattern = pattern;
            this.predicate = NbtPathArgument.createTagPredicate(pattern);
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                listTag.stream().filter(this.predicate).forEach(tags::add);
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                listTag.stream().filter(this.predicate).forEach(currentTag -> {
                    tags.add((Tag)currentTag);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    CompoundTag compoundTag = this.pattern.copy();
                    listTag.add(compoundTag);
                    tags.add(compoundTag);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            int i = 0;
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                int size = listTag.size();
                if (size == 0) {
                    listTag.add(supplier.get());
                    ++i;
                } else {
                    for (int i1 = 0; i1 < size; ++i1) {
                        Tag tag2;
                        Tag tag1 = listTag.get(i1);
                        if (!this.predicate.test(tag1) || (tag2 = supplier.get()).equals(tag1) || !listTag.setTag(i1, tag2)) continue;
                        ++i;
                    }
                }
            }
            return i;
        }

        @Override
        public int removeTag(Tag tag) {
            int i = 0;
            if (tag instanceof ListTag) {
                ListTag listTag = (ListTag)tag;
                for (int i1 = listTag.size() - 1; i1 >= 0; --i1) {
                    if (!this.predicate.test(listTag.get(i1))) continue;
                    listTag.remove(i1);
                    ++i;
                }
            }
            return i;
        }
    }

    static class AllElementsNode
    implements Node {
        public static final AllElementsNode INSTANCE = new AllElementsNode();

        private AllElementsNode() {
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            if (tag instanceof CollectionTag) {
                tags.addAll((CollectionTag)tag);
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            if (tag instanceof CollectionTag) {
                CollectionTag collectionTag = (CollectionTag)tag;
                if (collectionTag.isEmpty()) {
                    Tag tag1 = supplier.get();
                    if (collectionTag.addTag(0, tag1)) {
                        tags.add(tag1);
                    }
                } else {
                    tags.addAll(collectionTag);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            if (!(tag instanceof CollectionTag)) {
                return 0;
            }
            CollectionTag collectionTag = (CollectionTag)tag;
            int size = collectionTag.size();
            if (size == 0) {
                collectionTag.addTag(0, supplier.get());
                return 1;
            }
            Tag tag1 = supplier.get();
            int i = size - (int)collectionTag.stream().filter((Predicate<Tag>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/minecraft/nbt/Tag;)Z)((Tag)tag1)).count();
            if (i == 0) {
                return 0;
            }
            collectionTag.clear();
            if (!collectionTag.addTag(0, tag1)) {
                return 0;
            }
            for (int i1 = 1; i1 < size; ++i1) {
                collectionTag.addTag(i1, supplier.get());
            }
            return i;
        }

        @Override
        public int removeTag(Tag tag) {
            CollectionTag collectionTag;
            int size;
            if (tag instanceof CollectionTag && (size = (collectionTag = (CollectionTag)tag).size()) > 0) {
                collectionTag.clear();
                return size;
            }
            return 0;
        }
    }

    static class IndexedElementNode
    implements Node {
        private final int index;

        public IndexedElementNode(int index) {
            this.index = index;
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            if (tag instanceof CollectionTag) {
                int i;
                CollectionTag collectionTag = (CollectionTag)tag;
                int size = collectionTag.size();
                int n = i = this.index < 0 ? size + this.index : this.index;
                if (0 <= i && i < size) {
                    tags.add((Tag)collectionTag.get(i));
                }
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            this.getTag(tag, tags);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new ListTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            if (tag instanceof CollectionTag) {
                int i;
                CollectionTag collectionTag = (CollectionTag)tag;
                int size = collectionTag.size();
                int n = i = this.index < 0 ? size + this.index : this.index;
                if (0 <= i && i < size) {
                    Tag tag1 = (Tag)collectionTag.get(i);
                    Tag tag2 = supplier.get();
                    if (!tag2.equals(tag1) && collectionTag.setTag(i, tag2)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag tag) {
            if (tag instanceof CollectionTag) {
                int i;
                CollectionTag collectionTag = (CollectionTag)tag;
                int size = collectionTag.size();
                int n = i = this.index < 0 ? size + this.index : this.index;
                if (0 <= i && i < size) {
                    collectionTag.remove(i);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class MatchRootObjectNode
    implements Node {
        private final Predicate<Tag> predicate;

        public MatchRootObjectNode(CompoundTag tag) {
            this.predicate = NbtPathArgument.createTagPredicate(tag);
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            if (tag instanceof CompoundTag && this.predicate.test(tag)) {
                tags.add(tag);
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            this.getTag(tag, tags);
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            return 0;
        }

        @Override
        public int removeTag(Tag tag) {
            return 0;
        }
    }

    static class MatchObjectNode
    implements Node {
        private final String name;
        private final CompoundTag pattern;
        private final Predicate<Tag> predicate;

        public MatchObjectNode(String name, CompoundTag pattern) {
            this.name = name;
            this.pattern = pattern;
            this.predicate = NbtPathArgument.createTagPredicate(pattern);
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            Tag tag1;
            if (tag instanceof CompoundTag && this.predicate.test(tag1 = ((CompoundTag)tag).get(this.name))) {
                tags.add(tag1);
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                Tag tag1 = compoundTag.get(this.name);
                if (tag1 == null) {
                    CompoundTag var6 = this.pattern.copy();
                    compoundTag.put(this.name, var6);
                    tags.add(var6);
                } else if (this.predicate.test(tag1)) {
                    tags.add(tag1);
                }
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            Tag tag2;
            CompoundTag compoundTag;
            Tag tag1;
            if (tag instanceof CompoundTag && this.predicate.test(tag1 = (compoundTag = (CompoundTag)tag).get(this.name)) && !(tag2 = supplier.get()).equals(tag1)) {
                compoundTag.put(this.name, tag2);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeTag(Tag tag) {
            CompoundTag compoundTag;
            Tag tag1;
            if (tag instanceof CompoundTag && this.predicate.test(tag1 = (compoundTag = (CompoundTag)tag).get(this.name))) {
                compoundTag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class CompoundChildNode
    implements Node {
        private final String name;

        public CompoundChildNode(String name) {
            this.name = name;
        }

        @Override
        public void getTag(Tag tag, List<Tag> tags) {
            Tag tag1;
            if (tag instanceof CompoundTag && (tag1 = ((CompoundTag)tag).get(this.name)) != null) {
                tags.add(tag1);
            }
        }

        @Override
        public void getOrCreateTag(Tag tag, Supplier<Tag> supplier, List<Tag> tags) {
            if (tag instanceof CompoundTag) {
                Tag tag1;
                CompoundTag compoundTag = (CompoundTag)tag;
                if (compoundTag.contains(this.name)) {
                    tag1 = compoundTag.get(this.name);
                } else {
                    tag1 = supplier.get();
                    compoundTag.put(this.name, tag1);
                }
                tags.add(tag1);
            }
        }

        @Override
        public Tag createPreferredParentTag() {
            return new CompoundTag();
        }

        @Override
        public int setTag(Tag tag, Supplier<Tag> supplier) {
            if (tag instanceof CompoundTag) {
                Tag tag2;
                CompoundTag compoundTag = (CompoundTag)tag;
                Tag tag1 = supplier.get();
                if (!tag1.equals(tag2 = compoundTag.put(this.name, tag1))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int removeTag(Tag tag) {
            CompoundTag compoundTag;
            if (tag instanceof CompoundTag && (compoundTag = (CompoundTag)tag).contains(this.name)) {
                compoundTag.remove(this.name);
                return 1;
            }
            return 0;
        }
    }
}

