/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;

public class WorldCoordinate {
    private static final char PREFIX_RELATIVE = '~';
    public static final SimpleCommandExceptionType ERROR_EXPECTED_DOUBLE = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.double"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_INT = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.int"));
    private final boolean relative;
    private final double value;

    public WorldCoordinate(boolean relative, double value) {
        this.relative = relative;
        this.value = value;
    }

    public double get(double coord) {
        return this.relative ? this.value + coord : this.value;
    }

    public static WorldCoordinate parseDouble(StringReader reader, boolean centerCorrect) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)reader);
        }
        boolean isRelative = WorldCoordinate.isRelative(reader);
        int cursor = reader.getCursor();
        double d = reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
        String sub = reader.getString().substring(cursor, reader.getCursor());
        if (isRelative && sub.isEmpty()) {
            return new WorldCoordinate(true, 0.0);
        }
        if (!sub.contains(".") && !isRelative && centerCorrect) {
            d += 0.5;
        }
        return new WorldCoordinate(isRelative, d);
    }

    public static WorldCoordinate parseInt(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw ERROR_EXPECTED_INT.createWithContext((ImmutableStringReader)reader);
        }
        boolean isRelative = WorldCoordinate.isRelative(reader);
        double d = reader.canRead() && reader.peek() != ' ' ? (isRelative ? reader.readDouble() : (double)reader.readInt()) : 0.0;
        return new WorldCoordinate(isRelative, d);
    }

    public static boolean isRelative(StringReader reader) {
        boolean flag;
        if (reader.peek() == '~') {
            flag = true;
            reader.skip();
        } else {
            flag = false;
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof WorldCoordinate)) return false;
        WorldCoordinate worldCoordinate = (WorldCoordinate)other;
        if (this.relative != worldCoordinate.relative) return false;
        if (Double.compare(worldCoordinate.value, this.value) != 0) return false;
        return true;
    }

    public int hashCode() {
        int i = this.relative ? 1 : 0;
        long l = Double.doubleToLongBits(this.value);
        return 31 * i + (int)(l ^ l >>> 32);
    }

    public boolean isRelative() {
        return this.relative;
    }
}

