/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.util.parsing.packrat.commands.ResourceLookupRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.TagParseRule;

public class ComponentPredicateParser {
    public static <T, C, P> Grammar<List<T>> createGrammar(Context<T, C, P> context) {
        Atom atom = Atom.of("top");
        Atom atom1 = Atom.of("type");
        Atom atom2 = Atom.of("any_type");
        Atom atom3 = Atom.of("element_type");
        Atom atom4 = Atom.of("tag_type");
        Atom atom5 = Atom.of("conditions");
        Atom atom6 = Atom.of("alternatives");
        Atom atom7 = Atom.of("term");
        Atom atom8 = Atom.of("negation");
        Atom atom9 = Atom.of("test");
        Atom atom10 = Atom.of("component_type");
        Atom atom11 = Atom.of("predicate_type");
        Atom<ResourceLocation> atom12 = Atom.of("id");
        Atom atom13 = Atom.of("tag");
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        dictionary.put(atom, Term.alternative(Term.sequence(Term.named(atom1), StringReaderTerms.character('['), Term.cut(), Term.optional(Term.named(atom5)), StringReaderTerms.character(']')), Term.named(atom1)), scope -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Optional)scope.getOrThrow(atom1)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            List list = (List)scope.get(atom5);
            if (list != null) {
                builder.addAll((Iterable)list);
            }
            return builder.build();
        });
        dictionary.put(atom1, Term.alternative(Term.named(atom3), Term.sequence(StringReaderTerms.character('#'), Term.cut(), Term.named(atom4)), Term.named(atom2)), scope -> Optional.ofNullable(scope.getAny(atom3, atom4)));
        dictionary.put(atom2, StringReaderTerms.character('*'), scope -> Unit.INSTANCE);
        dictionary.put(atom3, new ElementLookupRule<T, C, P>(atom12, context));
        dictionary.put(atom4, new TagLookupRule<T, C, P>(atom12, context));
        dictionary.put(atom5, Term.sequence(Term.named(atom6), Term.optional(Term.sequence(StringReaderTerms.character(','), Term.named(atom5)))), scope -> {
            Object object = context.anyOf((List)scope.getOrThrow(atom6));
            return Optional.ofNullable((List)scope.get(atom5)).map(list -> Util.copyAndAdd(object, list)).orElse(List.of(object));
        });
        dictionary.put(atom6, Term.sequence(Term.named(atom7), Term.optional(Term.sequence(StringReaderTerms.character('|'), Term.named(atom6)))), scope -> {
            Object orThrow = scope.getOrThrow(atom7);
            return Optional.ofNullable((List)scope.get(atom6)).map(list -> Util.copyAndAdd(orThrow, list)).orElse(List.of(orThrow));
        });
        dictionary.put(atom7, Term.alternative(Term.named(atom9), Term.sequence(StringReaderTerms.character('!'), Term.named(atom8))), scope -> scope.getAnyOrThrow(atom9, atom8));
        dictionary.put(atom8, Term.named(atom9), scope -> context.negate(scope.getOrThrow(atom9)));
        dictionary.put(atom9, Term.alternative(Term.sequence(Term.named(atom10), StringReaderTerms.character('='), Term.cut(), Term.named(atom13)), Term.sequence(Term.named(atom11), StringReaderTerms.character('~'), Term.cut(), Term.named(atom13)), Term.named(atom10)), (parseState, scope) -> {
            Object object = scope.get(atom11);
            try {
                if (object != null) {
                    Tag tag = (Tag)scope.getOrThrow(atom13);
                    return Optional.of(context.createPredicateTest((ImmutableStringReader)parseState.input(), object, tag));
                }
                Object orThrow = scope.getOrThrow(atom10);
                Tag tag1 = (Tag)scope.get(atom13);
                return Optional.of(tag1 != null ? context.createComponentTest((ImmutableStringReader)parseState.input(), orThrow, tag1) : context.createComponentTest((ImmutableStringReader)parseState.input(), orThrow));
            }
            catch (CommandSyntaxException var9x) {
                parseState.errorCollector().store(parseState.mark(), var9x);
                return Optional.empty();
            }
        });
        dictionary.put(atom10, new ComponentLookupRule<T, C, P>(atom12, context));
        dictionary.put(atom11, new PredicateLookupRule<T, C, P>(atom12, context));
        dictionary.put(atom13, TagParseRule.INSTANCE);
        dictionary.put(atom12, ResourceLocationParseRule.INSTANCE);
        return new Grammar<List<T>>(dictionary, atom);
    }

    static class ElementLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        ElementLookupRule(Atom<ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).forElementType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listElementTypes();
        }
    }

    public static interface Context<T, C, P> {
        public T forElementType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listElementTypes();

        public T forTagType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listTagTypes();

        public C lookupComponentType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listComponentTypes();

        public T createComponentTest(ImmutableStringReader var1, C var2, Tag var3) throws CommandSyntaxException;

        public T createComponentTest(ImmutableStringReader var1, C var2);

        public P lookupPredicateType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listPredicateTypes();

        public T createPredicateTest(ImmutableStringReader var1, P var2, Tag var3) throws CommandSyntaxException;

        public T negate(T var1);

        public T anyOf(List<T> var1);
    }

    static class TagLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        TagLookupRule(Atom<ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).forTagType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listTagTypes();
        }
    }

    static class ComponentLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, C> {
        ComponentLookupRule(Atom<ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected C validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).lookupComponentType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listComponentTypes();
        }
    }

    static class PredicateLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, P> {
        PredicateLookupRule(Atom<ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected P validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).lookupPredicateType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listPredicateTypes();
        }
    }
}

