/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ComponentPredicateParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo:'bar'}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(item -> Component.translatableEscape("argument.item.id.invalid", item));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(tag -> Component.translatableEscape("arguments.item.tag.unknown", tag));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(component -> Component.translatableEscape("arguments.item.component.unknown", component));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((component, value) -> Component.translatableEscape("arguments.item.component.malformed", component, value));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_PREDICATE = new DynamicCommandExceptionType(predicate -> Component.translatableEscape("arguments.item.predicate.unknown", predicate));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_PREDICATE = new Dynamic2CommandExceptionType((predicate, value) -> Component.translatableEscape("arguments.item.predicate.malformed", predicate, value));
    private static final ResourceLocation COUNT_ID = ResourceLocation.withDefaultNamespace("count");
    static final Map<ResourceLocation, ComponentWrapper> PSEUDO_COMPONENTS = Stream.of(new ComponentWrapper(COUNT_ID, itemStack -> true, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map(ints -> itemStack -> ints.matches(itemStack.getCount())))).collect(Collectors.toUnmodifiableMap(ComponentWrapper::id, componentWrapper -> componentWrapper));
    static final Map<ResourceLocation, PredicateWrapper> PSEUDO_PREDICATES = Stream.of(new PredicateWrapper(COUNT_ID, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map(ints -> itemStack -> ints.matches(itemStack.getCount())))).collect(Collectors.toUnmodifiableMap(PredicateWrapper::id, predicateWrapper -> predicateWrapper));
    private final Grammar<List<Predicate<ItemStack>>> grammarWithContext;

    public ItemPredicateArgument(CommandBuildContext context) {
        Context context1 = new Context(context);
        this.grammarWithContext = ComponentPredicateParser.createGrammar(context1);
    }

    public static ItemPredicateArgument itemPredicate(CommandBuildContext context) {
        return new ItemPredicateArgument(context);
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        return Util.allOf(this.grammarWithContext.parseForCommands(reader))::test;
    }

    public static Result getItemPredicate(CommandContext<CommandSourceStack> context, String name) {
        return (Result)context.getArgument(name, Result.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return this.grammarWithContext.parseForSuggestions(builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static class Context
    implements ComponentPredicateParser.Context<Predicate<ItemStack>, ComponentWrapper, PredicateWrapper> {
        private final HolderLookup.RegistryLookup<Item> items;
        private final HolderLookup.RegistryLookup<DataComponentType<?>> components;
        private final HolderLookup.RegistryLookup<ItemSubPredicate.Type<?>> predicates;
        private final RegistryOps<Tag> registryOps;

        Context(HolderLookup.Provider registries) {
            this.items = registries.lookupOrThrow(Registries.ITEM);
            this.components = registries.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            this.predicates = registries.lookupOrThrow(Registries.ITEM_SUB_PREDICATE_TYPE);
            this.registryOps = registries.createSerializationContext(NbtOps.INSTANCE);
        }

        @Override
        public Predicate<ItemStack> forElementType(ImmutableStringReader reader, ResourceLocation elementType) throws CommandSyntaxException {
            Holder.Reference<Item> reference = this.items.get(ResourceKey.create(Registries.ITEM, elementType)).orElseThrow(() -> ERROR_UNKNOWN_ITEM.createWithContext(reader, (Object)elementType));
            return itemStack -> itemStack.is(reference);
        }

        @Override
        public Predicate<ItemStack> forTagType(ImmutableStringReader reader, ResourceLocation tagType) throws CommandSyntaxException {
            HolderSet holderSet = this.items.get(TagKey.create(Registries.ITEM, tagType)).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext(reader, (Object)tagType));
            return itemStack -> itemStack.is(holderSet);
        }

        @Override
        public ComponentWrapper lookupComponentType(ImmutableStringReader reader, ResourceLocation componentType) throws CommandSyntaxException {
            ComponentWrapper componentWrapper = PSEUDO_COMPONENTS.get(componentType);
            if (componentWrapper != null) {
                return componentWrapper;
            }
            DataComponentType dataComponentType = this.components.get(ResourceKey.create(Registries.DATA_COMPONENT_TYPE, componentType)).map(Holder::value).orElseThrow(() -> ERROR_UNKNOWN_COMPONENT.createWithContext(reader, (Object)componentType));
            return ComponentWrapper.create(reader, componentType, dataComponentType);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader reader, ComponentWrapper context, Tag value) throws CommandSyntaxException {
            return context.decode(reader, this.registryOps, value);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader reader, ComponentWrapper context) {
            return context.presenceChecker;
        }

        @Override
        public PredicateWrapper lookupPredicateType(ImmutableStringReader reader, ResourceLocation predicateType) throws CommandSyntaxException {
            PredicateWrapper predicateWrapper = PSEUDO_PREDICATES.get(predicateType);
            return predicateWrapper != null ? predicateWrapper : this.predicates.get(ResourceKey.create(Registries.ITEM_SUB_PREDICATE_TYPE, predicateType)).map(PredicateWrapper::new).orElseThrow(() -> ERROR_UNKNOWN_PREDICATE.createWithContext(reader, (Object)predicateType));
        }

        @Override
        public Predicate<ItemStack> createPredicateTest(ImmutableStringReader reader, PredicateWrapper predicate, Tag value) throws CommandSyntaxException {
            return predicate.decode(reader, this.registryOps, value);
        }

        @Override
        public Stream<ResourceLocation> listElementTypes() {
            return this.items.listElementIds().map(ResourceKey::location);
        }

        @Override
        public Stream<ResourceLocation> listTagTypes() {
            return this.items.listTagIds().map(TagKey::location);
        }

        @Override
        public Stream<ResourceLocation> listComponentTypes() {
            return Stream.concat(PSEUDO_COMPONENTS.keySet().stream(), this.components.listElements().filter(reference -> !((DataComponentType)reference.value()).isTransient()).map(reference -> reference.key().location()));
        }

        @Override
        public Stream<ResourceLocation> listPredicateTypes() {
            return Stream.concat(PSEUDO_PREDICATES.keySet().stream(), this.predicates.listElementIds().map(ResourceKey::location));
        }

        @Override
        public Predicate<ItemStack> negate(Predicate<ItemStack> value) {
            return value.negate();
        }

        @Override
        public Predicate<ItemStack> anyOf(List<Predicate<ItemStack>> values) {
            return Util.anyOf(values);
        }
    }

    public static interface Result
    extends Predicate<ItemStack> {
    }

    record ComponentWrapper(ResourceLocation id, Predicate<ItemStack> presenceChecker, Decoder<? extends Predicate<ItemStack>> valueChecker) {
        public static <T> ComponentWrapper create(ImmutableStringReader reader, ResourceLocation id, DataComponentType<T> componentType) throws CommandSyntaxException {
            Codec<T> codec = componentType.codec();
            if (codec == null) {
                throw ERROR_UNKNOWN_COMPONENT.createWithContext(reader, (Object)id);
            }
            return new ComponentWrapper(id, itemStack -> itemStack.has(componentType), (Decoder<? extends Predicate<ItemStack>>)codec.map(object -> itemStack -> {
                Object object1 = itemStack.get(componentType);
                return Objects.equals(object, object1);
            }));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader reader, RegistryOps<Tag> ops, Tag value) throws CommandSyntaxException {
            DataResult dataResult = this.valueChecker.parse(ops, (Object)value);
            return (Predicate)dataResult.getOrThrow(string -> ERROR_MALFORMED_COMPONENT.createWithContext(reader, (Object)this.id.toString(), string));
        }
    }

    record PredicateWrapper(ResourceLocation id, Decoder<? extends Predicate<ItemStack>> type) {
        public PredicateWrapper(Holder.Reference<ItemSubPredicate.Type<?>> predicate) {
            this(predicate.key().location(), (Decoder<? extends Predicate<ItemStack>>)predicate.value().codec().map(itemSubPredicate -> itemSubPredicate::matches));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader reader, RegistryOps<Tag> ops, Tag value) throws CommandSyntaxException {
            DataResult dataResult = this.type.parse(ops, (Object)value);
            return (Predicate)dataResult.getOrThrow(string -> ERROR_MALFORMED_PREDICATE.createWithContext(reader, (Object)this.id.toString(), string));
        }
    }
}

