/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;

public class EntitySelectorOptions {
    private static final Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(option -> Component.translatableEscape("argument.entity.options.unknown", option));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(option -> Component.translatableEscape("argument.entity.options.inapplicable", option));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(sort -> Component.translatableEscape("argument.entity.options.sort.irreversible", sort));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(gameMode -> Component.translatableEscape("argument.entity.options.mode.invalid", gameMode));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(type -> Component.translatableEscape("argument.entity.options.type.invalid", type));

    private static void register(String id, Modifier handler, Predicate<EntitySelectorParser> predicate, Component tooltip) {
        OPTIONS.put(id, new Option(handler, predicate, tooltip));
    }

    public static void bootStrap() {
        if (OPTIONS.isEmpty()) {
            EntitySelectorOptions.register("name", parser -> {
                int cursor = parser.getReader().getCursor();
                boolean shouldInvertValue = parser.shouldInvertValue();
                String string = parser.getReader().readString();
                if (parser.hasNameNotEquals() && !shouldInvertValue) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)parser.getReader(), (Object)"name");
                }
                if (shouldInvertValue) {
                    parser.setHasNameNotEquals(true);
                } else {
                    parser.setHasNameEquals(true);
                }
                parser.addPredicate(entity -> entity.getName().getString().equals(string) != shouldInvertValue);
            }, parser -> !parser.hasNameEquals(), Component.translatable("argument.entity.options.name.description"));
            EntitySelectorOptions.register("distance", parser -> {
                int cursor = parser.getReader().getCursor();
                MinMaxBounds.Doubles doubles = MinMaxBounds.Doubles.fromReader(parser.getReader());
                if (doubles.min().isPresent() && doubles.min().get() < 0.0 || doubles.max().isPresent() && doubles.max().get() < 0.0) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)parser.getReader());
                }
                parser.setDistance(doubles);
                parser.setWorldLimited();
            }, parser -> parser.getDistance().isAny(), Component.translatable("argument.entity.options.distance.description"));
            EntitySelectorOptions.register("level", parser -> {
                int cursor = parser.getReader().getCursor();
                MinMaxBounds.Ints ints = MinMaxBounds.Ints.fromReader(parser.getReader());
                if (ints.min().isPresent() && ints.min().get() < 0 || ints.max().isPresent() && ints.max().get() < 0) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)parser.getReader());
                }
                parser.setLevel(ints);
                parser.setIncludesEntities(false);
            }, parser -> parser.getLevel().isAny(), Component.translatable("argument.entity.options.level.description"));
            EntitySelectorOptions.register("x", parser -> {
                parser.setWorldLimited();
                parser.setX(parser.getReader().readDouble());
            }, parser -> parser.getX() == null, Component.translatable("argument.entity.options.x.description"));
            EntitySelectorOptions.register("y", parser -> {
                parser.setWorldLimited();
                parser.setY(parser.getReader().readDouble());
            }, parser -> parser.getY() == null, Component.translatable("argument.entity.options.y.description"));
            EntitySelectorOptions.register("z", parser -> {
                parser.setWorldLimited();
                parser.setZ(parser.getReader().readDouble());
            }, parser -> parser.getZ() == null, Component.translatable("argument.entity.options.z.description"));
            EntitySelectorOptions.register("dx", parser -> {
                parser.setWorldLimited();
                parser.setDeltaX(parser.getReader().readDouble());
            }, parser -> parser.getDeltaX() == null, Component.translatable("argument.entity.options.dx.description"));
            EntitySelectorOptions.register("dy", parser -> {
                parser.setWorldLimited();
                parser.setDeltaY(parser.getReader().readDouble());
            }, parser -> parser.getDeltaY() == null, Component.translatable("argument.entity.options.dy.description"));
            EntitySelectorOptions.register("dz", parser -> {
                parser.setWorldLimited();
                parser.setDeltaZ(parser.getReader().readDouble());
            }, parser -> parser.getDeltaZ() == null, Component.translatable("argument.entity.options.dz.description"));
            EntitySelectorOptions.register("x_rotation", parser -> parser.setRotX(WrappedMinMaxBounds.fromReader(parser.getReader(), true, Mth::wrapDegrees)), parser -> parser.getRotX() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.x_rotation.description"));
            EntitySelectorOptions.register("y_rotation", parser -> parser.setRotY(WrappedMinMaxBounds.fromReader(parser.getReader(), true, Mth::wrapDegrees)), parser -> parser.getRotY() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.y_rotation.description"));
            EntitySelectorOptions.register("limit", parser -> {
                int cursor = parser.getReader().getCursor();
                int _int = parser.getReader().readInt();
                if (_int < 1) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)parser.getReader());
                }
                parser.setMaxResults(_int);
                parser.setLimited(true);
            }, parser -> !parser.isCurrentEntity() && !parser.isLimited(), Component.translatable("argument.entity.options.limit.description"));
            EntitySelectorOptions.register("sort", parser -> {
                int cursor = parser.getReader().getCursor();
                String unquotedString = parser.getReader().readUnquotedString();
                parser.setSuggestions((builder, consumer) -> SharedSuggestionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), builder));
                parser.setOrder(switch (unquotedString) {
                    case "nearest" -> EntitySelectorParser.ORDER_NEAREST;
                    case "furthest" -> EntitySelectorParser.ORDER_FURTHEST;
                    case "random" -> EntitySelectorParser.ORDER_RANDOM;
                    case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                    default -> {
                        parser.getReader().setCursor(cursor);
                        throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)parser.getReader(), (Object)unquotedString);
                    }
                });
                parser.setSorted(true);
            }, parser -> !parser.isCurrentEntity() && !parser.isSorted(), Component.translatable("argument.entity.options.sort.description"));
            EntitySelectorOptions.register("gamemode", parser -> {
                parser.setSuggestions((builder, consumer) -> {
                    String string = builder.getRemaining().toLowerCase(Locale.ROOT);
                    boolean flag = !parser.hasGamemodeNotEquals();
                    boolean flag1 = true;
                    if (!string.isEmpty()) {
                        if (string.charAt(0) == '!') {
                            flag = false;
                            string = string.substring(1);
                        } else {
                            flag1 = false;
                        }
                    }
                    for (GameType gameType1 : GameType.values()) {
                        if (!gameType1.getName().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                        if (flag1) {
                            builder.suggest("!" + gameType1.getName());
                        }
                        if (!flag) continue;
                        builder.suggest(gameType1.getName());
                    }
                    return builder.buildFuture();
                });
                int cursor = parser.getReader().getCursor();
                boolean shouldInvertValue = parser.shouldInvertValue();
                if (parser.hasGamemodeNotEquals() && !shouldInvertValue) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)parser.getReader(), (Object)"gamemode");
                }
                String unquotedString = parser.getReader().readUnquotedString();
                GameType gameType = GameType.byName(unquotedString, null);
                if (gameType == null) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)parser.getReader(), (Object)unquotedString);
                }
                parser.setIncludesEntities(false);
                parser.addPredicate(entity -> {
                    if (!(entity instanceof ServerPlayer)) {
                        return false;
                    }
                    GameType gameModeForPlayer = ((ServerPlayer)entity).gameMode.getGameModeForPlayer();
                    return shouldInvertValue ? gameModeForPlayer != gameType : gameModeForPlayer == gameType;
                });
                if (shouldInvertValue) {
                    parser.setHasGamemodeNotEquals(true);
                } else {
                    parser.setHasGamemodeEquals(true);
                }
            }, parser -> !parser.hasGamemodeEquals(), Component.translatable("argument.entity.options.gamemode.description"));
            EntitySelectorOptions.register("team", parser -> {
                boolean shouldInvertValue = parser.shouldInvertValue();
                String unquotedString = parser.getReader().readUnquotedString();
                parser.addPredicate(entity -> {
                    if (!(entity instanceof LivingEntity)) {
                        return false;
                    }
                    PlayerTeam team = entity.getTeam();
                    String string = team == null ? "" : ((Team)team).getName();
                    return string.equals(unquotedString) != shouldInvertValue;
                });
                if (shouldInvertValue) {
                    parser.setHasTeamNotEquals(true);
                } else {
                    parser.setHasTeamEquals(true);
                }
            }, parser -> !parser.hasTeamEquals(), Component.translatable("argument.entity.options.team.description"));
            EntitySelectorOptions.register("type", parser -> {
                parser.setSuggestions((suggestionsBuilder, consumer) -> {
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), suggestionsBuilder, String.valueOf('!'));
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(named -> named.key().location()), suggestionsBuilder, "!#");
                    if (!parser.isTypeLimitedInversely()) {
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), suggestionsBuilder);
                        SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(named -> named.key().location()), suggestionsBuilder, String.valueOf('#'));
                    }
                    return suggestionsBuilder.buildFuture();
                });
                int cursor = parser.getReader().getCursor();
                boolean shouldInvertValue = parser.shouldInvertValue();
                if (parser.isTypeLimitedInversely() && !shouldInvertValue) {
                    parser.getReader().setCursor(cursor);
                    throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)parser.getReader(), (Object)"type");
                }
                if (shouldInvertValue) {
                    parser.setTypeLimitedInversely();
                }
                if (parser.isTag()) {
                    TagKey<EntityType<?>> tagKey = TagKey.create(Registries.ENTITY_TYPE, ResourceLocation.read(parser.getReader()));
                    parser.addPredicate(entity -> entity.getType().is(tagKey) != shouldInvertValue);
                } else {
                    ResourceLocation resourceLocation = ResourceLocation.read(parser.getReader());
                    EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(resourceLocation).orElseThrow(() -> {
                        parser.getReader().setCursor(cursor);
                        return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)parser.getReader(), (Object)resourceLocation.toString());
                    });
                    if (Objects.equals(EntityType.PLAYER, entityType) && !shouldInvertValue) {
                        parser.setIncludesEntities(false);
                    }
                    parser.addPredicate(entity -> Objects.equals(entityType, entity.getType()) != shouldInvertValue);
                    if (!shouldInvertValue) {
                        parser.limitToType(entityType);
                    }
                }
            }, entitySelectorParser -> !entitySelectorParser.isTypeLimited(), Component.translatable("argument.entity.options.type.description"));
            EntitySelectorOptions.register("tag", parser -> {
                boolean shouldInvertValue = parser.shouldInvertValue();
                String unquotedString = parser.getReader().readUnquotedString();
                parser.addPredicate(entity -> "".equals(unquotedString) ? entity.getTags().isEmpty() != shouldInvertValue : entity.getTags().contains(unquotedString) != shouldInvertValue);
            }, entitySelectorParser -> true, Component.translatable("argument.entity.options.tag.description"));
            EntitySelectorOptions.register("nbt", parser -> {
                boolean shouldInvertValue = parser.shouldInvertValue();
                CompoundTag struct = new TagParser(parser.getReader()).readStruct();
                parser.addPredicate(entity -> {
                    ServerPlayer serverPlayer;
                    ItemStack selected;
                    CompoundTag compoundTag = entity.saveWithoutId(new CompoundTag());
                    if (entity instanceof ServerPlayer && !(selected = (serverPlayer = (ServerPlayer)entity).getInventory().getSelected()).isEmpty()) {
                        compoundTag.put("SelectedItem", selected.save(serverPlayer.registryAccess()));
                    }
                    return NbtUtils.compareNbt(struct, compoundTag, true) != shouldInvertValue;
                });
            }, entitySelectorParser -> true, Component.translatable("argument.entity.options.nbt.description"));
            EntitySelectorOptions.register("scores", parser -> {
                StringReader reader = parser.getReader();
                HashMap map = Maps.newHashMap();
                reader.expect('{');
                reader.skipWhitespace();
                while (reader.canRead() && reader.peek() != '}') {
                    reader.skipWhitespace();
                    String unquotedString = reader.readUnquotedString();
                    reader.skipWhitespace();
                    reader.expect('=');
                    reader.skipWhitespace();
                    MinMaxBounds.Ints ints = MinMaxBounds.Ints.fromReader(reader);
                    map.put(unquotedString, ints);
                    reader.skipWhitespace();
                    if (!reader.canRead() || reader.peek() != ',') continue;
                    reader.skip();
                }
                reader.expect('}');
                if (!map.isEmpty()) {
                    parser.addPredicate(entity -> {
                        ServerScoreboard scoreboard = entity.getServer().getScoreboard();
                        for (Map.Entry entry : map.entrySet()) {
                            Objective objective = scoreboard.getObjective((String)entry.getKey());
                            if (objective == null) {
                                return false;
                            }
                            ReadOnlyScoreInfo playerScoreInfo = scoreboard.getPlayerScoreInfo((ScoreHolder)entity, objective);
                            if (playerScoreInfo == null) {
                                return false;
                            }
                            if (((MinMaxBounds.Ints)entry.getValue()).matches(playerScoreInfo.value())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                parser.setHasScores(true);
            }, entitySelectorParser -> !entitySelectorParser.hasScores(), Component.translatable("argument.entity.options.scores.description"));
            EntitySelectorOptions.register("advancements", parser -> {
                StringReader reader = parser.getReader();
                HashMap map = Maps.newHashMap();
                reader.expect('{');
                reader.skipWhitespace();
                while (reader.canRead() && reader.peek() != '}') {
                    reader.skipWhitespace();
                    ResourceLocation resourceLocation = ResourceLocation.read(reader);
                    reader.skipWhitespace();
                    reader.expect('=');
                    reader.skipWhitespace();
                    if (reader.canRead() && reader.peek() == '{') {
                        HashMap map1 = Maps.newHashMap();
                        reader.skipWhitespace();
                        reader.expect('{');
                        reader.skipWhitespace();
                        while (reader.canRead() && reader.peek() != '}') {
                            reader.skipWhitespace();
                            String unquotedString = reader.readUnquotedString();
                            reader.skipWhitespace();
                            reader.expect('=');
                            reader.skipWhitespace();
                            boolean _boolean = reader.readBoolean();
                            map1.put(unquotedString, criterionProgress -> criterionProgress.isDone() == _boolean);
                            reader.skipWhitespace();
                            if (!reader.canRead() || reader.peek() != ',') continue;
                            reader.skip();
                        }
                        reader.skipWhitespace();
                        reader.expect('}');
                        reader.skipWhitespace();
                        map.put(resourceLocation, advancementProgress -> {
                            for (Map.Entry entry : map1.entrySet()) {
                                CriterionProgress criterion = advancementProgress.getCriterion((String)entry.getKey());
                                if (criterion != null && ((Predicate)entry.getValue()).test(criterion)) continue;
                                return false;
                            }
                            return true;
                        });
                    } else {
                        boolean _boolean1 = reader.readBoolean();
                        map.put(resourceLocation, advancementProgress -> advancementProgress.isDone() == _boolean1);
                    }
                    reader.skipWhitespace();
                    if (!reader.canRead() || reader.peek() != ',') continue;
                    reader.skip();
                }
                reader.expect('}');
                if (!map.isEmpty()) {
                    parser.addPredicate(entity -> {
                        if (!(entity instanceof ServerPlayer)) {
                            return false;
                        }
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        PlayerAdvancements advancements = serverPlayer.getAdvancements();
                        ServerAdvancementManager advancements1 = serverPlayer.getServer().getAdvancements();
                        for (Map.Entry entry : map.entrySet()) {
                            AdvancementHolder advancementHolder = advancements1.get((ResourceLocation)entry.getKey());
                            if (advancementHolder != null && ((Predicate)entry.getValue()).test(advancements.getOrStartProgress(advancementHolder))) continue;
                            return false;
                        }
                        return true;
                    });
                    parser.setIncludesEntities(false);
                }
                parser.setHasAdvancements(true);
            }, entitySelectorParser -> !entitySelectorParser.hasAdvancements(), Component.translatable("argument.entity.options.advancements.description"));
            EntitySelectorOptions.register("predicate", parser -> {
                boolean shouldInvertValue = parser.shouldInvertValue();
                ResourceKey<LootItemCondition> resourceKey = ResourceKey.create(Registries.PREDICATE, ResourceLocation.read(parser.getReader()));
                parser.addPredicate(entity -> {
                    if (!(entity.level() instanceof ServerLevel)) {
                        return false;
                    }
                    ServerLevel serverLevel = (ServerLevel)entity.level();
                    Optional<LootItemCondition> optional = serverLevel.getServer().reloadableRegistries().lookup().get(resourceKey).map(Holder::value);
                    if (optional.isEmpty()) {
                        return false;
                    }
                    LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, entity).withParameter(LootContextParams.ORIGIN, entity.position()).create(LootContextParamSets.SELECTOR);
                    LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
                    lootContext.pushVisitedElement(LootContext.createVisitedEntry(optional.get()));
                    return shouldInvertValue ^ optional.get().test(lootContext);
                });
            }, entitySelectorParser -> true, Component.translatable("argument.entity.options.predicate.description"));
        }
    }

    public static Modifier get(EntitySelectorParser parser, String id, int cursor) throws CommandSyntaxException {
        Option option = OPTIONS.get(id);
        if (option != null) {
            if (option.canUse.test(parser)) {
                return option.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)parser.getReader(), (Object)id);
        }
        parser.getReader().setCursor(cursor);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)parser.getReader(), (Object)id);
    }

    public static void suggestNames(EntitySelectorParser parser, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> entry : OPTIONS.entrySet()) {
            if (!entry.getValue().canUse.test(parser) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            builder.suggest(entry.getKey() + "=", (Message)entry.getValue().description);
        }
    }

    record Option(Modifier modifier, Predicate<EntitySelectorParser> canUse, Component description) {
    }

    public static interface Modifier {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

