/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public enum Direction implements StringRepresentable,
CollisionDirection
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final StringRepresentable.EnumCodec<Direction> CODEC;
    public static final Codec<Direction> VERTICAL_CODEC;
    public static final IntFunction<Direction> BY_ID;
    public static final StreamCodec<ByteBuf, Direction> STREAM_CODEC;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    private final Vec3 normalVec3;
    private static final Direction[] VALUES;
    private static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;
    private final int adjX;
    private final int adjY;
    private final int adjZ;
    private static final int RANDOM_OFFSET = 2017601568;
    private Direction opposite;
    private Quaternionf rotation;
    private int id;
    private int stepX;
    private int stepY;
    private int stepZ;

    private Quaternionf getRotationUncached() {
        switch (this.ordinal()) {
            case 0: {
                return new Quaternionf().rotationX((float)Math.PI);
            }
            case 1: {
                return new Quaternionf();
            }
            case 2: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            }
            case 3: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case 4: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            }
            case 5: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final int moonrise$uniqueId() {
        return this.id;
    }

    private Direction(int data3d, int oppositeIndex, int data2d, String name, AxisDirection axisDirection, Axis axis, Vec3i normal) {
        this.data3d = data3d;
        this.data2d = data2d;
        this.oppositeIndex = oppositeIndex;
        this.name = name;
        this.axis = axis;
        this.axisDirection = axisDirection;
        this.normal = normal;
        this.normalVec3 = Vec3.atLowerCornerOf(normal);
        this.adjX = normal.getX();
        this.adjY = normal.getY();
        this.adjZ = normal.getZ();
    }

    public static Direction[] orderedByNearest(Entity entity) {
        Direction direction2;
        float f = entity.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float f1 = -entity.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float sin = Mth.sin(f);
        float cos = Mth.cos(f);
        float sin1 = Mth.sin(f1);
        float cos1 = Mth.cos(f1);
        boolean flag = sin1 > 0.0f;
        boolean flag1 = sin < 0.0f;
        boolean flag2 = cos1 > 0.0f;
        float f2 = flag ? sin1 : -sin1;
        float f3 = flag1 ? -sin : sin;
        float f4 = flag2 ? cos1 : -cos1;
        float f5 = f2 * cos;
        float f6 = f4 * cos;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f2 > f4) {
            if (f3 > f5) {
                return Direction.makeDirectionArray(direction1, direction, direction2);
            }
            return f6 > f3 ? Direction.makeDirectionArray(direction, direction2, direction1) : Direction.makeDirectionArray(direction, direction1, direction2);
        }
        if (f3 > f6) {
            return Direction.makeDirectionArray(direction1, direction2, direction);
        }
        return f5 > f3 ? Direction.makeDirectionArray(direction2, direction, direction1) : Direction.makeDirectionArray(direction2, direction1, direction);
    }

    private static Direction[] makeDirectionArray(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.getOpposite(), second.getOpposite(), first.getOpposite()};
    }

    public static Direction rotate(Matrix4f matrix, Direction direction) {
        Vec3i unitVec3i = direction.getUnitVec3i();
        Vector4f vector4f = matrix.transform(new Vector4f((float)unitVec3i.getX(), (float)unitVec3i.getY(), (float)unitVec3i.getZ(), 0.0f));
        return Direction.getApproximateNearest(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<Direction> allShuffled(RandomSource random) {
        return Util.shuffledCopy(Direction.values(), random);
    }

    public static Stream<Direction> stream() {
        return Stream.of(VALUES);
    }

    public static float getYRot(Direction direction) {
        return switch (direction.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(direction));
        };
    }

    public Quaternionf getRotation() {
        try {
            return (Quaternionf)this.rotation.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static Direction getFacingAxis(Entity entity, Axis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (EAST.isFacingAngle(entity.getViewYRot(1.0f))) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (entity.getViewXRot(1.0f) < 0.0f) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> SOUTH.isFacingAngle(entity.getViewYRot(1.0f)) ? SOUTH : NORTH;
        };
    }

    public Direction getOpposite() {
        return this.opposite;
    }

    public Direction getClockWise(Axis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != WEST && this != EAST) {
                    yield this.getClockWiseX();
                }
                yield this;
            }
            case 1 -> {
                if (this != UP && this != DOWN) {
                    yield this.getClockWise();
                }
                yield this;
            }
            case 2 -> this != NORTH && this != SOUTH ? this.getClockWiseZ() : this;
        };
    }

    public Direction getCounterClockWise(Axis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != WEST && this != EAST) {
                    yield this.getCounterClockWiseX();
                }
                yield this;
            }
            case 1 -> {
                if (this != UP && this != DOWN) {
                    yield this.getCounterClockWise();
                }
                yield this;
            }
            case 2 -> this != NORTH && this != SOUTH ? this.getCounterClockWiseZ() : this;
        };
    }

    public Direction getClockWise() {
        return switch (this.ordinal()) {
            case 2 -> EAST;
            case 3 -> WEST;
            case 4 -> NORTH;
            case 5 -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseX() {
        return switch (this.ordinal()) {
            case 0 -> SOUTH;
            case 1 -> NORTH;
            case 2 -> DOWN;
            case 3 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getCounterClockWiseX() {
        return switch (this.ordinal()) {
            case 0 -> NORTH;
            case 1 -> SOUTH;
            case 2 -> UP;
            case 3 -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseZ() {
        return switch (this.ordinal()) {
            case 0 -> WEST;
            case 1 -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> UP;
            case 5 -> DOWN;
        };
    }

    private Direction getCounterClockWiseZ() {
        return switch (this.ordinal()) {
            case 0 -> EAST;
            case 1 -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> DOWN;
            case 5 -> UP;
        };
    }

    public Direction getCounterClockWise() {
        return switch (this.ordinal()) {
            case 2 -> WEST;
            case 3 -> EAST;
            case 4 -> SOUTH;
            case 5 -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int getStepX() {
        return this.adjX;
    }

    public int getStepY() {
        return this.adjY;
    }

    public int getStepZ() {
        return this.adjZ;
    }

    public Vector3f step() {
        return new Vector3f((float)this.getStepX(), (float)this.getStepY(), (float)this.getStepZ());
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static Direction byName(@Nullable String name) {
        return CODEC.byName(name);
    }

    public static Direction from3DDataValue(int index) {
        return BY_3D_DATA[Mth.abs(index % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int horizontalIndex) {
        return BY_2D_DATA[Mth.abs(horizontalIndex % BY_2D_DATA.length)];
    }

    public static Direction fromYRot(double angle) {
        return Direction.from2DDataValue(Mth.floor(angle / 90.0 + 0.5) & 3);
    }

    public static Direction fromAxisAndDirection(Axis axis, AxisDirection axisDirection) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (axisDirection == AxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (axisDirection == AxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> axisDirection == AxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static Direction getRandom(RandomSource random) {
        return Util.getRandom(VALUES, random);
    }

    public static Direction getApproximateNearest(double x, double y, double z) {
        return Direction.getApproximateNearest((float)x, (float)y, (float)z);
    }

    public static Direction getApproximateNearest(float x, float y, float z) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : VALUES) {
            float f1 = x * (float)direction1.normal.getX() + y * (float)direction1.normal.getY() + z * (float)direction1.normal.getZ();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getApproximateNearest(Vec3 vector) {
        return Direction.getApproximateNearest(vector.x, vector.y, vector.z);
    }

    @Nullable
    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static Direction getNearest(int x, int y, int z, @Nullable Direction defaultValue) {
        int abs = Math.abs(x);
        int abs1 = Math.abs(y);
        int abs2 = Math.abs(z);
        if (abs > abs2 && abs > abs1) {
            return x < 0 ? WEST : EAST;
        }
        if (abs2 > abs && abs2 > abs1) {
            return z < 0 ? NORTH : SOUTH;
        }
        if (abs1 > abs && abs1 > abs2) {
            return y < 0 ? DOWN : UP;
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    public static Direction getNearest(Vec3i vector, @Nullable Direction defaultValue) {
        return Direction.getNearest(vector.getX(), vector.getY(), vector.getZ(), defaultValue);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<Direction> verifyVertical(Direction direction) {
        return direction.getAxis().isVertical() ? DataResult.success((Object)direction) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static Direction get(AxisDirection axisDirection, Axis axis) {
        for (Direction direction : VALUES) {
            if (direction.getAxisDirection() != axisDirection || direction.getAxis() != axis) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)axisDirection) + " " + String.valueOf(axis));
    }

    public Vec3i getUnitVec3i() {
        return this.normal;
    }

    public Vec3 getUnitVec3() {
        return this.normalVec3;
    }

    public boolean isFacingAngle(float degrees) {
        float f = degrees * ((float)Math.PI / 180);
        float f1 = -Mth.sin(f);
        float cos = Mth.cos(f);
        return (float)this.normal.getX() * f1 + (float)this.normal.getZ() * cos > 0.0f;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values);
        VERTICAL_CODEC = CODEC.validate(Direction::verifyVertical);
        BY_ID = ByIdMap.continuous(Direction::get3DDataValue, Direction.values(), ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Direction::get3DDataValue);
        VALUES = Direction.values();
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(direction -> direction.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.getAxis().isHorizontal()).sorted(Comparator.comparingInt(direction -> direction.data2d)).toArray(Direction[]::new);
        for (Direction direction2 : VALUES) {
            direction2.opposite = Direction.from3DDataValue(direction2.oppositeIndex);
            direction2.rotation = direction2.getRotationUncached();
            direction2.id = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(direction2.ordinal() + 2017601568)) + 2017601568));
            direction2.stepX = direction2.normal.getX();
            direction2.stepY = direction2.normal.getY();
            direction2.stepZ = direction2.normal.getZ();
        }
    }

    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int choose(int x, int y, int z) {
                return x;
            }

            @Override
            public double choose(double x, double y, double z) {
                return x;
            }

            @Override
            public Direction getPositive() {
                return EAST;
            }

            @Override
            public Direction getNegative() {
                return WEST;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int x, int y, int z) {
                return y;
            }

            @Override
            public double choose(double x, double y, double z) {
                return y;
            }

            @Override
            public Direction getPositive() {
                return UP;
            }

            @Override
            public Direction getNegative() {
                return DOWN;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int x, int y, int z) {
                return z;
            }

            @Override
            public double choose(double x, double y, double z) {
                return z;
            }

            @Override
            public Direction getPositive() {
                return SOUTH;
            }

            @Override
            public Direction getNegative() {
                return NORTH;
            }
        };

        public static final Axis[] VALUES;
        public static final StringRepresentable.EnumCodec<Axis> CODEC;
        private final String name;

        private Axis(String name) {
            this.name = name;
        }

        @Nullable
        public static Axis byName(String name) {
            return CODEC.byName(name);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public abstract Direction getPositive();

        public abstract Direction getNegative();

        public Direction[] getDirections() {
            return new Direction[]{this.getPositive(), this.getNegative()};
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandom(RandomSource random) {
            return Util.getRandom(VALUES, random);
        }

        @Override
        public boolean test(@Nullable Direction direction) {
            return direction != null && direction.getAxis() == this;
        }

        public Plane getPlane() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> Plane.HORIZONTAL;
                case 1 -> Plane.VERTICAL;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        static {
            VALUES = Axis.values();
            CODEC = StringRepresentable.fromEnum(Axis::values);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int step, String name) {
            this.step = step;
            this.name = name;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] faces;
        private final Axis[] axis;

        private Plane(Direction[] faces, Axis[] axis) {
            this.faces = faces;
            this.axis = axis;
        }

        public Direction getRandomDirection(RandomSource random) {
            return Util.getRandom(this.faces, random);
        }

        public Axis getRandomAxis(RandomSource random) {
            return Util.getRandom(this.axis, random);
        }

        @Override
        public boolean test(@Nullable Direction direction) {
            return direction != null && direction.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<Direction> stream() {
            return Arrays.stream(this.faces);
        }

        public List<Direction> shuffledCopy(RandomSource random) {
            return Util.shuffledCopy(this.faces, random);
        }

        public int length() {
            return this.faces.length;
        }
    }
}

