/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> owner1) {
        return new EmptyTagLookup<T>(owner1){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> resourceKey) {
                return owner1.get(resourceKey);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> registryKey, final Lifecycle registryLifecycle, HolderOwner<T> owner, final Map<ResourceKey<T>, Holder.Reference<T>> elements) {
        return new EmptyTagRegistryLookup<T>(owner){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return registryKey;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return registryLifecycle;
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> resourceKey) {
                return Optional.ofNullable((Holder.Reference)elements.get(resourceKey));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return elements.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        this.entries.add(new RegistryStub<T>(key, lifecycle, bootstrap));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> key, RegistryBootstrap<T> bootstrap) {
        return this.add(key, Lifecycle.stable(), bootstrap);
    }

    private BuildState createState(RegistryAccess registryAccess) {
        BuildState buildState = BuildState.create(registryAccess, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(entry -> entry.apply(buildState));
        return buildState;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner owner, RegistryAccess registryAccess, Stream<HolderLookup.RegistryLookup<?>> lookups) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> lookup) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(lookup, lookup), RegistryOps.RegistryInfo.fromRegistryLookup(lookup));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner owner1, HolderLookup.RegistryLookup<T> lookup) {
                return new Entry(new EmptyTagLookupWrapper(owner1.cast(), lookup), new RegistryOps.RegistryInfo(owner1.cast(), lookup, lookup.registryLifecycle()));
            }
        }
        final HashMap map = new HashMap();
        registryAccess.registries().forEach(registry -> map.put(registry.key(), Entry.createForContextRegistry(registry.value())));
        lookups.forEach(lookup -> map.put(lookup.key(), Entry.createForNewRegistry(owner, lookup)));
        return new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return map.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> registryKey) {
                return Optional.ofNullable((Entry)map.get(registryKey));
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
                return this.getEntry(registryKey).map(Entry::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> ops) {
                return RegistryOps.create(ops, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
                        return this.getEntry(registryKey).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess registryAccess) {
        BuildState buildState = this.createState(registryAccess);
        Stream<HolderLookup.RegistryLookup<?>> stream = this.entries.stream().map(entry -> entry.collectRegisteredValues(buildState).buildAsLookup(buildState.owner));
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(buildState.owner, registryAccess, stream);
        buildState.reportNotCollectedHolders();
        buildState.reportUnclaimedRegisteredValues();
        buildState.throwOnError();
        return provider;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess registry, HolderLookup.Provider lookupProvider, Cloner.Factory clonerFactory, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> registries, HolderLookup.Provider registryLookupProvider) {
        UniversalOwner universalOwner = new UniversalOwner();
        MutableObject mutableObject = new MutableObject();
        List list = registries.keySet().stream().map(key -> this.createLazyFullPatchedRegistries(universalOwner, clonerFactory, (ResourceKey)key, registryLookupProvider, lookupProvider, (MutableObject<HolderLookup.Provider>)mutableObject)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(universalOwner, registry, list.stream());
        mutableObject.setValue((Object)provider);
        return provider;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> owner, Cloner.Factory clonerFactory, ResourceKey<? extends Registry<? extends T>> registryKey, HolderLookup.Provider registryLookupProvider, HolderLookup.Provider lookupProvider, MutableObject<HolderLookup.Provider> object) {
        Cloner cloner = clonerFactory.cloner(registryKey);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(registryKey.location()));
        }
        HashMap map = new HashMap();
        HolderGetter registryLookup = registryLookupProvider.lookupOrThrow(registryKey);
        registryLookup.listElements().forEach(element -> {
            ResourceKey resourceKey = element.key();
            LazyHolder lazyHolder = new LazyHolder(owner, resourceKey);
            lazyHolder.supplier = () -> cloner.clone(element.value(), registryLookupProvider, (HolderLookup.Provider)object.getValue());
            map.put(resourceKey, lazyHolder);
        });
        HolderGetter registryLookup1 = lookupProvider.lookupOrThrow(registryKey);
        registryLookup1.listElements().forEach(element -> {
            ResourceKey resourceKey = element.key();
            map.computeIfAbsent(resourceKey, resourceKey1 -> {
                LazyHolder lazyHolder = new LazyHolder(owner, resourceKey);
                lazyHolder.supplier = () -> cloner.clone(element.value(), lookupProvider, (HolderLookup.Provider)object.getValue());
                return lazyHolder;
            });
        });
        Lifecycle lifecycle = registryLookup.registryLifecycle().add(registryLookup1.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(registryKey, lifecycle, owner, map);
    }

    public PatchedRegistries buildPatch(RegistryAccess registryAccess, HolderLookup.Provider lookupProvider, Cloner.Factory clonerFactory) {
        BuildState buildState = this.createState(registryAccess);
        HashMap map = new HashMap();
        this.entries.stream().map(entry -> entry.collectRegisteredValues(buildState)).forEach(registryContents -> map.put((ResourceKey<Registry<?>>)registryContents.key, (RegistryContents<?>)registryContents));
        Set set = registryAccess.listRegistryKeys().collect(Collectors.toUnmodifiableSet());
        lookupProvider.listRegistryKeys().filter(registry -> !set.contains(registry)).forEach(registry -> map.putIfAbsent((ResourceKey<Registry<?>>)registry, new RegistryContents(registry, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> stream = map.values().stream().map(registryContents -> registryContents.buildAsLookup(buildState.owner));
        HolderLookup.Provider provider = RegistrySetBuilder.buildProviderWithContext(buildState.owner, registryAccess, stream);
        buildState.reportUnclaimedRegisteredValues();
        buildState.throwOnError();
        HolderLookup.Provider provider1 = this.createLazyFullPatchedRegistries(registryAccess, lookupProvider, clonerFactory, map, provider);
        return new PatchedRegistries(provider1, provider);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState state) {
            this.bootstrap.run(state.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState buildState) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> iterator = buildState.registeredValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.isFor(this.key)) continue;
                RegisteredValue<?> registeredValue = entry.getValue();
                Holder.Reference<Object> reference = buildState.lookup.holders.remove(resourceKey);
                map.put(resourceKey, new ValueAndHolder(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, map);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    record BuildState(UniversalOwner owner, UniversalLookup lookup, Map<ResourceLocation, HolderGetter<?>> registries, Map<ResourceKey<?>, RegisteredValue<?>> registeredValues, List<RuntimeException> errors) {
        public static BuildState create(RegistryAccess registryAccess, Stream<ResourceKey<? extends Registry<?>>> registries) {
            UniversalOwner universalOwner = new UniversalOwner();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            UniversalLookup universalLookup = new UniversalLookup(universalOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            registryAccess.registries().forEach(registryEntry -> builder.put((Object)registryEntry.key().location(), RegistrySetBuilder.wrapContextLookup(registryEntry.value())));
            registries.forEach(registryKey -> builder.put((Object)registryKey.location(), (Object)universalLookup));
            return new BuildState(universalOwner, universalLookup, (Map<ResourceLocation, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> key, T value, Lifecycle registryLifecycle) {
                    RegisteredValue registeredValue = registeredValues.put(key, new RegisteredValue(value, registryLifecycle));
                    if (registeredValue != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(key) + ", new=" + String.valueOf(value) + ", old=" + String.valueOf(registeredValue.value)));
                    }
                    return lookup.getOrCreate(key);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> registryKey) {
                    return registries.getOrDefault(registryKey.location(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((resourceKey, registeredValue) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(registeredValue.value) + " for key " + String.valueOf(resourceKey))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> resourceKey : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(resourceKey)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.errors) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    record RegistryContents<T>(ResourceKey<? extends Registry<? extends T>> key, Lifecycle lifecycle, Map<ResourceKey<T>, ValueAndHolder<T>> values) {
        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner owner) {
            Map map = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                ValueAndHolder valueAndHolder = (ValueAndHolder)entry.getValue();
                Holder.Reference reference = valueAndHolder.holder().orElseGet(() -> Holder.Reference.createStandAlone(owner.cast(), (ResourceKey)entry.getKey()));
                reference.bindValue(valueAndHolder.value().value());
                return reference;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, owner.cast(), map);
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable
        Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> owner, @Nullable ResourceKey<T> key) {
            super(Holder.Reference.Type.STAND_ALONE, owner, key, null);
        }

        @Override
        protected void bindValue(T value) {
            super.bindValue(value);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> owner) {
            super(owner);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> resourceKey) {
            return Optional.of(this.getOrCreate(resourceKey));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> key) {
            return this.holders.computeIfAbsent(key, resourceKey -> Holder.Reference.createStandAlone(this.owner, resourceKey));
        }
    }

    record RegisteredValue<T>(T value, Lifecycle lifecycle) {
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> owner) {
            super(owner);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> owner, HolderLookup.RegistryLookup<T> parent) {
            super(owner);
            this.parent = parent;
        }

        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> owner) {
            this.owner = owner;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> tagKey) {
            return Optional.of(HolderSet.emptyNamed(this.owner, tagKey));
        }
    }
}

