/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;

public class DefaultDispenseItemBehavior
implements DispenseItemBehavior {
    private static final int DEFAULT_ACCURACY = 6;
    private Direction direction;
    private boolean dropper;

    public DefaultDispenseItemBehavior(boolean dropper) {
        this.dropper = dropper;
    }

    public DefaultDispenseItemBehavior() {
    }

    @Override
    public final net.minecraft.world.item.ItemStack dispense(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        this.direction = blockSource.state().getValue(DispenserBlock.FACING);
        net.minecraft.world.item.ItemStack itemStack = this.execute(blockSource, item);
        this.playSound(blockSource);
        this.playAnimation(blockSource, this.direction);
        return itemStack;
    }

    protected net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        Position dispensePosition = DispenserBlock.getDispensePosition(blockSource);
        net.minecraft.world.item.ItemStack itemStack = item.split(1);
        if (!DefaultDispenseItemBehavior.spawnItem(blockSource.level(), itemStack, 6, this.direction, dispensePosition, blockSource, this.dropper)) {
            item.grow(1);
        }
        return item;
    }

    public static void spawnItem(Level level, net.minecraft.world.item.ItemStack stack, int speed, Direction facing, Position position) {
        ItemEntity itemEntity = DefaultDispenseItemBehavior.prepareItem(level, stack, speed, facing, position);
        level.addFreshEntity(itemEntity);
    }

    private static ItemEntity prepareItem(Level level, net.minecraft.world.item.ItemStack stack, int speed, Direction facing, Position position) {
        double d = position.x();
        double d1 = position.y();
        double d2 = position.z();
        d1 = facing.getAxis() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itemEntity = new ItemEntity(level, d, d1, d2, stack);
        double d3 = level.random.nextDouble() * 0.1 + 0.2;
        itemEntity.setDeltaMovement(level.random.triangle((double)facing.getStepX() * d3, 0.0172275 * (double)speed), level.random.triangle(0.2, 0.0172275 * (double)speed), level.random.triangle((double)facing.getStepZ() * d3, 0.0172275 * (double)speed));
        return itemEntity;
    }

    public static boolean spawnItem(Level level, net.minecraft.world.item.ItemStack stack, int speed, Direction facing, Position dispensePosition, BlockSource blockSource, boolean dropper) {
        if (stack.isEmpty()) {
            return true;
        }
        ItemEntity itemEntity = DefaultDispenseItemBehavior.prepareItem(level, stack, speed, facing, dispensePosition);
        CraftBlock block = CraftBlock.at(level, blockSource.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit(itemEntity.getDeltaMovement()));
        if (!DispenserBlock.eventFired) {
            level.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        itemEntity.setItem(CraftItemStack.asNMSCopy(event.getItem()));
        itemEntity.setDeltaMovement(CraftVector.toNMS(event.getVelocity()));
        if (!dropper && !event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior dispenseBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
            if (dispenseBehavior != DispenseItemBehavior.NOOP && dispenseBehavior.getClass() != DefaultDispenseItemBehavior.class) {
                dispenseBehavior.dispense(blockSource, eventStack);
            } else {
                level.addFreshEntity(itemEntity);
            }
            return false;
        }
        level.addFreshEntity(itemEntity);
        return true;
    }

    protected void playSound(BlockSource blockSource) {
        DefaultDispenseItemBehavior.playDefaultSound(blockSource);
    }

    protected void playAnimation(BlockSource blockSource, Direction direction) {
        DefaultDispenseItemBehavior.playDefaultAnimation(blockSource, direction);
    }

    private static void playDefaultSound(BlockSource blockSource) {
        blockSource.level().levelEvent(1000, blockSource.pos(), 0);
    }

    private static void playDefaultAnimation(BlockSource blockSource, Direction direction) {
        blockSource.level().levelEvent(2000, blockSource.pos(), direction.get3DDataValue());
    }

    protected net.minecraft.world.item.ItemStack consumeWithRemainder(BlockSource blockSource, net.minecraft.world.item.ItemStack stack, net.minecraft.world.item.ItemStack remainder) {
        stack.shrink(1);
        if (stack.isEmpty()) {
            return remainder;
        }
        this.addToInventoryOrDispense(blockSource, remainder);
        return stack;
    }

    private void addToInventoryOrDispense(BlockSource blockSource, net.minecraft.world.item.ItemStack remainder) {
        net.minecraft.world.item.ItemStack itemStack = blockSource.blockEntity().insertItem(remainder);
        if (!itemStack.isEmpty()) {
            Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
            DefaultDispenseItemBehavior.spawnItem(blockSource.level(), itemStack, 6, direction, DispenserBlock.getDispensePosition(blockSource));
            DefaultDispenseItemBehavior.playDefaultSound(blockSource);
            DefaultDispenseItemBehavior.playDefaultAnimation(blockSource, direction);
        }
    }
}

