/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MinecartDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractMinecart> entityType;

    public MinecartDispenseItemBehavior(EntityType<? extends AbstractMinecart> entityType) {
        this.entityType = entityType;
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(BlockSource blockSource, net.minecraft.world.item.ItemStack item) {
        double d3;
        Direction direction = blockSource.state().getValue(DispenserBlock.FACING);
        ServerLevel serverLevel = blockSource.level();
        Vec3 vec3 = blockSource.center();
        double d = vec3.x() + (double)direction.getStepX() * 1.125;
        double d1 = Math.floor(vec3.y()) + (double)direction.getStepY();
        double d2 = vec3.z() + (double)direction.getStepZ() * 1.125;
        BlockPos blockPos = blockSource.pos().relative(direction);
        BlockState blockState = serverLevel.getBlockState(blockPos);
        if (blockState.is(BlockTags.RAILS)) {
            d3 = MinecartDispenseItemBehavior.getRailShape(blockState).isSlope() ? 0.6 : 0.1;
        } else {
            if (!blockState.isAir()) {
                return this.defaultDispenseItemBehavior.dispense(blockSource, item);
            }
            BlockState blockState1 = serverLevel.getBlockState(blockPos.below());
            if (!blockState1.is(BlockTags.RAILS)) {
                return this.defaultDispenseItemBehavior.dispense(blockSource, item);
            }
            d3 = direction != Direction.DOWN && MinecartDispenseItemBehavior.getRailShape(blockState1).isSlope() ? -0.4 : -0.9;
        }
        Vec3 vec31 = new Vec3(d, d1 + d3, d2);
        net.minecraft.world.item.ItemStack itemstack1 = item.copyWithCount(1);
        CraftBlock block2 = CraftBlock.at(serverLevel, blockSource.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block2, (ItemStack)craftItem.clone(), new Vector(vec31.x, vec31.y, vec31.z));
        if (!DispenserBlock.eventFired) {
            serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return item;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior dispenseItemBehavior = DispenserBlock.getDispenseBehavior(blockSource, eventStack);
            if (dispenseItemBehavior != DispenseItemBehavior.NOOP && dispenseItemBehavior != this) {
                dispenseItemBehavior.dispense(blockSource, eventStack);
                return item;
            }
        }
        itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
        AbstractMinecart abstractMinecart = AbstractMinecart.createMinecart(serverLevel, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.entityType, EntitySpawnReason.DISPENSER, itemstack1, null);
        if (abstractMinecart != null && serverLevel.addFreshEntity(abstractMinecart) && shrink) {
            item.shrink(1);
        }
        return item;
    }

    private static RailShape getRailShape(BlockState state) {
        RailShape railShape;
        Block block = state.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock baseRailBlock = (BaseRailBlock)block;
            railShape = state.getValue(baseRailBlock.getShapeProperty());
        } else {
            railShape = RailShape.NORTH_SOUTH;
        }
        return railShape;
    }

    @Override
    protected void playSound(BlockSource blockSource) {
        blockSource.level().levelEvent(1000, blockSource.pos(), 0);
    }
}

