/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.server.level.ServerLevel;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;

    public static Collection<GameTestBatch> fromTestFunction(Collection<TestFunction> testFunctions, ServerLevel level) {
        Map<String, List<TestFunction>> map = testFunctions.stream().collect(Collectors.groupingBy(TestFunction::batchName));
        return map.entrySet().stream().flatMap(entry -> {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            return Streams.mapWithIndex(Lists.partition((List)list, (int)50).stream(), (list1, l) -> GameTestBatchFactory.toGameTestBatch(list1.stream().map(testFunction -> GameTestBatchFactory.toGameTestInfo(testFunction, 0, level)).toList(), string, l));
        }).toList();
    }

    public static GameTestInfo toGameTestInfo(TestFunction testFunction, int rotationSteps, ServerLevel level) {
        return new GameTestInfo(testFunction, StructureUtils.getRotationForRotationSteps(rotationSteps), level, RetryOptions.noRetries());
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return GameTestBatchFactory.fromGameTestInfo(50);
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo(int maxTests) {
        return infos -> {
            Map<String, List<GameTestInfo>> map = infos.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(gameTestInfo -> gameTestInfo.getTestFunction().batchName()));
            return map.entrySet().stream().flatMap(entry -> {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                return Streams.mapWithIndex(Lists.partition((List)list, (int)maxTests).stream(), (list1, l) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(list1), string, l));
            }).toList();
        };
    }

    public static GameTestBatch toGameTestBatch(Collection<GameTestInfo> gameTestInfos, String functionName, long index) {
        Consumer<ServerLevel> beforeBatchFunction = GameTestRegistry.getBeforeBatchFunction(functionName);
        Consumer<ServerLevel> afterBatchFunction = GameTestRegistry.getAfterBatchFunction(functionName);
        return new GameTestBatch(functionName + ":" + index, gameTestInfos, beforeBatchFunction, afterBatchFunction);
    }
}

