/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int SELF_SIZE_IN_BYTES = 37;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput input, NbtAccounter accounter) throws IOException {
            ListTag var3;
            accounter.pushDepth();
            try {
                var3 = 1.loadList(input, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var3;
        }

        private static ListTag loadList(DataInput input, NbtAccounter accounter) throws IOException {
            accounter.accountBytes(37L);
            byte _byte = input.readByte();
            int _int = input.readInt();
            if (_byte == 0 && _int > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            accounter.accountBytes(4L, _int);
            TagType<?> type = TagTypes.getType(_byte);
            ArrayList list = Lists.newArrayListWithCapacity((int)_int);
            for (int i = 0; i < _int; ++i) {
                list.add(type.load(input, accounter));
            }
            return new ListTag(list, _byte);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            StreamTagVisitor.ValueResult var4;
            accounter.pushDepth();
            try {
                var4 = 1.parseList(input, visitor, accounter);
            }
            finally {
                accounter.popDepth();
            }
            return var4;
        }

        private static StreamTagVisitor.ValueResult parseList(DataInput input, StreamTagVisitor visitor, NbtAccounter accounter) throws IOException {
            accounter.accountBytes(37L);
            TagType<?> type = TagTypes.getType(input.readByte());
            int _int = input.readInt();
            switch (visitor.visitList(type, _int)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    type.skip(input, _int, accounter);
                    return visitor.visitContainerEnd();
                }
            }
            accounter.accountBytes(4L, _int);
            int i = 0;
            while (true) {
                block16: {
                    int i1;
                    block15: {
                        if (i >= _int) break block15;
                        block4 : switch (visitor.visitElement(type, i)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                type.skip(input, accounter);
                                break;
                            }
                            case SKIP: {
                                type.skip(input, accounter);
                                break block16;
                            }
                            default: {
                                switch (type.parse(input, visitor, accounter)) {
                                    case HALT: {
                                        return StreamTagVisitor.ValueResult.HALT;
                                    }
                                    case BREAK: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((i1 = _int - 1 - i) > 0) {
                        type.skip(input, i1, accounter);
                    }
                    return visitor.visitContainerEnd();
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput input, NbtAccounter accounter) throws IOException {
            accounter.pushDepth();
            try {
                TagType<?> type = TagTypes.getType(input.readByte());
                int _int = input.readInt();
                type.skip(input, _int, accounter);
            }
            finally {
                accounter.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }
    };
    private final List<Tag> list;
    private byte type;

    public ListTag(List<Tag> list, byte type) {
        this.list = list;
        this.type = type;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        output.writeByte(this.type);
        output.writeInt(this.list.size());
        for (Tag tag : this.list) {
            tag.write(output);
        }
    }

    @Override
    public int sizeInBytes() {
        int i = 37;
        i += 4 * this.list.size();
        for (Tag tag : this.list) {
            i += tag.sizeInBytes();
        }
        return i;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    @Override
    public Tag remove(int index) {
        Tag tag = this.list.remove(index);
        this.updateTypeAfterRemove();
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public CompoundTag getCompound(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 10) {
            return (CompoundTag)tag;
        }
        return new CompoundTag();
    }

    public ListTag getList(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 9) {
            return (ListTag)tag;
        }
        return new ListTag();
    }

    public short getShort(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 2) {
            return ((ShortTag)tag).getAsShort();
        }
        return 0;
    }

    public int getInt(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 3) {
            return ((IntTag)tag).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 11) {
            return ((IntArrayTag)tag).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 12) {
            return ((LongArrayTag)tag).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 6) {
            return ((DoubleTag)tag).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int index) {
        Tag tag;
        if (index >= 0 && index < this.list.size() && (tag = this.list.get(index)).getId() == 5) {
            return ((FloatTag)tag).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int index) {
        if (index >= 0 && index < this.list.size()) {
            Tag tag = this.list.get(index);
            return tag.getId() == 8 ? tag.getAsString() : tag.toString();
        }
        return "";
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int index) {
        return this.list.get(index);
    }

    @Override
    public Tag set(int index, Tag tag) {
        Tag tag1 = this.get(index);
        if (!this.setTag(index, tag)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", tag.getId(), this.type));
        }
        return tag1;
    }

    @Override
    public void add(int index, Tag tag) {
        if (!this.addTag(index, tag)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", tag.getId(), this.type));
        }
    }

    @Override
    public boolean setTag(int index, Tag nbt) {
        if (this.updateType(nbt)) {
            this.list.set(index, nbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int index, Tag nbt) {
        if (this.updateType(nbt)) {
            this.list.add(index, nbt);
            return true;
        }
        return false;
    }

    private boolean updateType(Tag tag) {
        if (tag.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = tag.getId();
            return true;
        }
        return this.type == tag.getId();
    }

    @Override
    public ListTag copy() {
        List<Tag> iterable = TagTypes.getType(this.type).isValue() ? this.list : Iterables.transform(this.list, Tag::copy);
        ArrayList list = Lists.newArrayList(iterable);
        return new ListTag(list, this.type);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof ListTag && Objects.equals(this.list, ((ListTag)other).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitList(this);
    }

    @Override
    public byte getElementType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        switch (visitor.visitList(TagTypes.getType(this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return visitor.visitContainerEnd();
            }
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Tag tag = this.list.get(i);
            switch (visitor.visitElement(tag.getType(), i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return visitor.visitContainerEnd();
                }
                default: {
                    switch (tag.accept(visitor)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return visitor.visitContainerEnd();
                        }
                    }
                }
                case SKIP: 
            }
        }
        return visitor.visitContainerEnd();
    }
}

