/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();
    private static final String WRAPPER_MARKER = "";

    protected NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> ops, Tag tag) {
        return (U)(switch (tag.getId()) {
            case 0 -> ops.empty();
            case 1 -> ops.createByte(((NumericTag)tag).getAsByte());
            case 2 -> ops.createShort(((NumericTag)tag).getAsShort());
            case 3 -> ops.createInt(((NumericTag)tag).getAsInt());
            case 4 -> ops.createLong(((NumericTag)tag).getAsLong());
            case 5 -> ops.createFloat(((NumericTag)tag).getAsFloat());
            case 6 -> ops.createDouble(((NumericTag)tag).getAsDouble());
            case 7 -> ops.createByteList(ByteBuffer.wrap(((ByteArrayTag)tag).getAsByteArray()));
            case 8 -> ops.createString(tag.getAsString());
            case 9 -> this.convertList(ops, tag);
            case 10 -> this.convertMap(ops, tag);
            case 11 -> ops.createIntList(Arrays.stream(((IntArrayTag)tag).getAsIntArray()));
            case 12 -> ops.createLongList(Arrays.stream(((LongArrayTag)tag).getAsLongArray()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(tag));
        });
    }

    public DataResult<Number> getNumberValue(Tag tag) {
        DataResult dataResult;
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            dataResult = DataResult.success((Object)numericTag.getAsNumber());
        } else {
            dataResult = DataResult.error(() -> "Not a number");
        }
        return dataResult;
    }

    public Tag createNumeric(Number data) {
        return DoubleTag.valueOf(data.doubleValue());
    }

    public Tag createByte(byte data) {
        return ByteTag.valueOf(data);
    }

    public Tag createShort(short data) {
        return ShortTag.valueOf(data);
    }

    public Tag createInt(int data) {
        return IntTag.valueOf(data);
    }

    public Tag createLong(long data) {
        return LongTag.valueOf(data);
    }

    public Tag createFloat(float data) {
        return FloatTag.valueOf(data);
    }

    public Tag createDouble(double data) {
        return DoubleTag.valueOf(data);
    }

    public Tag createBoolean(boolean data) {
        return ByteTag.valueOf(data);
    }

    public DataResult<String> getStringValue(Tag tag) {
        DataResult dataResult;
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            dataResult = DataResult.success((Object)stringTag.getAsString());
        } else {
            dataResult = DataResult.error(() -> "Not a string");
        }
        return dataResult;
    }

    public Tag createString(String data) {
        return StringTag.valueOf(data);
    }

    public DataResult<Tag> mergeToList(Tag list, Tag tag) {
        return NbtOps.createCollector(list).map(listCollector -> DataResult.success((Object)listCollector.accept(tag).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<Tag> mergeToList(Tag list, List<Tag> tags) {
        return NbtOps.createCollector(list).map(listCollector -> DataResult.success((Object)listCollector.acceptAll(tags).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<Tag> mergeToMap(Tag map, Tag key, Tag value) {
        CompoundTag compoundTag;
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof StringTag)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag2 = (CompoundTag)map;
            compoundTag = compoundTag2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        compoundTag1.put(key.getAsString(), value);
        return DataResult.success((Object)compoundTag1);
    }

    public DataResult<Tag> mergeToMap(Tag map, MapLike<Tag> otherMap) {
        CompoundTag compoundTag;
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag2 = (CompoundTag)map;
            compoundTag = compoundTag2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        ArrayList list = new ArrayList();
        otherMap.entries().forEach(pair -> {
            Tag tag = (Tag)pair.getFirst();
            if (!(tag instanceof StringTag)) {
                list.add(tag);
            } else {
                compoundTag1.put(tag.getAsString(), (Tag)pair.getSecond());
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    public DataResult<Tag> mergeToMap(Tag tag, Map<Tag, Tag> map) {
        CompoundTag compoundTag;
        if (!(tag instanceof CompoundTag) && !(tag instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag2 = (CompoundTag)tag;
            compoundTag = compoundTag2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> entry : map.entrySet()) {
            Tag tag1 = entry.getKey();
            if (tag1 instanceof StringTag) {
                compoundTag1.put(tag1.getAsString(), entry.getValue());
                continue;
            }
            list.add(tag1);
        }
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success(compoundTag.entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success(biConsumer -> {
                for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                    biConsumer.accept(this.createString(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<MapLike<Tag>> getMap(Tag map) {
        DataResult dataResult;
        if (map instanceof CompoundTag) {
            final CompoundTag compoundTag = (CompoundTag)map;
            dataResult = DataResult.success((Object)new MapLike<Tag>(){

                @Nullable
                public Tag get(Tag tag) {
                    return compoundTag.get(tag.getAsString());
                }

                @Nullable
                public Tag get(String string) {
                    return compoundTag.get(string);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return compoundTag.entrySet().stream().map(entry -> Pair.of((Object)NbtOps.this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundTag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> data) {
        CompoundTag compoundTag = new CompoundTag();
        data.forEach(pair -> compoundTag.put(((Tag)pair.getFirst()).getAsString(), (Tag)pair.getSecond()));
        return compoundTag;
    }

    private static Tag tryUnwrap(CompoundTag tag) {
        Tag tag1;
        if (tag.size() == 1 && (tag1 = tag.get(WRAPPER_MARKER)) != null) {
            return tag1;
        }
        return tag;
    }

    public DataResult<Stream<Tag>> getStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            return listTag.getElementType() == 10 ? DataResult.success(listTag.stream().map(tag1 -> NbtOps.tryUnwrap((CompoundTag)tag1))) : DataResult.success(listTag.stream());
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            dataResult = DataResult.success(collectionTag.stream().map(tag1 -> tag1));
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag tag) {
        DataResult dataResult;
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            return listTag.getElementType() == 10 ? DataResult.success(consumer -> {
                for (Tag tag1 : listTag) {
                    consumer.accept(NbtOps.tryUnwrap((CompoundTag)tag1));
                }
            }) : DataResult.success(listTag::forEach);
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            dataResult = DataResult.success(collectionTag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(tag));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag tag) {
        DataResult dataResult;
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.getAsByteArray()));
        } else {
            dataResult = super.getByteBuffer((Object)tag);
        }
        return dataResult;
    }

    public Tag createByteList(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate().clear();
        byte[] bytes = new byte[data.capacity()];
        byteBuffer.get(0, bytes, 0, bytes.length);
        return new ByteArrayTag(bytes);
    }

    public DataResult<IntStream> getIntStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            dataResult = DataResult.success((Object)Arrays.stream(intArrayTag.getAsIntArray()));
        } else {
            dataResult = super.getIntStream((Object)tag);
        }
        return dataResult;
    }

    public Tag createIntList(IntStream data) {
        return new IntArrayTag(data.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag tag) {
        DataResult dataResult;
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            dataResult = DataResult.success((Object)Arrays.stream(longArrayTag.getAsLongArray()));
        } else {
            dataResult = super.getLongStream((Object)tag);
        }
        return dataResult;
    }

    public Tag createLongList(LongStream data) {
        return new LongArrayTag(data.toArray());
    }

    public Tag createList(Stream<Tag> data) {
        return InitialListCollector.INSTANCE.acceptAll(data).result();
    }

    public Tag remove(Tag map, String removeKey) {
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)map;
            CompoundTag compoundTag1 = compoundTag.shallowCopy();
            compoundTag1.remove(removeKey);
            return compoundTag1;
        }
        return map;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag tag) {
        if (tag instanceof EndTag) {
            return Optional.of(InitialListCollector.INSTANCE);
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            if (collectionTag.isEmpty()) {
                return Optional.of(InitialListCollector.INSTANCE);
            }
            if (collectionTag instanceof ListTag) {
                ListTag listTag = (ListTag)collectionTag;
                return switch (listTag.getElementType()) {
                    case 0 -> Optional.of(InitialListCollector.INSTANCE);
                    case 10 -> Optional.of(new HeterogenousListCollector(listTag));
                    default -> Optional.of(new HomogenousListCollector(listTag));
                };
            }
            if (collectionTag instanceof ByteArrayTag) {
                ByteArrayTag byteArrayTag = (ByteArrayTag)collectionTag;
                return Optional.of(new ByteListCollector(byteArrayTag.getAsByteArray()));
            }
            if (collectionTag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)collectionTag;
                return Optional.of(new IntListCollector(intArrayTag.getAsIntArray()));
            }
            if (collectionTag instanceof LongArrayTag) {
                LongArrayTag longArrayTag = (LongArrayTag)collectionTag;
                return Optional.of(new LongListCollector(longArrayTag.getAsLongArray()));
            }
        }
        return Optional.empty();
    }

    static class InitialListCollector
    implements ListCollector {
        public static final InitialListCollector INSTANCE = new InitialListCollector();

        private InitialListCollector() {
        }

        @Override
        public ListCollector accept(Tag tag) {
            ListCollector listCollector;
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                return new HeterogenousListCollector().accept(compoundTag);
            }
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                return new ByteListCollector(byteTag.getAsByte());
            }
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                return new IntListCollector(intTag.getAsInt());
            }
            if (tag instanceof LongTag) {
                LongTag longTag = (LongTag)tag;
                listCollector = new LongListCollector(longTag.getAsLong());
            } else {
                listCollector = new HomogenousListCollector(tag);
            }
            return listCollector;
        }

        @Override
        public Tag result() {
            return new ListTag();
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> tags) {
            ListCollector listCollector = this;
            for (Tag tag : tags) {
                listCollector = listCollector.accept(tag);
            }
            return listCollector;
        }

        default public ListCollector acceptAll(Stream<Tag> tags) {
            return this.acceptAll(tags::iterator);
        }

        public Tag result();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps this$0) {
            super((DynamicOps)this$0);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String key, Tag value, CompoundTag tag) {
            tag.put(key, value);
            return tag;
        }

        protected DataResult<Tag> build(CompoundTag compoundTag, Tag tag) {
            if (tag == null || tag == EndTag.INSTANCE) {
                return DataResult.success((Object)compoundTag);
            }
            if (!(tag instanceof CompoundTag)) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
            }
            CompoundTag compoundTag1 = (CompoundTag)tag;
            CompoundTag compoundTag2 = compoundTag1.shallowCopy();
            for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                compoundTag2.put(entry.getKey(), entry.getValue());
            }
            return DataResult.success((Object)compoundTag2);
        }
    }

    static class HeterogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        public HeterogenousListCollector() {
        }

        public HeterogenousListCollector(Collection<Tag> tags) {
            this.result.addAll(tags);
        }

        public HeterogenousListCollector(IntArrayList data) {
            data.forEach(i -> this.result.add(HeterogenousListCollector.wrapElement(IntTag.valueOf(i))));
        }

        public HeterogenousListCollector(ByteArrayList data) {
            data.forEach(b -> this.result.add(HeterogenousListCollector.wrapElement(ByteTag.valueOf(b))));
        }

        public HeterogenousListCollector(LongArrayList data) {
            data.forEach(l -> this.result.add(HeterogenousListCollector.wrapElement(LongTag.valueOf(l))));
        }

        private static boolean isWrapper(CompoundTag tag) {
            return tag.size() == 1 && tag.contains(NbtOps.WRAPPER_MARKER);
        }

        private static Tag wrapIfNeeded(Tag tag) {
            CompoundTag compoundTag;
            return tag instanceof CompoundTag && !HeterogenousListCollector.isWrapper(compoundTag = (CompoundTag)tag) ? compoundTag : HeterogenousListCollector.wrapElement(tag);
        }

        private static CompoundTag wrapElement(Tag tag) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.put(NbtOps.WRAPPER_MARKER, tag);
            return compoundTag;
        }

        @Override
        public ListCollector accept(Tag tag) {
            this.result.add(HeterogenousListCollector.wrapIfNeeded(tag));
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class HomogenousListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        HomogenousListCollector(Tag value) {
            this.result.add(value);
        }

        HomogenousListCollector(ListTag values) {
            this.result.addAll(values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag.getId() != this.result.getElementType()) {
                return new HeterogenousListCollector().acceptAll(this.result).accept(tag);
            }
            this.result.add(tag);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte value) {
            this.values.add(value);
        }

        public ByteListCollector(byte[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                this.values.add(byteTag.getAsByte());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int value) {
            this.values.add(value);
        }

        public IntListCollector(int[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                this.values.add(intTag.getAsInt());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long value) {
            this.values.add(value);
        }

        public LongListCollector(long[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof LongTag) {
                LongTag longTag = (LongTag)tag;
                this.values.add(longTag.getAsLong());
                return this;
            }
            return new HeterogenousListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }
}

