/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;

public class TagParser {
    public static final SimpleCommandExceptionType ERROR_TRAILING_DATA = new SimpleCommandExceptionType((Message)Component.translatable("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_KEY = new SimpleCommandExceptionType((Message)Component.translatable("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_VALUE = new SimpleCommandExceptionType((Message)Component.translatable("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType ERROR_INSERT_MIXED_LIST = new Dynamic2CommandExceptionType((listElementType, elementType) -> Component.translatableEscape("argument.nbt.list.mixed", listElementType, elementType));
    public static final Dynamic2CommandExceptionType ERROR_INSERT_MIXED_ARRAY = new Dynamic2CommandExceptionType((elementType, arrayType) -> Component.translatableEscape("argument.nbt.array.mixed", elementType, arrayType));
    public static final DynamicCommandExceptionType ERROR_INVALID_ARRAY = new DynamicCommandExceptionType(arrayType -> Component.translatableEscape("argument.nbt.array.invalid", arrayType));
    public static final char ELEMENT_SEPARATOR = ',';
    public static final char NAME_VALUE_SEPARATOR = ':';
    private static final char LIST_OPEN = '[';
    private static final char LIST_CLOSE = ']';
    private static final char STRUCT_CLOSE = '}';
    private static final char STRUCT_OPEN = '{';
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    public static final Codec<CompoundTag> AS_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)new TagParser(new StringReader(string)).readSingleStruct(), (Lifecycle)Lifecycle.stable());
        }
        catch (CommandSyntaxException var2) {
            return DataResult.error(var2::getMessage);
        }
    }, CompoundTag::toString);
    public static final Codec<CompoundTag> LENIENT_CODEC = Codec.withAlternative(AS_CODEC, CompoundTag.CODEC);
    private final StringReader reader;
    private int depth;

    public static CompoundTag parseTag(String text) throws CommandSyntaxException {
        return new TagParser(new StringReader(text)).readSingleStruct();
    }

    @VisibleForTesting
    CompoundTag readSingleStruct() throws CommandSyntaxException {
        CompoundTag struct = this.readStruct();
        this.reader.skipWhitespace();
        if (this.reader.canRead()) {
            throw ERROR_TRAILING_DATA.createWithContext((ImmutableStringReader)this.reader);
        }
        return struct;
    }

    public TagParser(StringReader reader) {
        this.reader = reader;
    }

    protected String readKey() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.reader.readString();
    }

    protected Tag readTypedValue() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        int cursor = this.reader.getCursor();
        if (StringReader.isQuotedStringStart((char)this.reader.peek())) {
            return StringTag.valueOf(this.reader.readQuotedString());
        }
        String unquotedString = this.reader.readUnquotedString();
        if (unquotedString.isEmpty()) {
            this.reader.setCursor(cursor);
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        return this.type(unquotedString);
    }

    public Tag type(String value) {
        try {
            if (FLOAT_PATTERN.matcher(value).matches()) {
                return FloatTag.valueOf(Float.parseFloat(value.substring(0, value.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(value).matches()) {
                return ByteTag.valueOf(Byte.parseByte(value.substring(0, value.length() - 1)));
            }
            if (LONG_PATTERN.matcher(value).matches()) {
                return LongTag.valueOf(Long.parseLong(value.substring(0, value.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(value).matches()) {
                return ShortTag.valueOf(Short.parseShort(value.substring(0, value.length() - 1)));
            }
            if (INT_PATTERN.matcher(value).matches()) {
                return IntTag.valueOf(Integer.parseInt(value));
            }
            if (DOUBLE_PATTERN.matcher(value).matches()) {
                return DoubleTag.valueOf(Double.parseDouble(value.substring(0, value.length() - 1)));
            }
            if (DOUBLE_PATTERN_NOSUFFIX.matcher(value).matches()) {
                return DoubleTag.valueOf(Double.parseDouble(value));
            }
            if ("true".equalsIgnoreCase(value)) {
                return ByteTag.ONE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return ByteTag.ZERO;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return StringTag.valueOf(value);
    }

    public Tag readValue() throws CommandSyntaxException {
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        char c = this.reader.peek();
        if (c == '{') {
            return this.readStruct();
        }
        return c == '[' ? this.readList() : this.readTypedValue();
    }

    protected Tag readList() throws CommandSyntaxException {
        return this.reader.canRead(3) && !StringReader.isQuotedStringStart((char)this.reader.peek(1)) && this.reader.peek(2) == ';' ? this.readArrayTag() : this.readListTag();
    }

    public CompoundTag readStruct() throws CommandSyntaxException {
        this.expect('{');
        this.increaseDepth();
        CompoundTag compoundTag = new CompoundTag();
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != '}') {
            int cursor = this.reader.getCursor();
            String key = this.readKey();
            if (key.isEmpty()) {
                this.reader.setCursor(cursor);
                throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
            }
            this.expect(':');
            compoundTag.put(key, this.readValue());
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_KEY.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect('}');
        --this.depth;
        return compoundTag;
    }

    private Tag readListTag() throws CommandSyntaxException {
        this.expect('[');
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.increaseDepth();
        ListTag listTag = new ListTag();
        TagType<?> tagType = null;
        while (this.reader.peek() != ']') {
            int cursor = this.reader.getCursor();
            Tag value = this.readValue();
            TagType<?> type = value.getType();
            if (tagType == null) {
                tagType = type;
            } else if (type != tagType) {
                this.reader.setCursor(cursor);
                throw ERROR_INSERT_MIXED_LIST.createWithContext((ImmutableStringReader)this.reader, (Object)type.getPrettyName(), (Object)tagType.getPrettyName());
            }
            listTag.add(value);
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        --this.depth;
        return listTag;
    }

    public Tag readArrayTag() throws CommandSyntaxException {
        this.expect('[');
        int cursor = this.reader.getCursor();
        char c = this.reader.read();
        this.reader.read();
        this.reader.skipWhitespace();
        if (!this.reader.canRead()) {
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        if (c == 'B') {
            return new ByteArrayTag(this.readArray(ByteArrayTag.TYPE, ByteTag.TYPE));
        }
        if (c == 'L') {
            return new LongArrayTag(this.readArray(LongArrayTag.TYPE, LongTag.TYPE));
        }
        if (c == 'I') {
            return new IntArrayTag(this.readArray(IntArrayTag.TYPE, IntTag.TYPE));
        }
        this.reader.setCursor(cursor);
        throw ERROR_INVALID_ARRAY.createWithContext((ImmutableStringReader)this.reader, (Object)String.valueOf(c));
    }

    private <T extends Number> List<T> readArray(TagType<?> arrayType, TagType<?> elementType) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        while (this.reader.peek() != ']') {
            int cursor = this.reader.getCursor();
            Tag value = this.readValue();
            TagType<?> type = value.getType();
            if (type != elementType) {
                this.reader.setCursor(cursor);
                throw ERROR_INSERT_MIXED_ARRAY.createWithContext((ImmutableStringReader)this.reader, (Object)type.getPrettyName(), (Object)arrayType.getPrettyName());
            }
            if (elementType == ByteTag.TYPE) {
                list.add(((NumericTag)value).getAsByte());
            } else if (elementType == LongTag.TYPE) {
                list.add(((NumericTag)value).getAsLong());
            } else {
                list.add(((NumericTag)value).getAsInt());
            }
            if (!this.hasElementSeparator()) break;
            if (this.reader.canRead()) continue;
            throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader);
        }
        this.expect(']');
        return list;
    }

    private boolean hasElementSeparator() {
        this.reader.skipWhitespace();
        if (this.reader.canRead() && this.reader.peek() == ',') {
            this.reader.skip();
            this.reader.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char expected) throws CommandSyntaxException {
        this.reader.skipWhitespace();
        this.reader.expect(expected);
    }

    private void increaseDepth() throws CommandSyntaxException {
        ++this.depth;
        if (this.depth > 512) {
            throw new TagParseCommandSyntaxException("NBT tag is too complex, depth > 512");
        }
    }
}

