/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder<T extends PacketListener>
extends MessageToByteEncoder<Packet<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ProtocolInfo<T> protocolInfo;
    static final ThreadLocal<Locale> ADVENTURE_LOCALE = ThreadLocal.withInitial(() -> null);
    private static final int MAX_FINAL_PACKET_SIZE = 0x1FFFFF;
    private static final int MAX_PACKET_SIZE = 0x800000;

    public PacketEncoder(ProtocolInfo<T> protocolInfo) {
        this.protocolInfo = protocolInfo;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, Packet<T> packet, ByteBuf byteBuf) throws Exception {
        PacketType<Packet<T>> packetType = packet.type();
        try {
            ADVENTURE_LOCALE.set((Locale)channelHandlerContext.channel().attr(PaperAdventure.LOCALE_ATTRIBUTE).get());
            this.protocolInfo.codec().encode(byteBuf, packet);
            int i = byteBuf.readableBytes();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(Connection.PACKET_SENT_MARKER, "OUT: [{}:{}] {} -> {} bytes", new Object[]{this.protocolInfo.id().id(), packetType, packet.getClass().getName(), i});
            }
            JvmProfiler.INSTANCE.onPacketSent(this.protocolInfo.id(), packetType, channelHandlerContext.channel().remoteAddress(), i);
        }
        catch (Throwable var9) {
            LOGGER.error("Error sending packet {}", packetType, (Object)var9);
            if (packet.isSkippable()) {
                throw new SkipPacketException(var9);
            }
            throw var9;
        }
        finally {
            int packetLength = byteBuf.readableBytes();
            if (packetLength > 0x800000 || packetLength > 0x1FFFFF && packet.hasLargePacketFallback()) {
                throw new PacketTooLargeException(packet, packetLength);
            }
            ProtocolSwapHandler.handleOutboundTerminalPacket(channelHandlerContext, packet);
        }
    }

    public static class PacketTooLargeException
    extends RuntimeException {
        private final Packet<?> packet;

        PacketTooLargeException(Packet<?> packet, int packetLength) {
            super("PacketTooLarge - " + packet.getClass().getSimpleName() + " is " + packetLength + ". Max is 8388608");
            this.packet = packet;
        }

        public Packet<?> getPacket() {
            return this.packet;
        }
    }
}

