/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> InboundConfigurationTask setupInboundProtocol(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.setupInboundHandler(new PacketDecoder<T>(protocolInfo));
    }

    private static InboundConfigurationTask setupInboundHandler(ChannelInboundHandler handler) {
        return context -> {
            context.pipeline().replace(context.name(), "decoder", (ChannelHandler)handler);
            context.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> OutboundConfigurationTask setupOutboundProtocol(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.setupOutboundHandler(new PacketEncoder<T>(protocolInfo));
    }

    private static OutboundConfigurationTask setupOutboundHandler(ChannelOutboundHandler handler) {
        return context -> context.pipeline().replace(context.name(), "encoder", (ChannelHandler)handler);
    }

    @FunctionalInterface
    public static interface InboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public InboundConfigurationTask andThen(InboundConfigurationTask task) {
            return context -> {
                this.run(context);
                task.run(context);
            };
        }
    }

    @FunctionalInterface
    public static interface OutboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public OutboundConfigurationTask andThen(OutboundConfigurationTask task) {
            return context -> {
                this.run(context);
                task.run(context);
            };
        }
    }

    public static class Outbound
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(message));
            }
            if (message instanceof OutboundConfigurationTask) {
                OutboundConfigurationTask outboundConfigurationTask = (OutboundConfigurationTask)message;
                try {
                    outboundConfigurationTask.run(context);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                context.write(message, promise);
            }
        }
    }

    public static class Inbound
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext context, Object message) {
            if (message instanceof ByteBuf || message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(message));
            }
            context.fireChannelRead(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof InboundConfigurationTask) {
                InboundConfigurationTask inboundConfigurationTask = (InboundConfigurationTask)message;
                try {
                    inboundConfigurationTask.run(context);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                context.write(message, promise);
            }
        }
    }
}

