/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.StringRepresentable;

public class ClickEvent {
    public static final Codec<ClickEvent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Action.CODEC.forGetter(event -> event.action), (App)Codec.STRING.fieldOf("value").forGetter(event -> event.value)).apply((Applicative)instance, ClickEvent::new));
    private final Action action;
    private final String value;

    public ClickEvent(Action action, String value) {
        this.action = action;
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            ClickEvent clickEvent = (ClickEvent)other;
            return this.action == clickEvent.action && this.value.equals(clickEvent.value);
        }
        return false;
    }

    public String toString() {
        return "ClickEvent{action=" + String.valueOf(this.action) + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int hashCode = this.action.hashCode();
        return 31 * hashCode + this.value.hashCode();
    }

    public static enum Action implements StringRepresentable
    {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        public static final MapCodec<Action> UNSAFE_CODEC;
        public static final MapCodec<Action> CODEC;
        private final boolean allowFromServer;
        private final String name;

        private Action(String name, boolean allowFromServer) {
            this.name = name;
            this.allowFromServer = allowFromServer;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static DataResult<Action> filterForSerialization(Action action) {
            return !action.isAllowedFromServer() ? DataResult.error(() -> "Action not allowed: " + String.valueOf(action)) : DataResult.success((Object)action, (Lifecycle)Lifecycle.stable());
        }

        static {
            UNSAFE_CODEC = StringRepresentable.fromEnum(Action::values).fieldOf("action");
            CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        }
    }
}

