/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public interface Component
extends Message,
FormattedText,
Iterable<Component> {
    default public Stream<Component> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.getSiblings().stream().flatMap(Component::stream)});
    }

    @Override
    default public Iterator<Component> iterator() {
        return this.stream().iterator();
    }

    public Style getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int maxLength) {
        StringBuilder stringBuilder = new StringBuilder();
        this.visit(content -> {
            int i = maxLength - stringBuilder.length();
            if (i <= 0) {
                return STOP_ITERATION;
            }
            stringBuilder.append(content.length() <= i ? content : content.substring(0, i));
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public List<Component> getSiblings();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentContents = this.getContents();
        if (!(componentContents instanceof PlainTextContents)) return null;
        PlainTextContents plainTextContents = (PlainTextContents)componentContents;
        if (!this.getSiblings().isEmpty()) return null;
        if (!this.getStyle().isEmpty()) return null;
        String string = plainTextContents.text();
        return string;
    }

    default public MutableComponent plainCopy() {
        return MutableComponent.create(this.getContents());
    }

    default public MutableComponent copy() {
        return new MutableComponent(this.getContents(), new ArrayList<Component>(this.getSiblings()), this.getStyle());
    }

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> acceptor, Style style) {
        Style style1 = this.getStyle().applyTo(style);
        Optional<T> optional = this.getContents().visit(acceptor, style1);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(acceptor, style1);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> acceptor) {
        Optional<T> optional = this.getContents().visit(acceptor);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(acceptor);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<Component> toFlatList() {
        return this.toFlatList(Style.EMPTY);
    }

    default public List<Component> toFlatList(Style style) {
        ArrayList list = Lists.newArrayList();
        this.visit((style1, content) -> {
            if (!content.isEmpty()) {
                list.add(Component.literal(content).withStyle(style1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    default public boolean contains(Component other) {
        List<Component> list1;
        if (this.equals(other)) {
            return true;
        }
        List<Component> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = other.toFlatList(this.getStyle())) != -1;
    }

    public static Component nullToEmpty(@Nullable String text) {
        return text != null ? Component.literal(text) : CommonComponents.EMPTY;
    }

    public static MutableComponent literal(String text) {
        return MutableComponent.create(PlainTextContents.create(text));
    }

    public static MutableComponent translatable(String key) {
        return MutableComponent.create(new TranslatableContents(key, null, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatable(String key, Object ... args) {
        return MutableComponent.create(new TranslatableContents(key, null, args));
    }

    public static MutableComponent translatableEscape(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (TranslatableContents.isAllowedPrimitiveArgument(object) || object instanceof Component) continue;
            args[i] = String.valueOf(object);
        }
        return Component.translatable(key, args);
    }

    public static MutableComponent translatableWithFallback(String key, @Nullable String fallback) {
        return MutableComponent.create(new TranslatableContents(key, fallback, TranslatableContents.NO_ARGS));
    }

    public static MutableComponent translatableWithFallback(String key, @Nullable String fallback, Object ... args) {
        return MutableComponent.create(new TranslatableContents(key, fallback, args));
    }

    public static MutableComponent empty() {
        return MutableComponent.create(PlainTextContents.EMPTY);
    }

    public static MutableComponent keybind(String name) {
        return MutableComponent.create(new KeybindContents(name));
    }

    public static MutableComponent nbt(String nbtPathPattern, boolean interpreting, Optional<Component> separator, DataSource dataSource) {
        return MutableComponent.create(new NbtContents(nbtPathPattern, interpreting, separator, dataSource));
    }

    public static MutableComponent score(SelectorPattern selectorPattern, String objective) {
        return MutableComponent.create(new ScoreContents(Either.left(selectorPattern), objective));
    }

    public static MutableComponent score(String name, String objective) {
        return MutableComponent.create(new ScoreContents(Either.right(name), objective));
    }

    public static MutableComponent selector(SelectorPattern selectorPattern, Optional<Component> seperator) {
        return MutableComponent.create(new SelectorContents(selectorPattern, seperator));
    }

    public static Component translationArg(Date date) {
        return Component.literal(date.toString());
    }

    public static Component translationArg(Message message) {
        Component component;
        if (message instanceof Component) {
            Component component2 = (Component)message;
            component = component2;
        } else {
            component = Component.literal(message.getString());
        }
        return component;
    }

    public static Component translationArg(UUID uuid) {
        return Component.literal(uuid.toString());
    }

    public static Component translationArg(ResourceLocation location) {
        return Component.literal(location.toString());
    }

    public static Component translationArg(ChunkPos chunkPos) {
        return Component.literal(chunkPos.toString());
    }

    public static Component translationArg(URI uri) {
        return Component.literal(uri.toString());
    }

    public static class SerializerAdapter
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private final HolderLookup.Provider registries;

        public SerializerAdapter(HolderLookup.Provider registries) {
            this.registries = registries;
        }

        public MutableComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Serializer.deserialize(json, this.registries);
        }

        public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
            return Serializer.serialize(src, this.registries);
        }
    }

    public static class Serializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private Serializer() {
        }

        static MutableComponent deserialize(JsonElement json, HolderLookup.Provider provider) {
            return (MutableComponent)ComponentSerialization.CODEC.parse(provider.createSerializationContext(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        }

        static JsonElement serialize(Component component, HolderLookup.Provider provider) {
            return (JsonElement)ComponentSerialization.CODEC.encodeStart(provider.createSerializationContext(JsonOps.INSTANCE), (Object)component).getOrThrow(JsonParseException::new);
        }

        public static String toJson(Component component, HolderLookup.Provider registries) {
            return GSON.toJson(Serializer.serialize(component, registries));
        }

        @Nullable
        public static MutableComponent fromJson(String json, HolderLookup.Provider registries) {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return jsonElement == null ? null : Serializer.deserialize(jsonElement, registries);
        }

        @Nullable
        public static MutableComponent fromJson(@Nullable JsonElement json, HolderLookup.Provider registries) {
            return json == null ? null : Serializer.deserialize(json, registries);
        }

        @Nullable
        public static MutableComponent fromJsonLenient(String json, HolderLookup.Provider registries) {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
            jsonReader.setLenient(true);
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
            return jsonElement == null ? null : Serializer.deserialize(jsonElement, registries);
        }
    }
}

