/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HoverEvent {
    public static final Codec<HoverEvent> CODEC = Codec.withAlternative((Codec)TypedHoverEvent.CODEC.codec(), (Codec)TypedHoverEvent.LEGACY_CODEC.codec()).xmap(HoverEvent::new, hoverEvent -> hoverEvent.event);
    private final TypedHoverEvent<?> event;

    public <T> HoverEvent(Action<T> action, T value) {
        this(new TypedHoverEvent<T>(action, value));
    }

    private HoverEvent(TypedHoverEvent<?> event) {
        this.event = event;
    }

    public Action<?> getAction() {
        return this.event.action;
    }

    @Nullable
    public <T> T getValue(Action<T> actionType) {
        return this.event.action == actionType ? (T)actionType.cast(this.event.value) : null;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && ((HoverEvent)other).event.equals(this.event);
    }

    public String toString() {
        return this.event.toString();
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    record TypedHoverEvent<T>(Action<T> action, T value) {
        public static final MapCodec<TypedHoverEvent<?>> CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, hoverEvent -> hoverEvent.codec);
        public static final MapCodec<TypedHoverEvent<?>> LEGACY_CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, hoverEvent -> hoverEvent.legacyCodec);
    }

    public static class Action<T>
    implements StringRepresentable {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", true, ComponentSerialization.CODEC, (name, ops) -> DataResult.success((Object)name));
        public static final Action<ItemStackInfo> SHOW_ITEM = new Action<ItemStackInfo>("show_item", true, ItemStackInfo.CODEC, ItemStackInfo::legacyCreate);
        public static final Action<EntityTooltipInfo> SHOW_ENTITY = new Action<EntityTooltipInfo>("show_entity", true, EntityTooltipInfo.CODEC, EntityTooltipInfo::legacyCreate);
        public static final Codec<Action<?>> UNSAFE_CODEC = StringRepresentable.fromValues(() -> new Action[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY});
        public static final Codec<Action<?>> CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<TypedHoverEvent<T>> codec;
        final MapCodec<TypedHoverEvent<T>> legacyCodec;

        public Action(String name, boolean allowFromServer, Codec<T> codec, final LegacyConverter<T> legacyConverter) {
            this.name = name;
            this.allowFromServer = allowFromServer;
            this.codec = codec.xmap(object -> new TypedHoverEvent<Object>(this, object), typedHoverEvent -> typedHoverEvent.value).fieldOf("contents");
            this.legacyCodec = new Codec<TypedHoverEvent<T>>(){

                public <D> DataResult<Pair<TypedHoverEvent<T>, D>> decode(DynamicOps<D> dynamicOps, D object) {
                    return ComponentSerialization.CODEC.decode(dynamicOps, object).flatMap(pair -> {
                        DataResult dataResult;
                        if (dynamicOps instanceof RegistryOps) {
                            RegistryOps registryOps = (RegistryOps)dynamicOps;
                            dataResult = legacyConverter.parse((Component)pair.getFirst(), registryOps);
                        } else {
                            dataResult = legacyConverter.parse((Component)pair.getFirst(), null);
                        }
                        return dataResult.map(object1 -> Pair.of(new TypedHoverEvent<Object>(this, object1), (Object)pair.getSecond()));
                    });
                }

                public <D> DataResult<D> encode(TypedHoverEvent<T> typedHoverEvent, DynamicOps<D> dynamicOps, D object) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }
            }.fieldOf("value");
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        T cast(Object parameter) {
            return (T)parameter;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<Action<?>> filterForSerialization(@Nullable Action<?> action) {
            if (action == null) {
                return DataResult.error(() -> "Unknown action");
            }
            return !action.isAllowedFromServer() ? DataResult.error(() -> "Action not allowed: " + String.valueOf(action)) : DataResult.success(action, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface LegacyConverter<T> {
        public DataResult<T> parse(Component var1, @Nullable RegistryOps<?> var2);
    }

    public static class ItemStackInfo {
        public static final Codec<ItemStackInfo> FULL_CODEC = ItemStack.CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        private static final Codec<ItemStackInfo> SIMPLE_CODEC = ItemStack.SIMPLE_ITEM_CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        public static final Codec<ItemStackInfo> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
        public final Holder<Item> item;
        public final int count;
        public final DataComponentPatch components;
        @Nullable
        private ItemStack itemStack;

        ItemStackInfo(Holder<Item> item, int count, DataComponentPatch components) {
            this.item = item;
            this.count = count;
            this.components = components;
        }

        public ItemStackInfo(ItemStack stack) {
            this(stack.getItemHolder(), stack.getCount(), stack.getComponentsPatch());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && this.getClass() == other.getClass()) {
                ItemStackInfo itemStackInfo = (ItemStackInfo)other;
                return this.count == itemStackInfo.count && this.item.equals(itemStackInfo.item) && this.components.equals(itemStackInfo.components);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.item.hashCode();
            hashCode = 31 * hashCode + this.count;
            return 31 * hashCode + this.components.hashCode();
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count, this.components);
            }
            return this.itemStack;
        }

        private static DataResult<ItemStackInfo> legacyCreate(Component name, @Nullable RegistryOps<?> ops) {
            try {
                CompoundTag compoundTag = TagParser.parseTag(name.getString());
                NbtOps dynamicOps = ops != null ? ops.withParent(NbtOps.INSTANCE) : NbtOps.INSTANCE;
                return ItemStack.CODEC.parse((DynamicOps)dynamicOps, (Object)compoundTag).map(ItemStackInfo::new);
            }
            catch (CommandSyntaxException var4) {
                return DataResult.error(() -> "Failed to parse item tag: " + var4.getMessage());
            }
        }
    }

    public static class EntityTooltipInfo {
        public static final Codec<EntityTooltipInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(info -> info.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("id").forGetter(info -> info.id), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("name").forGetter(info -> info.name)).apply((Applicative)instance, EntityTooltipInfo::new));
        public final EntityType<?> type;
        public final UUID id;
        public final Optional<Component> name;
        @Nullable
        private List<Component> linesCache;

        public EntityTooltipInfo(EntityType<?> type, UUID id, @Nullable Component name) {
            this(type, id, Optional.ofNullable(name));
        }

        public EntityTooltipInfo(EntityType<?> type, UUID id, Optional<Component> name) {
            this.type = type;
            this.id = id;
            this.name = name;
        }

        public static DataResult<EntityTooltipInfo> legacyCreate(Component name, @Nullable RegistryOps<?> ops) {
            try {
                CompoundTag compoundTag = TagParser.parseTag(name.getString());
                JsonOps dynamicOps = ops != null ? ops.withParent(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult dataResult = ComponentSerialization.CODEC.parse((DynamicOps)dynamicOps, (Object)JsonParser.parseString((String)compoundTag.getString("name")));
                EntityType<?> entityType = BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse(compoundTag.getString("type")));
                UUID uuid = UUID.fromString(compoundTag.getString("id"));
                return dataResult.map(component -> new EntityTooltipInfo(entityType, uuid, (Component)component));
            }
            catch (Exception var7) {
                return DataResult.error(() -> "Failed to parse tooltip: " + var7.getMessage());
            }
        }

        public List<Component> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<Component>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(Component.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(Component.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && this.getClass() == other.getClass()) {
                EntityTooltipInfo entityTooltipInfo = (EntityTooltipInfo)other;
                return this.type.equals(entityTooltipInfo.type) && this.id.equals(entityTooltipInfo.id) && this.name.equals(entityTooltipInfo.name);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.type.hashCode();
            hashCode = 31 * hashCode + this.id.hashCode();
            return 31 * hashCode + this.name.hashCode();
        }
    }
}

