/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.SignedArgument;

public record SignableCommand<S>(List<Argument<S>> arguments) {
    public static <S> boolean hasSignableArguments(ParseResults<S> parseResults) {
        return !SignableCommand.of(parseResults).arguments().isEmpty();
    }

    public static <S> SignableCommand<S> of(ParseResults<S> results) {
        CommandContextBuilder commandContextBuilder1;
        CommandContextBuilder context;
        String string = results.getReader().getString();
        CommandContextBuilder commandContextBuilder = context = results.getContext();
        List<Argument<S>> list = SignableCommand.collectArguments(string, context);
        while ((commandContextBuilder1 = commandContextBuilder.getChild()) != null && commandContextBuilder1.getRootNode() != context.getRootNode()) {
            list.addAll(SignableCommand.collectArguments(string, commandContextBuilder1));
            commandContextBuilder = commandContextBuilder1;
        }
        return new SignableCommand<S>(list);
    }

    private static <S> List<Argument<S>> collectArguments(String key, CommandContextBuilder<S> contextBuilder) {
        ArrayList<Argument<S>> list = new ArrayList<Argument<S>>();
        for (ParsedCommandNode parsedCommandNode : contextBuilder.getNodes()) {
            ParsedArgument parsedArgumentx;
            ArgumentCommandNode argumentCommandNode;
            CommandNode parsedArgument = parsedCommandNode.getNode();
            if (!(parsedArgument instanceof ArgumentCommandNode) || !((argumentCommandNode = (ArgumentCommandNode)parsedArgument).getType() instanceof SignedArgument) || (parsedArgumentx = (ParsedArgument)contextBuilder.getArguments().get(argumentCommandNode.getName())) == null) continue;
            String string = parsedArgumentx.getRange().get(key);
            list.add(new Argument(argumentCommandNode, string));
        }
        return list;
    }

    @Nullable
    public Argument<S> getArgument(String argument) {
        for (Argument<S> argument1 : this.arguments) {
            if (!argument.equals(argument1.name())) continue;
            return argument1;
        }
        return null;
    }

    public record Argument<S>(ArgumentCommandNode<S, ?> node, String value) {
        public String name() {
            return this.node.getName();
        }
    }
}

