/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;

    public static <T extends PacketListener, P extends BundlePacket<? super T>> BundlerInfo createForPacket(final PacketType<P> type, final Function<Iterable<Packet<? super T>>, P> bundler, final BundleDelimiterPacket<? super T> packet) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> packet1, Consumer<Packet<?>> consumer) {
                if (packet1.type() == type) {
                    BundlePacket bundlePacket = (BundlePacket)packet1;
                    consumer.accept(packet);
                    bundlePacket.subPackets().forEach(consumer);
                    consumer.accept(packet);
                } else {
                    consumer.accept(packet1);
                }
            }

            @Override
            @Nullable
            public Bundler startPacketBundling(Packet<?> packet1) {
                return packet1 == packet ? new Bundler(){
                    private final List<Packet<? super T>> bundlePackets = new ArrayList();

                    @Override
                    @Nullable
                    public Packet<?> addPacket(Packet<?> packet2) {
                        if (packet2 == packet) {
                            return (Packet)bundler.apply(this.bundlePackets);
                        }
                        if (this.bundlePackets.size() >= 4096) {
                            throw new IllegalStateException("Too many packets in a bundle");
                        }
                        this.bundlePackets.add(packet2);
                        return null;
                    }
                } : null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    @Nullable
    public Bundler startPacketBundling(Packet<?> var1);

    public static interface Bundler {
        @Nullable
        public Packet<?> addPacket(Packet<?> var1);
    }
}

