/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.resources.ResourceLocation;

public interface CustomPacketPayload {
    public Type<? extends CustomPacketPayload> type();

    public static <B extends ByteBuf, T extends CustomPacketPayload> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> encoder, StreamDecoder<B, T> decoder) {
        return StreamCodec.ofMember(encoder, decoder);
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String id) {
        return new Type(ResourceLocation.withDefaultNamespace(id));
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, CustomPacketPayload> codec(final FallbackProvider<B> fallbackProvider, List<TypeAndCodec<? super B, ?>> typeAndCodecs) {
        final Map<ResourceLocation, StreamCodec> map = typeAndCodecs.stream().collect(Collectors.toUnmodifiableMap(typeAndCodec -> typeAndCodec.type().id(), TypeAndCodec::codec));
        return new StreamCodec<B, CustomPacketPayload>(){

            private StreamCodec<? super B, ? extends CustomPacketPayload> findCodec(ResourceLocation resourceLocation) {
                StreamCodec streamCodec = (StreamCodec)map.get(resourceLocation);
                return streamCodec != null ? streamCodec : fallbackProvider.create(resourceLocation);
            }

            private <T extends CustomPacketPayload> void writeCap(B buffer, Type<T> type, CustomPacketPayload payload) {
                ((FriendlyByteBuf)((Object)buffer)).writeResourceLocation(type.id());
                StreamCodec streamCodec = this.findCodec(type.id);
                streamCodec.encode(buffer, payload);
            }

            @Override
            public void encode(B buffer, CustomPacketPayload value) {
                this.writeCap(buffer, value.type(), value);
            }

            @Override
            public CustomPacketPayload decode(B buffer) {
                ResourceLocation resourceLocation = ((FriendlyByteBuf)((Object)buffer)).readResourceLocation();
                return (CustomPacketPayload)this.findCodec(resourceLocation).decode(buffer);
            }
        };
    }

    public record Type<T extends CustomPacketPayload>(ResourceLocation id) {
    }

    public static interface FallbackProvider<B extends FriendlyByteBuf> {
        public StreamCodec<B, ? extends CustomPacketPayload> create(ResourceLocation var1);
    }

    public record TypeAndCodec<B extends FriendlyByteBuf, T extends CustomPacketPayload>(Type<T> type, StreamCodec<B, T> codec) {
    }
}

