/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record DiscardedPayload(ResourceLocation id, ByteBuf data) implements CustomPacketPayload
{
    public static <T extends FriendlyByteBuf> StreamCodec<T, DiscardedPayload> codec(ResourceLocation id, int maxSize) {
        return CustomPacketPayload.codec((T value, B output) -> output.writeBytes(value.data), (B buffer) -> {
            int i = buffer.readableBytes();
            if (i >= 0 && i <= maxSize) {
                return new DiscardedPayload(id, buffer.readBytes(i));
            }
            throw new IllegalArgumentException("Payload may not be larger than " + maxSize + " bytes");
        });
    }

    public CustomPacketPayload.Type<DiscardedPayload> type() {
        return new CustomPacketPayload.Type<DiscardedPayload>(this.id);
    }
}

