/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ItemObfuscationSession;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.syncher.SynchedEntityData;

public record ClientboundSetEntityDataPacket(int id, List<SynchedEntityData.DataValue<?>> packedItems) implements Packet<ClientGamePacketListener>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetEntityDataPacket> STREAM_CODEC = Packet.codec(ClientboundSetEntityDataPacket::write, ClientboundSetEntityDataPacket::new);
    public static final int EOF_MARKER = 255;

    private ClientboundSetEntityDataPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readVarInt(), ClientboundSetEntityDataPacket.unpack(buffer));
    }

    private static void pack(List<SynchedEntityData.DataValue<?>> dataValues, RegistryFriendlyByteBuf buffer) {
        try (ItemObfuscationSession ignored = ItemObfuscationSession.start(GlobalConfiguration.get().anticheat.obfuscation.items.binding.level);){
            for (SynchedEntityData.DataValue<?> dataValue : dataValues) {
                dataValue.write(buffer);
            }
        }
        buffer.writeByte(255);
    }

    private static List<SynchedEntityData.DataValue<?>> unpack(RegistryFriendlyByteBuf buffer) {
        short i;
        ArrayList list = new ArrayList();
        while ((i = buffer.readUnsignedByte()) != 255) {
            list.add(SynchedEntityData.DataValue.read(buffer, i));
        }
        return list;
    }

    private void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(this.id);
        ClientboundSetEntityDataPacket.pack(this.packedItems, buffer);
    }

    @Override
    public PacketType<ClientboundSetEntityDataPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_ENTITY_DATA;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleSetEntityData(this);
    }
}

