/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ItemObfuscationSession;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class ClientboundSetEquipmentPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetEquipmentPacket> STREAM_CODEC = Packet.codec(ClientboundSetEquipmentPacket::write, ClientboundSetEquipmentPacket::new);
    private static final byte CONTINUE_MASK = -128;
    private final int entity;
    private final List<Pair<EquipmentSlot, ItemStack>> slots;
    private boolean sanitize;

    public ClientboundSetEquipmentPacket(int entity, List<Pair<EquipmentSlot, ItemStack>> slots) {
        this(entity, slots, false);
    }

    public ClientboundSetEquipmentPacket(int entity, List<Pair<EquipmentSlot, ItemStack>> slots, boolean sanitize) {
        this.sanitize = sanitize;
        this.entity = entity;
        this.slots = slots;
    }

    private ClientboundSetEquipmentPacket(RegistryFriendlyByteBuf buffer) {
        byte _byte;
        this.entity = buffer.readVarInt();
        this.slots = Lists.newArrayList();
        do {
            _byte = buffer.readByte();
            EquipmentSlot equipmentSlot = EquipmentSlot.VALUES.get(_byte & 0x7F);
            ItemStack itemStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(buffer);
            this.slots.add((Pair<EquipmentSlot, ItemStack>)Pair.of((Object)equipmentSlot, (Object)itemStack));
        } while ((_byte & 0xFFFFFF80) != 0);
    }

    private void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entity);
        int size = this.slots.size();
        try (ItemObfuscationSession ignored = ItemObfuscationSession.start(this.sanitize ? GlobalConfiguration.get().anticheat.obfuscation.items.binding.level : ItemObfuscationSession.ObfuscationLevel.NONE);){
            for (int i = 0; i < size; ++i) {
                Pair<EquipmentSlot, ItemStack> pair = this.slots.get(i);
                EquipmentSlot equipmentSlot = (EquipmentSlot)pair.getFirst();
                boolean flag = i != size - 1;
                int ordinal = equipmentSlot.ordinal();
                buffer.writeByte(flag ? ordinal | 0xFFFFFF80 : ordinal);
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buffer, (ItemStack)pair.getSecond());
            }
        }
    }

    @Override
    public PacketType<ClientboundSetEquipmentPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_EQUIPMENT;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleSetEquipment(this);
    }

    public int getEntity() {
        return this.entity;
    }

    public List<Pair<EquipmentSlot, ItemStack>> getSlots() {
        return this.slots;
    }
}

