/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(entityName -> Component.translatableEscape("commands.attribute.failed.entity", entityName));
    private static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ATTRIBUTE = new Dynamic2CommandExceptionType((entityName, attributeName) -> Component.translatableEscape("commands.attribute.failed.no_attribute", entityName, attributeName));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((entityName, attributeName, attributeUuid) -> Component.translatableEscape("commands.attribute.failed.no_modifier", attributeName, entityName, attributeUuid));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((entityName, attributeName, attributeUuid) -> Component.translatableEscape("commands.attribute.failed.modifier_already_present", attributeUuid, attributeName, entityName));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("attribute").requires(source -> source.hasPermission(2))).then(Commands.argument("target", EntityArgument.entity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("attribute", ResourceArgument.resource(context, Registries.ATTRIBUTE)).then(((LiteralArgumentBuilder)Commands.literal("get").executes(context1 -> AttributeCommand.getAttributeValue((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(context1 -> AttributeCommand.getAttributeValue((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"scale")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("base").then(Commands.literal("set").then(Commands.argument("value", DoubleArgumentType.doubleArg()).executes(context1 -> AttributeCommand.setAttributeBase((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.literal("get").executes(context1 -> AttributeCommand.getAttributeBase((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(context1 -> AttributeCommand.getAttributeBase((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"scale")))))).then(Commands.literal("reset").executes(context1 -> AttributeCommand.resetAttributeBase((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("modifier").then(Commands.literal("add").then(Commands.argument("id", ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("value", DoubleArgumentType.doubleArg()).then(Commands.literal("add_value").executes(context1 -> AttributeCommand.addModifier((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.ADD_VALUE)))).then(Commands.literal("add_multiplied_base").executes(context1 -> AttributeCommand.addModifier((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).then(Commands.literal("add_multiplied_total").executes(context1 -> AttributeCommand.addModifier((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context1, "id"), DoubleArgumentType.getDouble((CommandContext)context1, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))))))).then(Commands.literal("remove").then(Commands.argument("id", ResourceLocationArgument.id()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandContext, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)commandContext, "attribute")), suggestionsBuilder)).executes(context1 -> AttributeCommand.removeModifier((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)context1, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context1, "id")))))).then(Commands.literal("value").then(Commands.literal("get").then(((RequiredArgumentBuilder)Commands.argument("id", ResourceLocationArgument.id()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandContext, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)commandContext, "attribute")), suggestionsBuilder)).executes(commandContext -> AttributeCommand.getAttributeModifier((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandContext, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)commandContext, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandContext, "id"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(commandContext -> AttributeCommand.getAttributeModifier((CommandSourceStack)commandContext.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)commandContext, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)commandContext, "attribute"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)commandContext, "id"), DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale"))))))))))));
    }

    private static AttributeInstance getAttributeInstance(Entity entity, Holder<Attribute> attribute) throws CommandSyntaxException {
        AttributeInstance instance = AttributeCommand.getLivingEntity(entity).getAttributes().getInstance(attribute);
        if (instance == null) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute));
        }
        return instance;
    }

    private static LivingEntity getLivingEntity(Entity target) throws CommandSyntaxException {
        if (!(target instanceof LivingEntity)) {
            throw ERROR_NOT_LIVING_ENTITY.create((Object)target.getName());
        }
        return (LivingEntity)target;
    }

    private static LivingEntity getEntityWithAttribute(Entity entity, Holder<Attribute> attribute) throws CommandSyntaxException {
        LivingEntity livingEntity = AttributeCommand.getLivingEntity(entity);
        if (!livingEntity.getAttributes().hasAttribute(attribute)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute));
        }
        return livingEntity;
    }

    private static int getAttributeValue(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, double scale) throws CommandSyntaxException {
        LivingEntity entityWithAttribute = AttributeCommand.getEntityWithAttribute(entity, attribute);
        double attributeValue = entityWithAttribute.getAttributeValue(attribute);
        source.sendSuccess(() -> Component.translatable("commands.attribute.value.get.success", AttributeCommand.getAttributeDescription(attribute), entity.getName(), attributeValue), false);
        return (int)(attributeValue * scale);
    }

    private static int getAttributeBase(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, double scale) throws CommandSyntaxException {
        LivingEntity entityWithAttribute = AttributeCommand.getEntityWithAttribute(entity, attribute);
        double attributeBaseValue = entityWithAttribute.getAttributeBaseValue(attribute);
        source.sendSuccess(() -> Component.translatable("commands.attribute.base_value.get.success", AttributeCommand.getAttributeDescription(attribute), entity.getName(), attributeBaseValue), false);
        return (int)(attributeBaseValue * scale);
    }

    private static int getAttributeModifier(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, ResourceLocation id, double scale) throws CommandSyntaxException {
        LivingEntity entityWithAttribute = AttributeCommand.getEntityWithAttribute(entity, attribute);
        AttributeMap attributes = entityWithAttribute.getAttributes();
        if (!attributes.hasModifier(attribute, id)) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute), (Object)id);
        }
        double modifierValue = attributes.getModifierValue(attribute, id);
        source.sendSuccess(() -> Component.translatable("commands.attribute.modifier.value.get.success", Component.translationArg(id), AttributeCommand.getAttributeDescription(attribute), entity.getName(), modifierValue), false);
        return (int)(modifierValue * scale);
    }

    private static Stream<ResourceLocation> getAttributeModifiers(Entity entity, Holder<Attribute> attribute) throws CommandSyntaxException {
        AttributeInstance attributeInstance = AttributeCommand.getAttributeInstance(entity, attribute);
        return attributeInstance.getModifiers().stream().map(AttributeModifier::id);
    }

    private static int setAttributeBase(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, double value) throws CommandSyntaxException {
        AttributeCommand.getAttributeInstance(entity, attribute).setBaseValue(value);
        source.sendSuccess(() -> Component.translatable("commands.attribute.base_value.set.success", AttributeCommand.getAttributeDescription(attribute), entity.getName(), value), false);
        return 1;
    }

    private static int resetAttributeBase(CommandSourceStack source, Entity entity, Holder<Attribute> attribute) throws CommandSyntaxException {
        LivingEntity livingEntity = AttributeCommand.getLivingEntity(entity);
        if (!livingEntity.getAttributes().resetBaseValue(attribute)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute));
        }
        double attributeBaseValue = livingEntity.getAttributeBaseValue(attribute);
        source.sendSuccess(() -> Component.translatable("commands.attribute.base_value.reset.success", AttributeCommand.getAttributeDescription(attribute), entity.getName(), attributeBaseValue), false);
        return 1;
    }

    private static int addModifier(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, ResourceLocation id, double amount, AttributeModifier.Operation operation) throws CommandSyntaxException {
        AttributeInstance attributeInstance = AttributeCommand.getAttributeInstance(entity, attribute);
        AttributeModifier attributeModifier = new AttributeModifier(id, amount, operation);
        if (attributeInstance.hasModifier(id)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute), (Object)id);
        }
        attributeInstance.addPermanentModifier(attributeModifier);
        source.sendSuccess(() -> Component.translatable("commands.attribute.modifier.add.success", Component.translationArg(id), AttributeCommand.getAttributeDescription(attribute), entity.getName()), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack source, Entity entity, Holder<Attribute> attribute, ResourceLocation id) throws CommandSyntaxException {
        AttributeInstance attributeInstance = AttributeCommand.getAttributeInstance(entity, attribute);
        if (attributeInstance.removeModifier(id)) {
            source.sendSuccess(() -> Component.translatable("commands.attribute.modifier.remove.success", Component.translationArg(id), AttributeCommand.getAttributeDescription(attribute), entity.getName()), false);
            return 1;
        }
        throw ERROR_NO_SUCH_MODIFIER.create((Object)entity.getName(), (Object)AttributeCommand.getAttributeDescription(attribute), (Object)id);
    }

    private static Component getAttributeDescription(Holder<Attribute> attribute) {
        return Component.translatable(attribute.value().getDescriptionId());
    }
}

