/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class GameModeCommand {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("gamemode").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("gamemode", GameModeArgument.gameMode()).executes(context -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)context, Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode")))).then(Commands.argument("target", EntityArgument.players()).executes(context -> GameModeCommand.setMode((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "target"), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)context, "gamemode")))))));
    }

    private static void logGamemodeChange(CommandSourceStack source, ServerPlayer player, GameType gameType) {
        MutableComponent component = Component.translatable("gameMode." + gameType.getName());
        if (source.getEntity() == player) {
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.self", component), true);
        } else {
            if (source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                player.sendSystemMessage(Component.translatable("gameMode.changed", component));
            }
            source.sendSuccess(() -> Component.translatable("commands.gamemode.success.other", player.getDisplayName(), component), true);
        }
    }

    private static int setMode(CommandContext<CommandSourceStack> source, Collection<ServerPlayer> players, GameType gameType) {
        int i = 0;
        for (ServerPlayer serverPlayer : players) {
            PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameType, PlayerGameModeChangeEvent.Cause.COMMAND, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.empty());
            if (event != null && !event.isCancelled()) {
                GameModeCommand.logGamemodeChange((CommandSourceStack)source.getSource(), serverPlayer, gameType);
                ++i;
                continue;
            }
            if (event == null || event.cancelMessage() == null) continue;
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> PaperAdventure.asVanilla(event.cancelMessage()), true);
        }
        return i;
    }
}

