/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.UserBanList;

public class PardonCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.pardon.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pardon").requires(source -> source.hasPermission(3))).then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((context, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)context.getSource()).getServer().getPlayerList().getBans().getUserList(), builder)).executes(context -> PardonCommand.pardonPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)context, "targets"))))));
    }

    private static int pardonPlayers(CommandSourceStack source, Collection<GameProfile> gameProfiles) throws CommandSyntaxException {
        UserBanList bans = source.getServer().getPlayerList().getBans();
        int i = 0;
        for (GameProfile gameProfile : gameProfiles) {
            if (!bans.isBanned(gameProfile)) continue;
            bans.remove(gameProfile);
            ++i;
            source.sendSuccess(() -> Component.translatable("commands.pardon.success", Component.literal(gameProfile.getName())), true);
        }
        if (i == 0) {
            throw ERROR_NOT_BANNED.create();
        }
        return i;
    }
}

