/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(source -> source.hasPermission(2))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(context)).executes(context1 -> SetBlockCommand.setBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context1, "block"), Mode.REPLACE, null))).then(Commands.literal("destroy").executes(context1 -> SetBlockCommand.setBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context1, "block"), Mode.DESTROY, null)))).then(Commands.literal("keep").executes(context1 -> SetBlockCommand.setBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context1, "block"), Mode.REPLACE, pos -> pos.getLevel().isEmptyBlock(pos.getPos()))))).then(Commands.literal("replace").executes(context1 -> SetBlockCommand.setBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)context1, "block"), Mode.REPLACE, null)))))));
    }

    private static int setBlock(CommandSourceStack source, BlockPos pos, BlockInput state, Mode mode, @Nullable Predicate<BlockInWorld> predicate) throws CommandSyntaxException {
        boolean flag;
        ServerLevel level = source.getLevel();
        if (predicate != null && !predicate.test(new BlockInWorld(level, pos, true))) {
            throw ERROR_FAILED.create();
        }
        if (mode == Mode.DESTROY) {
            level.destroyBlock(pos, true);
            flag = !state.getState().isAir() || !level.getBlockState(pos).isAir();
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            Clearable.tryClear(blockEntity);
            flag = true;
        }
        if (flag && !state.place(level, pos, 2)) {
            throw ERROR_FAILED.create();
        }
        level.blockUpdated(pos, state.getState().getBlock());
        source.sendSuccess(() -> Component.translatable("commands.setblock.success", pos.getX(), pos.getY(), pos.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }

    public static interface Filter {
        @Nullable
        public BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

