/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawnpoint").requires(source -> source.hasPermission(2))).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException()), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPos.containing(((CommandSourceStack)context.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)context, "pos"), 0.0f))).then(Commands.argument("angle", AngleArgument.angle()).executes(context -> SetSpawnCommand.setSpawn((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)context, "pos"), AngleArgument.getAngle((CommandContext<CommandSourceStack>)context, "angle"))))))));
    }

    private static int setSpawn(CommandSourceStack source, Collection<ServerPlayer> targets, BlockPos pos, float angle) {
        ResourceKey<Level> resourceKey = source.getLevel().dimension();
        ArrayList<ServerPlayer> actualTargets = new ArrayList<ServerPlayer>();
        for (ServerPlayer serverPlayer : targets) {
            if (!serverPlayer.setRespawnPosition(resourceKey, pos, angle, true, false, PlayerSetSpawnEvent.Cause.COMMAND)) continue;
            actualTargets.add(serverPlayer);
        }
        if (actualTargets.isEmpty()) {
            return 0;
        }
        String string = resourceKey.location().toString();
        if (actualTargets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.single", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(angle), string, ((ServerPlayer)actualTargets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.multiple", pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(angle), string, actualTargets.size()), true);
        }
        return actualTargets.size();
    }
}

