/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode<CommandSourceStack> literalCommandNode = dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("teleport").requires(source -> source.hasPermission(2))).then(Commands.argument("location", Vec3Argument.vec3()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getEntityOrException()), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, null)))).then(Commands.argument("destination", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToEntity((CommandSourceStack)context.getSource(), Collections.singleton(((CommandSourceStack)context.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "destination"))))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("location", Vec3Argument.vec3()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, null))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)context, "rotation"), null)))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("facingEntity", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "facingEntity"), EntityAnchorArgument.Anchor.FEET)))).then(Commands.argument("facingAnchor", EntityAnchorArgument.anchor()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtEntity(EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "facingEntity"), EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)context, "facingAnchor")))))))).then(Commands.argument("facingLocation", Vec3Argument.vec3()).executes(context -> TeleportCommand.teleportToPos((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getCoordinates((CommandContext<CommandSourceStack>)context, "location"), null, new LookAt.LookAtPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)context, "facingLocation")))))))).then(Commands.argument("destination", EntityArgument.entity()).executes(context -> TeleportCommand.teleportToEntity((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("tp").requires(source -> source.hasPermission(2))).redirect(literalCommandNode)));
    }

    private static int teleportToEntity(CommandSourceStack source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            TeleportCommand.performTeleport(source, entity, (ServerLevel)destination.level(), destination.getX(), destination.getY(), destination.getZ(), EnumSet.noneOf(Relative.class), destination.getYRot(), destination.getXRot(), null);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).getDisplayName(), destination.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.entity.multiple", targets.size(), destination.getDisplayName()), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSourceStack source, Collection<? extends net.minecraft.world.entity.Entity> targets, ServerLevel level, Coordinates position, @Nullable Coordinates rotation, @Nullable LookAt lookAt) throws CommandSyntaxException {
        Vec3 position1 = position.getPosition(source);
        Vec2 vec2 = rotation == null ? null : rotation.getRotation(source);
        for (net.minecraft.world.entity.Entity entity : targets) {
            Set<Relative> relatives = TeleportCommand.getRelatives(position, rotation, entity.level().dimension() == level.dimension());
            if (vec2 == null) {
                TeleportCommand.performTeleport(source, entity, level, position1.x, position1.y, position1.z, relatives, entity.getYRot(), entity.getXRot(), lookAt);
                continue;
            }
            TeleportCommand.performTeleport(source, entity, level, position1.x, position1.y, position1.z, relatives, vec2.y, vec2.x, lookAt);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).getDisplayName(), TeleportCommand.formatDouble(position1.x), TeleportCommand.formatDouble(position1.y), TeleportCommand.formatDouble(position1.z)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.teleport.success.location.multiple", targets.size(), TeleportCommand.formatDouble(position1.x), TeleportCommand.formatDouble(position1.y), TeleportCommand.formatDouble(position1.z)), true);
        }
        return targets.size();
    }

    private static Set<Relative> getRelatives(Coordinates position, @Nullable Coordinates rotation, boolean absolute) {
        EnumSet<Relative> set = EnumSet.noneOf(Relative.class);
        if (position.isXRelative()) {
            set.add(Relative.DELTA_X);
            if (absolute) {
                set.add(Relative.X);
            }
        }
        if (position.isYRelative()) {
            set.add(Relative.DELTA_Y);
            if (absolute) {
                set.add(Relative.Y);
            }
        }
        if (position.isZRelative()) {
            set.add(Relative.DELTA_Z);
            if (absolute) {
                set.add(Relative.Z);
            }
        }
        if (rotation == null || rotation.isXRelative()) {
            set.add(Relative.X_ROT);
        }
        if (rotation == null || rotation.isYRelative()) {
            set.add(Relative.Y_ROT);
        }
        return set;
    }

    private static String formatDouble(double value) {
        return String.format(Locale.ROOT, "%f", value);
    }

    private static void performTeleport(CommandSourceStack source, net.minecraft.world.entity.Entity target, ServerLevel level, double x, double y, double z, Set<Relative> relatives, float yRot, float xRot, @Nullable LookAt lookAt) throws CommandSyntaxException {
        boolean result;
        BlockPos blockPos = BlockPos.containing(x, y, z);
        if (!Level.isInSpawnableBounds(blockPos)) {
            throw INVALID_POSITION.create();
        }
        double d = relatives.contains((Object)Relative.X) ? x - target.getX() : x;
        double d1 = relatives.contains((Object)Relative.Y) ? y - target.getY() : y;
        double d2 = relatives.contains((Object)Relative.Z) ? z - target.getZ() : z;
        float f = relatives.contains((Object)Relative.Y_ROT) ? yRot - target.getYRot() : yRot;
        float f1 = relatives.contains((Object)Relative.X_ROT) ? xRot - target.getXRot() : xRot;
        float f2 = Mth.wrapDegrees(f);
        float f3 = Mth.wrapDegrees(f1);
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            result = player.teleportTo(level, d, d1, d2, relatives, f2, f3, true, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((World)level.getWorld(), d, d1, d2, f2, f3);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getTo() == null) {
                return;
            }
            to = event.getTo();
            d = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f3 = to.getPitch();
            level = ((CraftWorld)to.getWorld()).getHandle();
            result = target.teleportTo(level, d, d1, d2, relatives, f2, f3, true);
        }
        if (result) {
            LivingEntity livingEntity;
            if (lookAt != null) {
                lookAt.perform(source, target);
            }
            if (!(target instanceof LivingEntity) || !(livingEntity = (LivingEntity)target).isFallFlying()) {
                target.setDeltaMovement(target.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                target.setOnGround(true);
            }
            if (target instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)target;
                pathfinderMob.getNavigation().stop();
            }
        }
    }
}

