/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;

public class WeatherCommand {
    private static final int DEFAULT_TIME = -1;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("weather").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(context -> WeatherCommand.setClear((CommandSourceStack)context.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(context -> WeatherCommand.setClear((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration")))))).then(((LiteralArgumentBuilder)Commands.literal("rain").executes(context -> WeatherCommand.setRain((CommandSourceStack)context.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(context -> WeatherCommand.setRain((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration")))))).then(((LiteralArgumentBuilder)Commands.literal("thunder").executes(context -> WeatherCommand.setThunder((CommandSourceStack)context.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(context -> WeatherCommand.setThunder((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration")))))));
    }

    private static int getDuration(CommandSourceStack source, int time, IntProvider timeProvider) {
        return time == -1 ? timeProvider.sample(source.getLevel().getRandom()) : time;
    }

    private static int setClear(CommandSourceStack source, int time) {
        source.getLevel().setWeatherParameters(WeatherCommand.getDuration(source, time, ServerLevel.RAIN_DELAY), 0, false, false);
        source.sendSuccess(() -> Component.translatable("commands.weather.set.clear"), true);
        return time;
    }

    private static int setRain(CommandSourceStack source, int time) {
        source.getLevel().setWeatherParameters(0, WeatherCommand.getDuration(source, time, ServerLevel.RAIN_DURATION), true, false);
        source.sendSuccess(() -> Component.translatable("commands.weather.set.rain"), true);
        return time;
    }

    private static int setThunder(CommandSourceStack source, int time) {
        source.getLevel().setWeatherParameters(0, WeatherCommand.getDuration(source, time, ServerLevel.THUNDER_DURATION), true, true);
        source.sendSuccess(() -> Component.translatable("commands.weather.set.thunder"), true);
        return time;
    }
}

