/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder
extends GenerationChunkHolder
implements ChunkSystemChunkHolder {
    public static final ChunkResult<LevelChunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    private static final CompletableFuture<ChunkResult<LevelChunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private final LevelHeightAccessor levelHeightAccessor;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    public final PlayerProvider playerProvider;
    private NewChunkHolder newChunkHolder;
    private static final ServerPlayer[] EMPTY_PLAYER_ARRAY = new ServerPlayer[0];
    private final ReferenceList<ServerPlayer> playersSentChunkTo = new ReferenceList<ServerPlayer>(EMPTY_PLAYER_ARRAY);

    private ChunkMap getChunkMap() {
        return (ChunkMap)this.playerProvider;
    }

    @Override
    public final NewChunkHolder moonrise$getRealChunkHolder() {
        return this.newChunkHolder;
    }

    @Override
    public final void moonrise$setRealChunkHolder(NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
    }

    @Override
    public final void moonrise$addReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.add(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final void moonrise$removeReceivedChunk(ServerPlayer player) {
        if (!this.playersSentChunkTo.remove(player)) {
            throw new IllegalStateException("Already sent chunk " + String.valueOf(this.pos) + " in world '" + WorldUtil.getWorldName(this.getChunkMap().level) + "' to player " + String.valueOf(player));
        }
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent() {
        return this.playersSentChunkTo.size() != 0;
    }

    @Override
    public final boolean moonrise$hasChunkBeenSent(ServerPlayer to) {
        return this.playersSentChunkTo.contains(to);
    }

    @Override
    public final List<ServerPlayer> moonrise$getPlayers(boolean onlyOnWatchDistanceEdge) {
        ArrayList<ServerPlayer> ret = new ArrayList<ServerPlayer>();
        ServerPlayer[] raw = this.playersSentChunkTo.getRawDataUnchecked();
        int len = this.playersSentChunkTo.size();
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = raw[i];
            if (onlyOnWatchDistanceEdge && !this.getChunkMap().level.moonrise$getPlayerChunkLoader().isChunkSent(player, this.pos.x, this.pos.z, onlyOnWatchDistanceEdge)) continue;
            ret.add(player);
        }
        return ret;
    }

    @Override
    public final LevelChunk moonrise$getFullChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isFullChunkReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    private boolean isRadiusLoaded(int radius) {
        ChunkHolderManager manager = this.getChunkMap().level.moonrise$getChunkTaskScheduler().chunkHolderManager;
        ChunkPos pos = this.pos;
        int chunkX = pos.x;
        int chunkZ = pos.z;
        for (int dz = -radius; dz <= radius; ++dz) {
            for (int dx = -radius; dx <= radius; ++dx) {
                NewChunkHolder holder;
                if ((dx | dz) == 0 || (holder = manager.getChunkHolder(dx + chunkX, dz + chunkZ)) != null && holder.isFullChunkReady()) continue;
                return false;
            }
        }
        return true;
    }

    public ChunkHolder(ChunkPos pos, int ticketLevel, LevelHeightAccessor levelHeightAccessor, LevelLightEngine lightEngine, LevelChangeListener onLevelChange, PlayerProvider playerProvider) {
        super(pos);
        this.levelHeightAccessor = levelHeightAccessor;
        this.lightEngine = lightEngine;
        this.playerProvider = playerProvider;
        this.setTicketLevel(ticketLevel);
        this.changedBlocksPerSection = new ShortSet[levelHeightAccessor.getSectionsCount()];
    }

    public LevelChunk getFullChunkNow() {
        if (!this.newChunkHolder.isFullChunkReady()) {
            return null;
        }
        return this.getFullChunkNowUnchecked();
    }

    public LevelChunk getFullChunkNowUnchecked() {
        return (LevelChunk)this.getChunkIfPresentUnchecked(ChunkStatus.FULL);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getEntityTickingChunkFuture() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getFullChunkFuture() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final LevelChunk getTickingChunk() {
        ChunkAccess chunkAccess;
        if (this.newChunkHolder.isTickingReady() && (chunkAccess = this.newChunkHolder.getCurrentChunk()) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            return levelChunk;
        }
        return null;
    }

    @Nullable
    public LevelChunk getChunkToSend() {
        LevelChunk ret = this.moonrise$getFullChunk();
        if (ret != null && this.isRadiusLoaded(1)) {
            return ret;
        }
        return null;
    }

    public CompletableFuture<?> getSendSyncFuture() {
        throw new UnsupportedOperationException();
    }

    public void addSendDependency(CompletableFuture<?> dependency) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> getSaveSyncFuture() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadyForSaving() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addSaveDependency(CompletableFuture<?> dependency) {
        throw new UnsupportedOperationException();
    }

    public boolean blockChanged(BlockPos pos) {
        LevelChunk tickingChunk;
        LevelChunk levelChunk = tickingChunk = this.playersSentChunkTo.size() == 0 ? null : this.getChunkToSend();
        if (tickingChunk == null) {
            return false;
        }
        boolean flag = this.hasChangedSections;
        int sectionIndex = this.levelHeightAccessor.getSectionIndex(pos.getY());
        if (sectionIndex < 0 || sectionIndex >= this.changedBlocksPerSection.length) {
            return false;
        }
        if (this.changedBlocksPerSection[sectionIndex] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[sectionIndex] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[sectionIndex].add(SectionPos.sectionRelativePos(pos));
        return !flag;
    }

    public boolean sectionLightChanged(LightLayer lightLayer, int y) {
        LevelChunk tickingChunk;
        ChunkAccess chunkIfPresent = this.getChunkIfPresent(ChunkStatus.INITIALIZE_LIGHT);
        if (chunkIfPresent == null) {
            return false;
        }
        chunkIfPresent.markUnsaved();
        LevelChunk levelChunk = tickingChunk = this.playersSentChunkTo.size() == 0 ? null : this.getChunkToSend();
        if (tickingChunk == null) {
            return false;
        }
        int minLightSection = this.lightEngine.getMinLightSection();
        int maxLightSection = this.lightEngine.getMaxLightSection();
        if (y >= minLightSection && y <= maxLightSection) {
            int i;
            BitSet bitSet = lightLayer == LightLayer.SKY ? this.skyChangedLightSectionFilter : this.blockChangedLightSectionFilter;
            if (!bitSet.get(i = y - minLightSection)) {
                bitSet.set(i);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasChangesToBroadcast() {
        return this.hasChangedSections || !this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty();
    }

    public void broadcastChanges(LevelChunk chunk) {
        if (this.hasChangesToBroadcast()) {
            List<ServerPlayer> players;
            Level level = chunk.getLevel();
            if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
                players = this.moonrise$getPlayers(true);
                if (!players.isEmpty()) {
                    ClientboundLightUpdatePacket clientboundLightUpdatePacket = new ClientboundLightUpdatePacket(chunk.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                    this.broadcast(players, clientboundLightUpdatePacket);
                }
                this.skyChangedLightSectionFilter.clear();
                this.blockChangedLightSectionFilter.clear();
            }
            if (this.hasChangedSections) {
                players = this.moonrise$getPlayers(false);
                for (int i = 0; i < this.changedBlocksPerSection.length; ++i) {
                    ShortSet set = this.changedBlocksPerSection[i];
                    if (set == null) continue;
                    this.changedBlocksPerSection[i] = null;
                    if (players.isEmpty()) continue;
                    int sectionYFromSectionIndex = this.levelHeightAccessor.getSectionYFromSectionIndex(i);
                    SectionPos sectionPos = SectionPos.of(chunk.getPos(), sectionYFromSectionIndex);
                    if (set.size() == 1) {
                        BlockPos blockPos = sectionPos.relativeToBlockPos(set.iterator().nextShort());
                        BlockState blockState = level.getBlockState(blockPos);
                        this.broadcast(players, new ClientboundBlockUpdatePacket(blockPos, blockState));
                        this.broadcastBlockEntityIfNeeded(players, level, blockPos, blockState);
                        continue;
                    }
                    LevelChunkSection section = chunk.getSection(i);
                    ClientboundSectionBlocksUpdatePacket clientboundSectionBlocksUpdatePacket = new ClientboundSectionBlocksUpdatePacket(sectionPos, set, section);
                    this.broadcast(players, clientboundSectionBlocksUpdatePacket);
                    clientboundSectionBlocksUpdatePacket.runUpdates((blockPos1, blockState1) -> this.broadcastBlockEntityIfNeeded(players, level, (BlockPos)blockPos1, (BlockState)blockState1));
                }
                this.hasChangedSections = false;
            }
        }
    }

    private void broadcastBlockEntityIfNeeded(List<ServerPlayer> players, Level level, BlockPos pos, BlockState state) {
        if (state.hasBlockEntity()) {
            this.broadcastBlockEntity(players, level, pos);
        }
    }

    private void broadcastBlockEntity(List<ServerPlayer> players, Level level, BlockPos pos) {
        Packet<ClientGamePacketListener> updatePacket;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (updatePacket = blockEntity.getUpdatePacket()) != null) {
            this.broadcast(players, updatePacket);
        }
    }

    private void broadcast(List<ServerPlayer> players, Packet<?> packet) {
        players.forEach(player -> player.connection.send(packet));
    }

    @Override
    public int getTicketLevel() {
        return this.newChunkHolder.getTicketLevel();
    }

    @Override
    public int getQueueLevel() {
        throw new UnsupportedOperationException();
    }

    private void setQueueLevel(int queueLevel) {
        throw new UnsupportedOperationException();
    }

    public void setTicketLevel(int level) {
    }

    private void scheduleFullChunkPromotion(ChunkMap chunkMap, CompletableFuture<ChunkResult<LevelChunk>> future, Executor executor, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    private void demoteFullChunk(ChunkMap chunkMap, FullChunkStatus fullChunkStatus) {
        throw new UnsupportedOperationException();
    }

    protected void callEventIfUnloading(ChunkMap chunkMap) {
        throw new UnsupportedOperationException();
    }

    protected void updateFutures(ChunkMap chunkMap, Executor executor) {
        throw new UnsupportedOperationException();
    }

    public boolean wasAccessibleSinceLastSave() {
        throw new UnsupportedOperationException();
    }

    public void refreshAccessibility() {
        throw new UnsupportedOperationException();
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> getPlayers(ChunkPos var1, boolean var2);
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void onLevelChange(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }
}

