/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemChunkMap;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider,
GeneratingChunkMap,
ChunkSystemChunkMap {
    private static final ChunkResult<List<ChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<ChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    private static final int MAX_ACTIVE_CHUNK_WRITES = 128;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    private final BlockableEventLoop<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<DimensionDataStorage> overworldDataStorage;
    private final PoiManager poiManager;
    public final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    public final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final DistanceManager distanceManager;
    public final AtomicInteger tickingGenerated = new AtomicInteger();
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    public final Int2ObjectMap<TrackedEntity> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    public int serverViewDistance;
    public final WorldGenContext worldGenContext;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public final ChunkHolder getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public final void moonrise$writeFinishCallback(ChunkPos pos) throws IOException {
        this.handleLegacyStructureIndex(pos);
    }

    public ChunkMap(ServerLevel level, LevelStorageSource.LevelStorageAccess levelStorageAccess, DataFixer fixerUpper, StructureTemplateManager structureManager, Executor dispatcher, BlockableEventLoop<Runnable> mainThreadExecutor, LightChunkGetter lightChunk, ChunkGenerator generator, ChunkProgressListener progressListener, ChunkStatusUpdateListener chunkStatusListener, Supplier<DimensionDataStorage> overworldDataStorage, int viewDistance, boolean sync) {
        super(new RegionStorageInfo(levelStorageAccess.getLevelId(), level.dimension(), "chunk"), levelStorageAccess.getDimensionPath(level.dimension()).resolve("region"), fixerUpper, sync);
        Path dimensionPath = levelStorageAccess.getDimensionPath(level.dimension());
        this.storageName = dimensionPath.getFileName().toString();
        this.level = level;
        RegistryAccess registryAccess = level.registryAccess();
        long seed = level.getSeed();
        ChunkGenerator randomGenerator = generator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)randomGenerator;
            this.randomState = RandomState.create(noiseBasedChunkGenerator.generatorSettings().value(), registryAccess.lookupOrThrow(Registries.NOISE), seed);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), registryAccess.lookupOrThrow(Registries.NOISE), seed);
        }
        this.chunkGeneratorState = generator.createState(registryAccess.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, seed, level.spigotConfig);
        this.mainThreadExecutor = mainThreadExecutor;
        ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(dispatcher, "worldgen");
        this.progressListener = progressListener;
        this.chunkStatusListener = chunkStatusListener;
        ConsecutiveExecutor consecutiveExecutor1 = new ConsecutiveExecutor(dispatcher, "light");
        this.lightEngine = new ThreadedLevelLightEngine(lightChunk, this, this.level.dimensionType().hasSkyLight(), consecutiveExecutor1, null);
        this.distanceManager = new DistanceManager(dispatcher, mainThreadExecutor);
        this.overworldDataStorage = overworldDataStorage;
        this.poiManager = new PoiManager(new RegionStorageInfo(levelStorageAccess.getLevelId(), level.dimension(), "poi"), dimensionPath.resolve("poi"), fixerUpper, sync, registryAccess, level.getServer(), level);
        this.setServerViewDistance(viewDistance);
        this.worldGenContext = new WorldGenContext(level, generator, structureManager, this.lightEngine, null, this::setChunkUnsaved);
    }

    private void setChunkUnsaved(ChunkPos chunkPos) {
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.getType().getCategory().ordinal();
        ReferenceList<ServerPlayer> inRange = this.level.moonrise$getNearbyPlayers().getPlayers(entity.chunkPosition(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        ServerPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = index;
            backingSet[i].mobCounts[n] = backingSet[i].mobCounts[n] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, MobCategory mobCategory) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<ServerPlayer> inRange = this.level.moonrise$getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        ServerPlayer[] backingSet = inRange.getRawDataUnchecked();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = idx;
            backingSet[i].mobBackoffCounts[n] = backingSet[i].mobBackoffCounts[n] + 1;
        }
    }

    public int getMobCountNear(ServerPlayer player, MobCategory mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    private static double euclideanDistanceSquared(ChunkPos chunkPos, net.minecraft.world.entity.Entity entity) {
        double d = SectionPos.sectionToBlockCoord(chunkPos.x, 8);
        double d1 = SectionPos.sectionToBlockCoord(chunkPos.z, 8);
        double d2 = d - entity.getX();
        double d3 = d1 - entity.getZ();
        return d2 * d2 + d3 * d3;
    }

    boolean isChunkTracked(ServerPlayer player, int x, int z) {
        return this.level.moonrise$getPlayerChunkLoader().isChunkSent(player, x, z);
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer player, int x, int z) {
        return this.level.moonrise$getPlayerChunkLoader().isChunkSent(player, x, z, true);
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected ChunkHolder getUpdatingChunkIfPresent(long chunkPos) {
        NewChunkHolder holder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public ChunkHolder getVisibleChunkIfPresent(long chunkPos) {
        NewChunkHolder holder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier getChunkQueueLevel(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    public String getChunkDebugData(ChunkPos pos) {
        ChunkHolder visibleChunkIfPresent = this.getVisibleChunkIfPresent(pos.toLong());
        if (visibleChunkIfPresent == null) {
            return "null";
        }
        String string = visibleChunkIfPresent.getTicketLevel() + "\n";
        ChunkStatus latestStatus = visibleChunkIfPresent.getLatestStatus();
        ChunkAccess latestChunk = visibleChunkIfPresent.getLatestChunk();
        if (latestStatus != null) {
            string = string + "St: \u00a7" + latestStatus.getIndex() + String.valueOf(latestStatus) + "\u00a7r\n";
        }
        if (latestChunk != null) {
            string = string + "Ch: \u00a7" + latestChunk.getPersistedStatus().getIndex() + String.valueOf(latestChunk.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus fullStatus = visibleChunkIfPresent.getFullStatus();
        string = string + "\u00a7" + fullStatus.ordinal() + String.valueOf((Object)fullStatus);
        return string + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder chunkHolder, int range, IntFunction<ChunkStatus> statusGetter) {
        throw new UnsupportedOperationException();
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException exception, String details) {
        StringBuilder stringBuilder = new StringBuilder();
        Consumer<ChunkHolder> consumer = chunk -> chunk.getAllFutures().forEach(pair -> {
            ChunkStatus chunkStatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completableFuture = (CompletableFuture)pair.getSecond();
            if (completableFuture != null && completableFuture.isDone() && completableFuture.join() == null) {
                stringBuilder.append(chunk.getPos()).append(" - status: ").append(chunkStatus).append(" future: ").append(completableFuture).append(System.lineSeparator());
            }
        });
        stringBuilder.append("Updating:").append(System.lineSeparator());
        PlatformHooks.get().getUpdatingChunkHolders(this.level).forEach(consumer);
        stringBuilder.append("Visible:").append(System.lineSeparator());
        PlatformHooks.get().getVisibleChunkHolders(this.level).forEach(consumer);
        CrashReport crashReport = CrashReport.forThrowable(exception, "Chunk loading");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Chunk loading");
        crashReportCategory.setDetail("Details", details);
        crashReportCategory.setDetail("Futures", stringBuilder);
        return new ReportedException(crashReport);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long chunkPos, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
        throw new UnsupportedOperationException();
    }

    private void onLevelChange(ChunkPos chunkPos, IntSupplier queueLevelGetter, int ticketLevel, IntConsumer queueLevelSetter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void saveAllChunks(boolean flush) {
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void tick(BooleanSupplier hasMoreTime) {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("poi");
        this.poiManager.tick(hasMoreTime);
        profilerFiller.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(hasMoreTime);
        }
        profilerFiller.pop();
    }

    public boolean hasWork() {
        throw new UnsupportedOperationException();
    }

    private void processUnloads(BooleanSupplier hasMoreTime) {
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    private void saveChunksEagerly(BooleanSupplier hasMoreTime) {
        throw new UnsupportedOperationException();
    }

    private void scheduleUnload(long chunkPos, ChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    protected boolean promoteChunkMap() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    private ChunkAccess handleChunkLoadFailure(Throwable exception, ChunkPos chunkPos) {
        boolean flag1;
        Throwable throwable;
        Throwable throwable2;
        if (exception instanceof CompletionException) {
            CompletionException completionException = (CompletionException)exception;
            v0 = completionException.getCause();
        } else {
            v0 = throwable2 = exception;
        }
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)throwable2;
            throwable = reportedException.getCause();
        } else {
            throwable = throwable2;
        }
        Throwable throwable1 = throwable;
        boolean flag = throwable1 instanceof Error;
        boolean bl = flag1 = throwable1 instanceof IOException || throwable1 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.level.getServer().reportChunkLoadFailure(throwable1, this.storageInfo(), chunkPos);
            return this.createEmptyChunk(chunkPos);
        }
        CrashReport crashReport = CrashReport.forThrowable(exception, "Exception loading chunk");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Chunk being loaded");
        crashReportCategory.setDetail("pos", chunkPos);
        this.markPositionReplaceable(chunkPos);
        throw new ReportedException(crashReport);
    }

    private ChunkAccess createEmptyChunk(ChunkPos chunkPos) {
        this.markPositionReplaceable(chunkPos);
        return new ProtoChunk(chunkPos, UpgradeData.EMPTY, this.level, (Registry<Biome>)this.level.registryAccess().lookupOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos chunkPos) {
        this.chunkTypeCache.put(chunkPos.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos chunkPos, ChunkType chunkType) {
        return this.chunkTypeCache.put(chunkPos.toLong(), (byte)(chunkType == ChunkType.PROTOCHUNK ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder chunk, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus targetStatus, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    private void runGenerationTask(ChunkGenerationTask task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runGenerationTasks() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    private void onChunkReadyToSend(ChunkHolder chunkHolder, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder chunk, long gametime) {
        throw new UnsupportedOperationException();
    }

    public boolean save(ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean isExistingChunkFull(ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    public void setServerViewDistance(int viewDistance) {
        int clamped = Mth.clamp(viewDistance, 2, MoonriseConstants.MAX_VIEW_DISTANCE);
        if (clamped == this.serverViewDistance) {
            return;
        }
        this.serverViewDistance = clamped;
        this.level.moonrise$getPlayerChunkLoader().setLoadDistance(this.serverViewDistance + 1);
    }

    int getPlayerViewDistance(ServerPlayer player) {
        return PlatformHooks.get().getSendViewDistance(player);
    }

    private void markChunkPendingToSend(ServerPlayer player, ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void dropChunk(ServerPlayer player, ChunkPos chunkPos) {
    }

    @Override
    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        CompletableFuture<Optional<CompoundTag>> ret = new CompletableFuture<Optional<CompoundTag>>();
        MoonriseRegionFileIO.loadDataAsync(this.level, pos.x, pos.z, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (data, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(Optional.ofNullable(data));
            }
        }, false);
        return ret;
    }

    @Override
    public CompletableFuture<Void> write(ChunkPos pos, Supplier<CompoundTag> tag) {
        MoonriseRegionFileIO.scheduleSave(this.level, pos.x, pos.z, tag.get(), MoonriseRegionFileIO.RegionFileType.CHUNK_DATA);
        return null;
    }

    @Override
    public void flushWorker() {
        MoonriseRegionFileIO.flush(this.level);
    }

    @Nullable
    public LevelChunk getChunkToSend(long chunkPos) {
        ChunkHolder visibleChunkIfPresent = this.getVisibleChunkIfPresent(chunkPos);
        return visibleChunkIfPresent == null ? null : visibleChunkIfPresent.getChunkToSend();
    }

    public int size() {
        return PlatformHooks.get().getVisibleChunkHolderCount(this.level);
    }

    public net.minecraft.server.level.DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable(PlatformHooks.get().getVisibleChunkHolders(this.level));
    }

    void dumpChunks(Writer writer) throws IOException {
        CsvOutput csvOutput = CsvOutput.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(writer);
        TickingTracker tickingTracker = this.distanceManager.tickingTracker();
        for (ChunkHolder entry : PlatformHooks.get().getVisibleChunkHolders(this.level)) {
            long longKey = entry.pos.toLong();
            ChunkPos chunkPos = new ChunkPos(longKey);
            ChunkHolder chunkHolder = entry;
            Optional<ChunkAccess> optional = Optional.ofNullable(chunkHolder.getLatestChunk());
            Optional<Object> optional1 = optional.flatMap(chunk -> chunk instanceof LevelChunk ? Optional.of((LevelChunk)chunk) : Optional.empty());
            csvOutput.writeRow(chunkPos.x, chunkPos.z, chunkHolder.getTicketLevel(), optional.isPresent(), optional.map(ChunkAccess::getPersistedStatus).orElse(null), optional1.map(LevelChunk::getFullStatus).orElse(null), ChunkMap.printFuture(chunkHolder.getFullChunkFuture()), ChunkMap.printFuture(chunkHolder.getTickingChunkFuture()), ChunkMap.printFuture(chunkHolder.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString(longKey), this.anyPlayerCloseEnoughForSpawning(chunkPos), optional1.map(chunk -> chunk.getBlockEntities().size()).orElse(0), tickingTracker.getTicketDebugString(longKey), tickingTracker.getLevel(longKey), optional1.map(chunk -> chunk.getBlockTicks().count()).orElse(0), optional1.map(chunk -> chunk.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> future) {
        try {
            ChunkResult chunkResult = future.getNow(null);
            if (chunkResult != null) {
                return chunkResult.isSuccess() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException var2) {
            return "failed " + var2.getCause().getMessage();
        }
        catch (CancellationException var3) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos pos) {
        return this.read(pos).thenApplyAsync(optional -> optional.map(tag -> this.upgradeChunkTag((CompoundTag)tag, pos)), Util.backgroundExecutor().forName("upgradeChunk"));
    }

    public CompoundTag upgradeChunkTag(CompoundTag tag, ChunkPos pos) {
        return this.upgradeChunkTag(this.level.getTypeKey(), this.overworldDataStorage, tag, this.generator().getTypeNameForDataFixer(), pos, this.level);
    }

    void forEachSpawnCandidateChunk(Consumer<ChunkHolder> action) {
        LongIterator spawnCandidateChunks = this.distanceManager.getSpawnCandidateChunks();
        while (spawnCandidateChunks.hasNext()) {
            long l = spawnCandidateChunks.nextLong();
            ChunkHolder chunkHolder = this.getVisibleChunkIfPresent(l);
            if (chunkHolder == null || !this.anyPlayerCloseEnoughForSpawningInternal(chunkHolder.getPos())) continue;
            action.accept(chunkHolder);
        }
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkPos) {
        return this.anyPlayerCloseEnoughForSpawning(chunkPos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkPos, boolean reducedRange) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, reducedRange);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkPos chunkPos) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkPos, false);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkPos chunkPos, boolean reducedRange) {
        ReferenceList<ServerPlayer> players = this.level.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            ServerPlayer serverPlayer = raw[i];
            double blockRange = 16384.0;
            if (reducedRange) {
                PlayerNaturallySpawnCreaturesEvent event = serverPlayer.playerNaturallySpawnedEvent;
                if (event == null || event.isCancelled()) continue;
                blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
            }
            if (!this.playerIsCloseEnoughForSpawning(serverPlayer, chunkPos, blockRange)) continue;
            return true;
        }
        return false;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos chunkPos) {
        ReferenceList<ServerPlayer> players = this.level.moonrise$getNearbyPlayers().getPlayers(chunkPos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return new ArrayList<ServerPlayer>();
        }
        ArrayList<ServerPlayer> ret = null;
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = raw[i];
            if (!this.playerIsCloseEnoughForSpawning(player, chunkPos, 16384.0)) continue;
            if (ret == null) {
                ret = new ArrayList(len - i);
                ret.add(player);
                continue;
            }
            ret.add(player);
        }
        return ret == null ? new ArrayList<ServerPlayer>() : ret;
    }

    public boolean playerIsCloseEnoughForSpawning(ServerPlayer player, ChunkPos chunkPos, double range) {
        if (player.isSpectator()) {
            return false;
        }
        double d = ChunkMap.euclideanDistanceSquared(chunkPos, player);
        return d < range;
    }

    private boolean skipPlayer(ServerPlayer player) {
        return player.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(ServerPlayer player, boolean track) {
        boolean flag = this.skipPlayer(player);
        boolean flag1 = this.playerMap.ignoredOrUnknown(player);
        if (track) {
            this.playerMap.addPlayer(player, flag);
            this.updatePlayerPos(player);
            if (!flag) {
                this.distanceManager.addPlayer(SectionPos.of(player), player);
                this.distanceManager.moonrise$addPlayer(player, SectionPos.of(player));
            }
            player.setChunkTrackingView(ChunkTrackingView.EMPTY);
            PlatformHooks.get().addPlayerToDistanceMaps(this.level, player);
        } else {
            SectionPos lastSectionPos = player.getLastSectionPos();
            this.playerMap.removePlayer(player);
            if (!flag1) {
                this.distanceManager.removePlayer(lastSectionPos, player);
                this.distanceManager.moonrise$removePlayer(player, SectionPos.of(player));
            }
            PlatformHooks.get().removePlayerFromDistanceMaps(this.level, player);
        }
    }

    private void updatePlayerPos(ServerPlayer player) {
        SectionPos sectionPos = SectionPos.of(player);
        player.setLastSectionPos(sectionPos);
    }

    public void move(ServerPlayer player) {
        boolean flag2;
        SectionPos lastSectionPos = player.getLastSectionPos();
        SectionPos sectionPos = SectionPos.of(player);
        boolean flag = this.playerMap.ignored(player);
        boolean flag1 = this.skipPlayer(player);
        boolean bl = flag2 = lastSectionPos.asLong() != sectionPos.asLong();
        if (flag2 || flag != flag1) {
            this.updatePlayerPos(player);
            this.distanceManager.moonrise$updatePlayer(player, lastSectionPos, sectionPos, flag, flag1);
            if (!flag) {
                this.distanceManager.removePlayer(lastSectionPos, player);
            }
            if (!flag1) {
                this.distanceManager.addPlayer(sectionPos, player);
            }
            if (!flag && flag1) {
                this.playerMap.ignorePlayer(player);
            }
            if (flag && !flag1) {
                this.playerMap.unIgnorePlayer(player);
            }
        }
        PlatformHooks.get().updateMaps(this.level, player);
    }

    private void updateChunkTracking(ServerPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView chunkTrackingView) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos pos, boolean boundaryOnly) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(pos.toLong());
        if (holder == null) {
            return new ArrayList<ServerPlayer>();
        }
        return holder.moonrise$getPlayers(boundaryOnly);
    }

    public void addEntity(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.level() != this.level || this.entityMap.containsKey(entity.getId())) {
            LOGGER.error("Illegal ChunkMap::addEntity for world " + this.level.getWorld().getName() + ": " + String.valueOf(entity) + (this.entityMap.containsKey(entity.getId()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof ServerPlayer && ((ServerPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EnderDragonPart)) {
            EntityType<?> type = entity.getType();
            int i = type.clientTrackingRange() * 16;
            if ((i = TrackingRange.getEntityTrackingRange(entity, i)) != 0) {
                int updateInterval = type.updateInterval();
                if (this.entityMap.containsKey(entity.getId())) {
                    throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
                }
                TrackedEntity trackedEntity = new TrackedEntity(entity, i, updateInterval, type.trackDeltas());
                this.entityMap.put(entity.getId(), (Object)trackedEntity);
                if (entity.moonrise$getTrackedEntity() != null) {
                    throw new IllegalStateException("Entity is already tracked");
                }
                entity.moonrise$setTrackedEntity(trackedEntity);
                trackedEntity.updatePlayers(this.level.players());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    this.updatePlayerStatus(serverPlayer, true);
                    for (TrackedEntity trackedEntity1 : this.entityMap.values()) {
                        if (trackedEntity1.entity == serverPlayer) continue;
                        trackedEntity1.updatePlayer(serverPlayer);
                    }
                }
            }
        }
    }

    protected void removeEntity(net.minecraft.world.entity.Entity entity) {
        TrackedEntity trackedEntity1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.updatePlayerStatus(serverPlayer, false);
            for (TrackedEntity trackedEntity : this.entityMap.values()) {
                trackedEntity.removePlayer(serverPlayer);
            }
        }
        if ((trackedEntity1 = (TrackedEntity)this.entityMap.remove(entity.getId())) != null) {
            trackedEntity1.broadcastRemoved();
        }
        entity.moonrise$setTrackedEntity(null);
    }

    private void newTrackerTick() {
        ServerEntityLookup entityLookup = (ServerEntityLookup)this.level.moonrise$getEntityLookup();
        ReferenceList<net.minecraft.world.entity.Entity> trackerEntities = entityLookup.trackerEntities;
        net.minecraft.world.entity.Entity[] trackerEntitiesRaw = trackerEntities.getRawDataUnchecked();
        int len = trackerEntities.size();
        for (int i = 0; i < len; ++i) {
            net.minecraft.world.entity.Entity entity = trackerEntitiesRaw[i];
            TrackedEntity tracker = entity.moonrise$getTrackedEntity();
            if (tracker == null) continue;
            tracker.moonrise$tick(entity.moonrise$getChunkData().nearbyPlayers);
            if (!tracker.moonrise$hasPlayers() && !entity.moonrise$getChunkStatus().isOrAfter(FullChunkStatus.ENTITY_TICKING)) continue;
            tracker.serverEntity.sendChanges();
        }
    }

    protected void tick() {
        this.newTrackerTick();
    }

    public void broadcast(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity trackedEntity = (TrackedEntity)this.entityMap.get(entity.getId());
        if (trackedEntity != null) {
            trackedEntity.broadcast(packet);
        }
    }

    protected void broadcastAndSend(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity trackedEntity = (TrackedEntity)this.entityMap.get(entity.getId());
        if (trackedEntity != null) {
            trackedEntity.broadcastAndSend(packet);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> chunks) {
        HashMap<ServerPlayer, List> map = new HashMap<ServerPlayer, List>();
        for (ChunkAccess chunkAccess : chunks) {
            LevelChunk levelChunk;
            ChunkPos pos = chunkAccess.getPos();
            LevelChunk levelChunk1 = chunkAccess instanceof LevelChunk ? (levelChunk = (LevelChunk)chunkAccess) : this.level.getChunk(pos.x, pos.z);
            for (ServerPlayer serverPlayer : this.getPlayers(pos, false)) {
                map.computeIfAbsent(serverPlayer, player -> new ArrayList()).add(levelChunk1);
            }
        }
        map.forEach((player, list) -> player.connection.send(ClientboundChunksBiomesPacket.forChunks(list)));
    }

    protected PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos chunkPos, FullChunkStatus fullChunkStatus) {
        this.chunkStatusListener.onChunkStatusChange(chunkPos, fullChunkStatus);
    }

    public void waitForLightBeforeSending(ChunkPos chunkPos, int range) {
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class DistanceManager
    extends net.minecraft.server.level.DistanceManager
    implements ChunkSystemDistanceManager {
        protected DistanceManager(Executor dispatcher, Executor mainThreadExecutor) {
            super(dispatcher, mainThreadExecutor);
        }

        @Override
        public final ChunkMap moonrise$getChunkMap() {
            return ChunkMap.this;
        }

        @Override
        protected boolean isChunkToRemove(long chunkPos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long chunkPos) {
            return ChunkMap.this.getUpdatingChunkIfPresent(chunkPos);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long chunkPos, int newLevel, @Nullable ChunkHolder holder, int oldLevel) {
            return ChunkMap.this.updateChunkScheduling(chunkPos, newLevel, holder, oldLevel);
        }
    }

    public class TrackedEntity
    implements EntityTrackerTrackedEntity {
        public final ServerEntity serverEntity;
        final net.minecraft.world.entity.Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = new ReferenceOpenHashSet();
        private long lastChunkUpdate = -1L;
        private NearbyPlayers.TrackedChunk lastTrackedChunk;

        @Override
        public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
            ServerPlayer player;
            if (chunk == null) {
                this.moonrise$clearPlayers();
                return;
            }
            ReferenceList<ServerPlayer> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
            if (players == null) {
                this.moonrise$clearPlayers();
                return;
            }
            long lastChunkUpdate = this.lastChunkUpdate;
            long currChunkUpdate = chunk.getUpdateCount();
            NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
            this.lastChunkUpdate = currChunkUpdate;
            this.lastTrackedChunk = chunk;
            ServerPlayer[] playersRaw = players.getRawDataUnchecked();
            int len = players.size();
            for (int i = 0; i < len; ++i) {
                player = playersRaw[i];
                this.updatePlayer(player);
            }
            if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
                for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
                    player = conn.getPlayer();
                    if (players.contains(player)) continue;
                    this.removePlayer(player);
                }
            }
        }

        @Override
        public final void moonrise$removeNonTickThreadPlayers() {
            boolean foundToRemove = false;
            for (ServerPlayerConnection conn : this.seenBy) {
                if (TickThread.isTickThreadFor(conn.getPlayer())) continue;
                foundToRemove = true;
                break;
            }
            if (!foundToRemove) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
                ServerPlayer player = conn.getPlayer();
                if (TickThread.isTickThreadFor(player)) continue;
                this.removePlayer(player);
            }
        }

        @Override
        public final void moonrise$clearPlayers() {
            this.lastChunkUpdate = -1L;
            this.lastTrackedChunk = null;
            if (this.seenBy.isEmpty()) {
                return;
            }
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
                ServerPlayer player = conn.getPlayer();
                this.removePlayer(player);
            }
        }

        @Override
        public final boolean moonrise$hasPlayers() {
            return !this.seenBy.isEmpty();
        }

        public TrackedEntity(net.minecraft.world.entity.Entity entity, int range, int updateInterval, boolean trackDelta) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, entity, updateInterval, trackDelta, this::broadcast, this.seenBy);
            this.entity = entity;
            this.range = range;
            this.lastSectionPos = SectionPos.of(entity);
        }

        public boolean equals(Object other) {
            return other instanceof TrackedEntity && ((TrackedEntity)other).entity.getId() == this.entity.getId();
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> packet) {
            for (ServerPlayerConnection serverPlayerConnection : this.seenBy) {
                serverPlayerConnection.send(packet);
            }
        }

        public void broadcastAndSend(Packet<?> packet) {
            this.broadcast(packet);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send(packet);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection serverPlayerConnection : this.seenBy) {
                this.serverEntity.removePairing(serverPlayerConnection.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.seenBy.remove(player.connection)) {
                this.serverEntity.removePairing(player);
            }
        }

        public void updatePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.entity) {
                double rangeY;
                boolean flag;
                double vec3_dx = player.getX() - this.entity.getX();
                double vec3_dz = player.getZ() - this.entity.getZ();
                int playerViewDistance = ChunkMap.this.getPlayerViewDistance(player);
                double d1 = vec3_dx * vec3_dx + vec3_dz * vec3_dz;
                double d = Math.min(this.getEffectiveRange(), playerViewDistance * 16);
                double d2 = d * d;
                boolean bl = flag = d1 <= d2;
                if (flag && ChunkMap.this.level.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)ChunkMap.this.level.paperConfig().entities.trackingRangeY.get(this.entity, -1)) != -1.0) {
                    double vec3_dy = player.getY() - this.entity.getY();
                    flag = vec3_dy * vec3_dy <= rangeY * rangeY;
                }
                boolean bl2 = flag = flag && this.entity.broadcastToPlayer(player) && ChunkMap.this.isChunkTracked(player, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
                if (flag && !player.getBukkitEntity().canSee(this.entity.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.seenBy.add(player.connection)) {
                        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.entity.getBukkitEntity()).callEvent()) {
                            this.serverEntity.addPairing(player);
                        }
                        this.serverEntity.onPlayerAdd();
                    }
                } else if (this.seenBy.remove(player.connection)) {
                    this.serverEntity.removePairing(player);
                }
            }
        }

        private int scaledRange(int trackingDistance) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance(trackingDistance);
        }

        private int getEffectiveRange() {
            net.minecraft.world.entity.Entity entity = this.entity;
            int range = this.range;
            if (entity.getPassengers() == ImmutableList.of()) {
                return this.scaledRange(range);
            }
            List passengers = (List)entity.getIndirectPassengers();
            int len = passengers.size();
            for (int i = 0; i < len; ++i) {
                net.minecraft.world.entity.Entity passenger = (net.minecraft.world.entity.Entity)passengers.get(i);
                range = Math.max(range, PlatformHooks.get().modifyEntityTrackingRange(passenger, passenger.getType().clientTrackingRange() << 4));
            }
            return this.scaledRange(range);
        }

        public void updatePlayers(List<ServerPlayer> playersList) {
            for (ServerPlayer serverPlayer : playersList) {
                this.updatePlayer(serverPlayer);
            }
        }
    }
}

