/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public abstract class DistanceManager
implements ChunkSystemDistanceManager,
ChunkTickDistanceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    private long ticketTickCounter;
    private final PositionCountingAreaMap<ServerPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    protected DistanceManager(Executor dispatcher, Executor mainThreadExecutor) {
        TaskScheduler<Runnable> taskScheduler = TaskScheduler.wrapExecutor("player ticket throttler", mainThreadExecutor);
    }

    @Override
    public final ChunkHolderManager moonrise$getChunkHolderManager() {
        return this.moonrise$getChunkMap().level.moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Override
    public final void moonrise$addPlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.add(player, pos.x(), pos.z(), 8);
    }

    @Override
    public final void moonrise$removePlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(ServerPlayer player, SectionPos oldPos, SectionPos newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.x(), newPos.z(), 8);
        }
    }

    protected void purgeStaleTickets() {
        this.moonrise$getChunkHolderManager().tick();
    }

    private static int getTicketLevelAt(SortedArraySet<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.first().getTicketLevel() : ChunkLevel.MAX_LEVEL + 1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap chunkMap) {
        return this.moonrise$getChunkHolderManager().processTicketUpdates();
    }

    void addTicket(long chunkPos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().addTicketAtLevel(ticket.getType(), chunkPos, ticket.getTicketLevel(), ticket.key);
    }

    void removeTicket(long chunkPos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(ticket.getType(), chunkPos, ticket.getTicketLevel(), ticket.key);
    }

    public <T> void addTicket(TicketType<T> type, ChunkPos pos, int level, T value) {
        this.addTicket(pos.toLong(), new Ticket<T>(type, level, value));
    }

    public <T> void removeTicket(TicketType<T> type, ChunkPos pos, int level, T value) {
        Ticket<T> ticket = new Ticket<T>(type, level, value);
        this.removeTicket(pos.toLong(), ticket);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.moonrise$getChunkHolderManager().addTicketAtLevel(type, pos, ChunkLevel.byStatus(FullChunkStatus.FULL) - distance, value);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int distance, T value) {
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(type, pos, ChunkLevel.byStatus(FullChunkStatus.FULL) - distance, value);
    }

    public boolean addPluginRegionTicket(ChunkPos pos, Plugin value) {
        return this.moonrise$getChunkHolderManager().addTicketAtLevel(TicketType.PLUGIN_TICKET, pos, ChunkLevel.byStatus(FullChunkStatus.FULL) - 2, value);
    }

    public boolean removePluginRegionTicket(ChunkPos pos, Plugin value) {
        return this.moonrise$getChunkHolderManager().removeTicketAtLevel(TicketType.PLUGIN_TICKET, pos, ChunkLevel.byStatus(FullChunkStatus.FULL) - 2, value);
    }

    private SortedArraySet<Ticket<?>> getTickets(long chunkPos) {
        throw new UnsupportedOperationException();
    }

    protected void updateChunkForced(ChunkPos pos, boolean add) {
        if (add) {
            this.moonrise$getChunkHolderManager().addTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        } else {
            this.moonrise$getChunkHolderManager().removeTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        }
    }

    public void addPlayer(SectionPos sectionPos, ServerPlayer player) {
        ChunkPos chunkPos = sectionPos.chunk();
        long packedChunkPos = chunkPos.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(packedChunkPos, l -> new ObjectOpenHashSet())).add((Object)player);
    }

    public void removePlayer(SectionPos sectionPos, ServerPlayer player) {
        ChunkPos chunkPos = sectionPos.chunk();
        long packedChunkPos = chunkPos.toLong();
        ObjectSet set = (ObjectSet)this.playersPerChunk.get(packedChunkPos);
        if (set != null) {
            set.remove((Object)player);
        }
        if (set == null || set.isEmpty()) {
            this.playersPerChunk.remove(packedChunkPos);
        }
    }

    private int getPlayerTicketLevel() {
        throw new UnsupportedOperationException();
    }

    public boolean inEntityTickingRange(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean inBlockTickingRange(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    protected String getTicketDebugString(long chunkPos) {
        return this.moonrise$getChunkHolderManager().getTicketDebugString(chunkPos);
    }

    protected void updatePlayerTickets(int viewDistance) {
        this.moonrise$getChunkMap().setServerViewDistance(viewDistance);
    }

    public void updateSimulationDistance(int simulationDistance) {
        int clamped = Mth.clamp(simulationDistance, 0, MoonriseConstants.MAX_VIEW_DISTANCE);
        this.moonrise$getChunkMap().level.moonrise$getPlayerChunkLoader().setTickDistance(clamped);
    }

    public int getNaturalSpawnChunkCount() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    public boolean hasPlayersNearby(long chunkPos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos));
    }

    public LongIterator getSpawnCandidateChunks() {
        return this.spawnChunkTracker.getPositions().iterator();
    }

    public String getDebugStatus() {
        return "No DistanceManager stats available";
    }

    private void dumpTickets(String filename) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    TickingTracker tickingTracker() {
        throw new UnsupportedOperationException();
    }

    public LongSet getTickingChunks() {
        throw new UnsupportedOperationException();
    }

    public void removeTicketsOnClosing() {
    }

    public boolean hasTickets() {
        throw new UnsupportedOperationException();
    }

    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        this.moonrise$getChunkHolderManager().removeAllTicketsFor(ticketType, ticketLevel, ticketIdentifier);
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int maxDistance) {
            super(maxDistance + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = maxDistance;
            this.chunks.defaultReturnValue((byte)(maxDistance + 2));
        }

        @Override
        protected int getLevel(long sectionPos) {
            return this.chunks.get(sectionPos);
        }

        @Override
        protected void setLevel(long sectionPos, int level) {
            byte b = level > this.maxDistance ? this.chunks.remove(sectionPos) : this.chunks.put(sectionPos, (byte)level);
            this.onLevelChange(sectionPos, b, level);
        }

        protected void onLevelChange(long chunkPos, int oldLevel, int newLevel) {
        }

        @Override
        protected int getLevelFromSource(long pos) {
            return this.havePlayer(pos) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long chunkPos) {
            ObjectSet set = (ObjectSet)DistanceManager.this.playersPerChunk.get(chunkPos);
            return set != null && !set.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }

        private void dumpChunks(String filename) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(filename));){
                for (Long2ByteMap.Entry entry : this.chunks.long2ByteEntrySet()) {
                    ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
                    String string = Byte.toString(entry.getByteValue());
                    fileOutputStream.write((chunkPos.x + "\t" + chunkPos.z + "\t" + string + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException var9) {
                LOGGER.error("Failed to dump chunks to {}", (Object)filename, (Object)var9);
            }
        }
    }
}

