/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ServerItemCooldowns;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EndGatewayBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.CraftWorldBorder;
import org.bukkit.craftbukkit.block.CraftEndGateway;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.event.CraftPortalEvent;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

public class ServerPlayer
extends Player
implements ChunkSystemServerPlayer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public static final double BLOCK_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 1.0;
    public static final double ENTITY_INTERACTION_DISTANCE_VERIFICATION_BUFFER = 3.0;
    public static final int ENDER_PEARL_TICKET_RADIUS = 2;
    public static final String ENDER_PEARLS_TAG = "ender_pearls";
    public static final String ENDER_PEARL_DIMENSION_TAG = "ender_pearl_dimension";
    private static final AttributeModifier CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_block_range"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public ServerGamePacketListenerImpl connection;
    public final MinecraftServer server;
    public final ServerPlayerGameMode gameMode;
    private final PlayerAdvancements advancements;
    private final ServerStatsCounter stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    public int lastSentExp = -99999999;
    private ChatVisiblity chatVisibility = ChatVisiblity.FULL;
    public ParticleStatus particleStatus = ParticleStatus.ALL;
    private boolean canChatColor = true;
    private long lastActionTime = Util.getMillis();
    @Nullable
    private net.minecraft.world.entity.Entity camera;
    public boolean isChangingDimension;
    public boolean seenCredits;
    private final ServerRecipeBook recipeBook;
    @Nullable
    private Vec3 levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    public String language = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3 startingToFallPosition;
    @Nullable
    private Vec3 enteredNetherPosition;
    @Nullable
    private Vec3 enteredLavaOnVehiclePosition;
    private SectionPos lastSectionPos = SectionPos.of(0, 0, 0);
    private ChunkTrackingView chunkTrackingView = ChunkTrackingView.EMPTY;
    private ResourceKey<Level> respawnDimension = Level.OVERWORLD;
    @Nullable
    private BlockPos respawnPosition;
    private boolean respawnForced;
    private float respawnAngle;
    private final TextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private boolean spawnExtraParticlesOnFall;
    public WardenSpawnTracker wardenSpawnTracker = new WardenSpawnTracker(0, 0, 0);
    @Nullable
    private BlockPos raidOmenPosition;
    private Vec3 lastKnownClientMovement = Vec3.ZERO;
    private Input lastClientInput = Input.EMPTY;
    private final Set<ThrownEnderpearl> enderPearls = new HashSet<ThrownEnderpearl>();
    public final ContainerSynchronizer containerSynchronizer = new ContainerSynchronizer(){

        @Override
        public void sendInitialData(AbstractContainerMenu container, NonNullList<ItemStack> items, ItemStack carriedItem, int[] initialData) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetContentPacket(container.containerId, container.incrementStateId(), items, carriedItem));
            for (int i = 0; i < initialData.length; ++i) {
                this.broadcastDataValue(container, i, initialData[i]);
            }
        }

        @Override
        public void sendOffHandSlotChange() {
            ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(ServerPlayer.this.inventoryMenu.containerId, ServerPlayer.this.inventoryMenu.incrementStateId(), 45, ServerPlayer.this.inventoryMenu.getSlot(45).getItem().copy()));
        }

        @Override
        public ServerPlayer player() {
            return ServerPlayer.this;
        }

        @Override
        public void sendSlotChange(AbstractContainerMenu container, int slot, ItemStack itemStack) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetSlotPacket(container.containerId, container.incrementStateId(), slot, itemStack));
        }

        @Override
        public void sendCarriedChange(AbstractContainerMenu containerMenu, ItemStack stack) {
            ServerPlayer.this.connection.send(new ClientboundSetCursorItemPacket(stack.copy()));
        }

        @Override
        public void sendDataChange(AbstractContainerMenu container, int id, int value) {
            this.broadcastDataValue(container, id, value);
        }

        private void broadcastDataValue(AbstractContainerMenu container, int id, int value) {
            ServerPlayer.this.connection.send(new ClientboundContainerSetDataPacket(container.containerId, id, value));
        }
    };
    private final ContainerListener containerListener = new ContainerListener(){

        @Override
        public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
            Slot slot = containerToSend.getSlot(dataSlotIndex);
            if (!(slot instanceof ResultSlot) && slot.container == ServerPlayer.this.getInventory()) {
                CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
            }
        }

        @Override
        public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack oldStack, ItemStack stack) {
            Slot slot = containerToSend.getSlot(dataSlotIndex);
            if (!(slot instanceof ResultSlot) && slot.container == ServerPlayer.this.getInventory()) {
                if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                    CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
                    return;
                }
                PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((org.bukkit.entity.Player)ServerPlayer.this.getBukkitEntity(), dataSlotIndex, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                event.callEvent();
                if (event.shouldTriggerAdvancements()) {
                    CriteriaTriggers.INVENTORY_CHANGED.trigger(ServerPlayer.this, ServerPlayer.this.getInventory(), stack);
                }
            }
        }

        @Override
        public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        }
    };
    @Nullable
    private RemoteChatSession chatSession;
    @Nullable
    public final Object object;
    private final CommandSource commandSource = new CommandSource(){

        @Override
        public boolean acceptsSuccess() {
            return ServerPlayer.this.serverLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        }

        @Override
        public boolean acceptsFailure() {
            return true;
        }

        @Override
        public boolean shouldInformAdmins() {
            return true;
        }

        @Override
        public void sendSystemMessage(net.minecraft.network.chat.Component component) {
            ServerPlayer.this.sendSystemMessage(component);
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return ServerPlayer.this.getBukkitEntity();
        }
    };
    private int containerCounter;
    public boolean wonGame;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public ClientboundSetHealthPacket queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = MobCategory.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    public net.minecraft.network.chat.Component listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public ServerPlayer(MinecraftServer server, ServerLevel level, GameProfile gameProfile, ClientInformation clientInformation) {
        super(level, level.getSharedSpawnPos(), level.getSharedSpawnAngle(), gameProfile);
        this.textFilter = server.createTextFilterForPlayer(this);
        this.gameMode = server.createGameModeForPlayer(this);
        this.recipeBook = new ServerRecipeBook((recipe, output) -> server.getRecipeManager().listDisplaysForRecipe(recipe, output));
        this.server = server;
        this.stats = server.getPlayerList().getPlayerStats(this);
        this.advancements = server.getPlayerList().getPlayerAdvancements(this);
        this.updateOptionsNoEvents(clientInformation);
        this.object = null;
        this.displayName = this.getScoreboardName();
        this.adventure$displayName = Component.text((String)this.getScoreboardName());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.getMaxHealth();
    }

    @Override
    public BlockPos adjustSpawnLocation(ServerLevel level, BlockPos pos) {
        AABB aabb = this.getDimensions(Pose.STANDING).makeBoundingBox(Vec3.ZERO);
        BlockPos blockPos = pos;
        if (level.dimensionType().hasSkyLight() && level.serverLevelData.getGameType() != GameType.ADVENTURE) {
            long l;
            long l1;
            int max = Math.max(0, this.server.getSpawnRadius(level));
            int floor = Mth.floor(level.getWorldBorder().getDistanceToBorder(pos.getX(), pos.getZ()));
            if (floor < max) {
                max = floor;
            }
            if (floor <= 1) {
                max = 1;
            }
            int i = (l1 = (l = (long)(max * 2 + 1)) * l) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l1;
            int coprime = this.getCoprime(i);
            int randomInt = RandomSource.create().nextInt(i);
            for (int i1 = 0; i1 < i; ++i1) {
                int i2 = (randomInt + coprime * i1) % i;
                int i3 = i2 % (max * 2 + 1);
                int i4 = i2 / (max * 2 + 1);
                int i5 = pos.getX() + i3 - max;
                int i6 = pos.getZ() + i4 - max;
                try {
                    blockPos = PlayerRespawnLogic.getOverworldRespawnPos(level, i5, i6);
                    if (blockPos == null || !this.noCollisionNoLiquid(level, aabb.move(blockPos.getBottomCenter()))) continue;
                    return blockPos;
                }
                catch (Exception var25) {
                    int i7 = i1;
                    int i8 = max;
                    CrashReport crashReport = CrashReport.forThrowable(var25, "Searching for spawn");
                    CrashReportCategory crashReportCategory = crashReport.addCategory("Spawn Lookup");
                    crashReportCategory.setDetail("Origin", pos::toString);
                    crashReportCategory.setDetail("Radius", () -> Integer.toString(i8));
                    crashReportCategory.setDetail("Candidate", () -> "[" + i5 + "," + i6 + "]");
                    crashReportCategory.setDetail("Progress", () -> i7 + " out of " + i);
                    throw new ReportedException(crashReport);
                }
            }
            blockPos = pos;
        }
        while (!this.noCollisionNoLiquid(level, aabb.move(blockPos.getBottomCenter())) && blockPos.getY() < level.getMaxY()) {
            blockPos = blockPos.above();
        }
        while (this.noCollisionNoLiquid(level, aabb.move(blockPos.below().getBottomCenter())) && blockPos.getY() > level.getMinY() + 1) {
            blockPos = blockPos.below();
        }
        return blockPos;
    }

    private boolean noCollisionNoLiquid(ServerLevel level, AABB collisionBox) {
        return level.noCollision(this, collisionBox, true);
    }

    private int getCoprime(int spawnArea) {
        return spawnArea <= 16 ? spawnArea - 1 : 17;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.readAdditionalSaveData(compound);
        if (compound.contains("warden_spawn_tracker", 10)) {
            WardenSpawnTracker.CODEC.parse(new Dynamic<Tag>(NbtOps.INSTANCE, compound.get("warden_spawn_tracker"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(wardenSpawnTracker -> {
                this.wardenSpawnTracker = wardenSpawnTracker;
            });
        }
        if (compound.contains("enteredNetherPosition", 10)) {
            CompoundTag compound1 = compound.getCompound("enteredNetherPosition");
            this.enteredNetherPosition = new Vec3(compound1.getDouble("x"), compound1.getDouble("y"), compound1.getDouble("z"));
        }
        this.seenCredits = compound.getBoolean("seenCredits");
        if (compound.contains("recipeBook", 10)) {
            this.recipeBook.fromNbt(compound.getCompound("recipeBook"), key -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)key).isPresent());
        }
        this.getBukkitEntity().readExtraData(compound);
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = compound.getString("SpawnWorld")))) != null) {
            this.respawnDimension = oldWorld.getHandle().dimension();
        }
        if (compound.contains("SpawnX", 99) && compound.contains("SpawnY", 99) && compound.contains("SpawnZ", 99)) {
            this.respawnPosition = new BlockPos(compound.getInt("SpawnX"), compound.getInt("SpawnY"), compound.getInt("SpawnZ"));
            this.respawnForced = compound.getBoolean("SpawnForced");
            this.respawnAngle = compound.getFloat("SpawnAngle");
            if (compound.contains("SpawnDimension")) {
                this.respawnDimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("SpawnDimension")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(Level.OVERWORLD);
            }
        }
        this.spawnExtraParticlesOnFall = compound.getBoolean("spawn_extra_particles_on_fall");
        Tag tag = compound.get("raid_omen_position");
        if (tag != null) {
            BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(pos -> {
                this.raidOmenPosition = pos;
            });
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        WardenSpawnTracker.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.wardenSpawnTracker).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(wardenSpawnTracker -> compound.put("warden_spawn_tracker", (Tag)wardenSpawnTracker));
        this.storeGameTypes(compound);
        compound.putBoolean("seenCredits", this.seenCredits);
        if (this.enteredNetherPosition != null) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putDouble("x", this.enteredNetherPosition.x);
            compoundTag.putDouble("y", this.enteredNetherPosition.y);
            compoundTag.putDouble("z", this.enteredNetherPosition.z);
            compound.put("enteredNetherPosition", compoundTag);
        }
        this.saveParentVehicle(compound);
        compound.put("recipeBook", this.recipeBook.toNbt());
        compound.putString("Dimension", this.level().dimension().location().toString());
        if (this.respawnPosition != null) {
            compound.putInt("SpawnX", this.respawnPosition.getX());
            compound.putInt("SpawnY", this.respawnPosition.getY());
            compound.putInt("SpawnZ", this.respawnPosition.getZ());
            compound.putBoolean("SpawnForced", this.respawnForced);
            compound.putFloat("SpawnAngle", this.respawnAngle);
            ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.respawnDimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(spawnDimension -> compound.put("SpawnDimension", (Tag)spawnDimension));
        }
        this.getBukkitEntity().setExtraData(compound);
        compound.putBoolean("spawn_extra_particles_on_fall", this.spawnExtraParticlesOnFall);
        if (this.raidOmenPosition != null) {
            BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.raidOmenPosition).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(raidOmenPosition -> compound.put("raid_omen_position", (Tag)raidOmenPosition));
        }
        this.saveEnderPearls(compound);
    }

    private void saveParentVehicle(CompoundTag tag) {
        net.minecraft.world.entity.Entity rootVehicle = this.getRootVehicle();
        net.minecraft.world.entity.Entity vehicle = this.getVehicle();
        boolean persistVehicle = true;
        if (vehicle != null) {
            for (net.minecraft.world.entity.Entity topVehicle = vehicle; topVehicle != null; topVehicle = topVehicle.getVehicle()) {
                if (topVehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && vehicle != null && rootVehicle != this && rootVehicle.hasExactlyOnePlayerPassenger() && !rootVehicle.isRemoved()) {
            CompoundTag compoundTag = new CompoundTag();
            CompoundTag compoundTag1 = new CompoundTag();
            rootVehicle.save(compoundTag1);
            compoundTag.putUUID("Attach", vehicle.getUUID());
            compoundTag.put("Entity", compoundTag1);
            tag.put("RootVehicle", compoundTag);
        }
    }

    public void loadAndSpawnParentVehicle(Optional<CompoundTag> tag) {
        Level level;
        if (tag.isPresent() && tag.get().contains("RootVehicle", 10) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag compound = tag.get().getCompound("RootVehicle");
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(compound.getCompound("Entity"), serverLevel, EntitySpawnReason.LOAD, entity2 -> !serverLevel.addWithUUID((net.minecraft.world.entity.Entity)entity2, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity2);
            if (entity == null) {
                return;
            }
            UUID uuid = compound.hasUUID("Attach") ? compound.getUUID("Attach") : null;
            if (entity.getUUID().equals(uuid)) {
                this.startRiding(entity, true);
            } else {
                for (net.minecraft.world.entity.Entity entity1 : entity.getIndirectPassengers()) {
                    if (!entity1.getUUID().equals(uuid)) continue;
                    this.startRiding(entity1, true);
                    break;
                }
            }
            if (!this.isPassenger()) {
                LOGGER.warn("Couldn't reattach entity to player");
                entity.discard(null);
                for (net.minecraft.world.entity.Entity entity1x : entity.getIndirectPassengers()) {
                    entity1x.discard(null);
                }
            }
        }
    }

    private void saveEnderPearls(CompoundTag tag) {
        if (!this.enderPearls.isEmpty()) {
            ListTag listTag = new ListTag();
            for (ThrownEnderpearl thrownEnderpearl : this.enderPearls) {
                if (thrownEnderpearl.level().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (thrownEnderpearl.isRemoved()) {
                    LOGGER.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                CompoundTag compoundTag = new CompoundTag();
                thrownEnderpearl.save(compoundTag);
                ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)thrownEnderpearl.level().dimension().location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(enderPearlDimension -> compoundTag.put(ENDER_PEARL_DIMENSION_TAG, (Tag)enderPearlDimension));
                listTag.add(compoundTag);
            }
            tag.put(ENDER_PEARLS_TAG, listTag);
        }
    }

    public void loadAndSpawnEnderpearls(Optional<CompoundTag> tag) {
        Tag tag2;
        if (tag.isPresent() && tag.get().contains(ENDER_PEARLS_TAG, 9) && (tag2 = tag.get().get(ENDER_PEARLS_TAG)) instanceof ListTag) {
            ListTag listTag = (ListTag)tag2;
            listTag.forEach(enderPearlTag -> {
                CompoundTag compoundTag;
                if (enderPearlTag instanceof CompoundTag && (compoundTag = (CompoundTag)enderPearlTag).contains(ENDER_PEARL_DIMENSION_TAG)) {
                    Optional optional = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(ENDER_PEARL_DIMENSION_TAG)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0));
                    if (optional.isEmpty()) {
                        LOGGER.warn("No dimension defined for ender pearl, skipping");
                        return;
                    }
                    ServerLevel level = this.level().getServer().getLevel((ResourceKey)optional.get());
                    if (level != null) {
                        net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(compoundTag, level, EntitySpawnReason.LOAD, entity1 -> !level.addWithUUID((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                        if (entity != null) {
                            ServerPlayer.placeEnderPearlTicket(level, entity.chunkPosition());
                        } else {
                            LOGGER.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                        }
                    } else {
                        LOGGER.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
                    }
                }
            });
        }
    }

    public void spawnIn(ServerLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("level can't be null");
        }
        this.setLevel(level);
        this.gameMode.setLevel(level);
    }

    public void setExperiencePoints(int experiencePoints) {
        float f = this.getXpNeededForNextLevel();
        float f1 = (f - 1.0f) / f;
        this.experienceProgress = Mth.clamp((float)experiencePoints / f, 0.0f, f1);
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int level) {
        this.experienceLevel = level;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int levels) {
        super.giveExperienceLevels(levels);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack enchantedItem, int cost) {
        super.onEnchantmentPerformed(enchantedItem, cost);
        this.lastSentExp = -1;
    }

    public void initMenu(AbstractContainerMenu menu) {
        menu.addSlotListener(this.containerListener);
        menu.setSynchronizer(this.containerSynchronizer);
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(ClientboundPlayerCombatEnterPacket.INSTANCE);
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    public void onInsideBlock(BlockState state) {
        CriteriaTriggers.ENTER_BLOCK.trigger(this, state);
    }

    @Override
    protected ItemCooldowns createItemCooldowns() {
        return new ServerItemCooldowns(this);
    }

    @Override
    public void tick() {
        net.minecraft.world.entity.Entity camera;
        if (this.joining) {
            this.joining = false;
        }
        this.tickClientLoadTimeout();
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.containerMenu.broadcastChanges();
            this.containerUpdateDelay = this.level().paperConfig().tickRates.containerUpdate;
        }
        if (this.containerMenu != this.inventoryMenu && (this.isImmobile() || !this.containerMenu.stillValid(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.containerMenu = this.inventoryMenu;
        }
        if ((camera = this.getCamera()) != this) {
            if (camera.isAlive()) {
                this.absMoveTo(camera.getX(), camera.getY(), camera.getZ(), camera.getYRot(), camera.getXRot());
                this.serverLevel().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriteriaTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriteriaTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.updatePlayerAttributes();
        this.advancements.flushDirty(this);
    }

    private void updatePlayerAttributes() {
        AttributeInstance attribute1;
        AttributeInstance attribute = this.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (attribute != null) {
            if (this.isCreative()) {
                attribute.addOrUpdateTransientModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            } else {
                attribute.removeModifier(CREATIVE_BLOCK_INTERACTION_RANGE_MODIFIER);
            }
        }
        if ((attribute1 = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)) != null) {
            if (this.isCreative()) {
                attribute1.addOrUpdateTransientModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            } else {
                attribute1.removeModifier(CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER);
            }
        }
    }

    public void doTick() {
        try {
            if (this.valid && !this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
            }
            for (int i = 0; i < this.getInventory().getContainerSize(); ++i) {
                ItemStack item = this.getInventory().getItem(i);
                if (item.isEmpty()) continue;
                this.synchronizeSpecialItemUpdates(item);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new ClientboundSetHealthPacket(this.getBukkitEntity().getScaledHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(ObjectiveCriteria.HEALTH, Mth.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(ObjectiveCriteria.FOOD, Mth.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(ObjectiveCriteria.AIR, Mth.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(ObjectiveCriteria.ARMOR, Mth.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(ObjectiveCriteria.EXPERIENCE, Mth.ceil(this.lastRecordedExperience));
            }
            if (this.maxHealthCache != (double)this.getMaxHealth()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(ObjectiveCriteria.LEVEL, Mth.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new ClientboundSetExperiencePacket(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriteriaTriggers.LOCATION.trigger(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.experienceLevel;
            }
            if (this.oldLevel != this.experienceLevel) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.experienceLevel);
                this.oldLevel = this.experienceLevel;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().tick();
            }
        }
        catch (Throwable var4) {
            CrashReport crashReport = CrashReport.forThrowable(var4, "Ticking player");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Player being ticked");
            this.fillCrashReportCategory(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    private void synchronizeSpecialItemUpdates(ItemStack stack) {
        Packet<?> updatePacket;
        MapId mapId = stack.get(DataComponents.MAP_ID);
        MapItemSavedData savedData = MapItem.getSavedData(mapId, this.level());
        if (savedData != null && (updatePacket = savedData.getUpdatePacket(mapId, this)) != null) {
            this.connection.send(updatePacket);
        }
    }

    @Override
    protected void tickRegeneration() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.serverLevel().getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) {
            if (this.tickCount % 20 == 0) {
                float saturationLevel;
                if (this.getHealth() < this.getMaxHealth()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((saturationLevel = this.foodData.getSaturationLevel()) < 20.0f) {
                    this.foodData.setSaturation(saturationLevel + 1.0f);
                }
            }
            if (this.tickCount % 10 == 0 && this.foodData.needsFood()) {
                this.foodData.setFoodLevel(this.foodData.getFoodLevel() + 1);
            }
        }
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriteriaTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0f && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
            if (this.currentImpulseImpactPos != null && this.currentImpulseImpactPos.y <= this.startingToFallPosition.y) {
                CriteriaTriggers.FALL_AFTER_EXPLOSION.trigger(this, this.currentImpulseImpactPos, this.currentExplosionCause);
            }
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriteriaTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(ObjectiveCriteria criteria, int points) {
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(criteria, this, scoreAccess -> scoreAccess.set(points));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack item = inv.get(i);
            if (EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || itemsToKeep.isEmpty() || item.isEmpty()) {
                inv.set(i, ItemStack.EMPTY);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i, ItemStack.EMPTY);
        }
    }

    @Override
    public void die(DamageSource cause) {
        TextComponent apiDeathMessage;
        boolean keepInventory;
        boolean _boolean;
        boolean showDeathMessage = _boolean = this.serverLevel().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
        if (this.isRemoved()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.getInventory().getContainerSize());
        boolean bl = keepInventory = this.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || this.isSpectator();
        if (!keepInventory) {
            for (ItemStack item : this.getInventory().getContents()) {
                if (item.isEmpty() || EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.shouldDropLoot() && this.serverLevel().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(this.serverLevel(), cause, this.lastHurtByPlayerTime > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        net.minecraft.network.chat.Component defaultMessage = this.getCombatTracker().getDeathMessage();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, cause, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.getHealth() <= 0.0f) {
                this.setHealth((float)event.getReviveHealth());
            }
            return;
        }
        this.gameEvent(GameEvent.ENTITY_DIE);
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = apiDeathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (apiDeathMessage != null && apiDeathMessage != Component.empty() && showDeathMessage) {
            net.minecraft.network.chat.Component deathMessage = PaperAdventure.asVanilla((Component)apiDeathMessage);
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), deathMessage), PacketSendListener.exceptionallySend(() -> {
                int i = 256;
                String string = deathMessage.getString(256);
                MutableComponent component = net.minecraft.network.chat.Component.translatable("death.attack.message_too_long", net.minecraft.network.chat.Component.literal(string).withStyle(ChatFormatting.YELLOW));
                MutableComponent component1 = net.minecraft.network.chat.Component.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, component)));
                return new ClientboundPlayerCombatKillPacket(this.getId(), component1);
            }));
            PlayerTeam playerTeam = this.getTeam();
            if (playerTeam == null || ((Team)playerTeam).getDeathMessageVisibility() == Team.Visibility.ALWAYS) {
                this.server.getPlayerList().broadcastSystemMessage(deathMessage, false);
            } else if (((Team)playerTeam).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                this.server.getPlayerList().broadcastSystemToTeam(this, deathMessage);
            } else if (((Team)playerTeam).getDeathMessageVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, deathMessage);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.serverLevel().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        if (event.shouldDropExperience()) {
            this.dropExperience(this.serverLevel(), cause.getEntity());
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.getInventory().compartments) {
                ServerPlayer.processKeep(event, nonNullList);
            }
            ServerPlayer.processKeep(event, null);
        }
        this.setCamera(this);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        LivingEntity killCredit = this.getKillCredit();
        if (killCredit != null) {
            this.awardStat(Stats.ENTITY_KILLED_BY.get(killCredit.getType()));
            killCredit.awardKillScore(this, cause);
            this.createWitherRose(killCredit);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
        this.setClientLoaded(false);
    }

    private void tellNeutralMobsThatIDied() {
        AABB aabb = new AABB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(Mob.class, aabb, EntitySelector.NO_SPECTATORS).stream().filter(mob -> mob instanceof NeutralMob).forEach(mob -> ((NeutralMob)((Object)mob)).playerDied(this.serverLevel(), this));
    }

    @Override
    public void awardKillScore(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        if (entity != this) {
            super.awardKillScore(entity, damageSource);
            this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
            if (entity instanceof Player) {
                this.awardStat(Stats.PLAYER_KILLS);
                this.level().getCraftServer().getScoreboardManager().forAllObjectives(ObjectiveCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
            } else {
                this.awardStat(Stats.MOB_KILLS);
            }
            this.handleTeamKill(this, entity, ObjectiveCriteria.TEAM_KILL);
            this.handleTeamKill(entity, this, ObjectiveCriteria.KILLED_BY_TEAM);
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger(this, entity, damageSource);
        }
    }

    private void handleTeamKill(ScoreHolder scoreHolder, ScoreHolder teamMember, ObjectiveCriteria[] crtieria) {
        int id;
        PlayerTeam playersTeam = this.getScoreboard().getPlayersTeam(teamMember.getScoreboardName());
        if (playersTeam != null && (id = playersTeam.getColor().getId()) >= 0 && id < crtieria.length) {
            this.level().getCraftServer().getScoreboardManager().forAllObjectives(crtieria[id], scoreHolder, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        Player player1;
        AbstractArrow abstractArrow;
        net.minecraft.world.entity.Entity entity;
        Player player;
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity2 = damageSource.getEntity();
        if (entity2 instanceof Player && !this.canHarmPlayer(player = (Player)entity2) || entity2 instanceof AbstractArrow && (entity = (abstractArrow = (AbstractArrow)entity2).getOwner()) instanceof Player && !this.canHarmPlayer(player1 = (Player)entity)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.hurtServer(level, damageSource, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.connection.send(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean canHarmPlayer(Player other) {
        return this.isPvpAllowed() && super.canHarmPlayer(other);
    }

    private boolean isPvpAllowed() {
        return this.level().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean useCharge, TeleportTransition.PostTeleportTransition postTeleportTransition, PlayerRespawnEvent.RespawnReason respawnReason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPos respawnPosition = this.getRespawnPosition();
        float respawnAngle = this.getRespawnAngle();
        boolean isRespawnForced = this.isRespawnForced();
        ServerLevel level = this.server.getLevel(this.getRespawnDimension());
        if (level != null && respawnPosition != null) {
            Optional<RespawnPosAngle> optional = ServerPlayer.findRespawnAndUseSpawnBlock(level, respawnPosition, respawnAngle, isRespawnForced, useCharge);
            if (optional.isPresent()) {
                RespawnPosAngle respawnPosAngle = optional.get();
                isBedSpawn = respawnPosAngle.isBedSpawn();
                isAnchorSpawn = respawnPosAngle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(level, respawnPosAngle.position(), Vec3.ZERO, respawnPosAngle.yaw(), 0.0f, postTeleportTransition);
            } else {
                teleportTransition = TeleportTransition.missingRespawnBlock(this.server.overworld(), this, postTeleportTransition);
            }
        } else {
            teleportTransition = new TeleportTransition(this.server.overworld(), this, postTeleportTransition);
        }
        if (respawnReason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.position(), (World)teleportTransition.newLevel().getWorld(), teleportTransition.yRot(), teleportTransition.xRot());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (respawnReason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((org.bukkit.entity.Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, respawnReason, builder);
        this.level().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.connection.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.deltaMovement(), location.getYaw(), location.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), teleportTransition.relatives(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> findRespawnAndUseSpawnBlock(ServerLevel level, BlockPos pos, float angle, boolean forced, boolean useCharge) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof RespawnAnchorBlock && (forced || blockState.getValue(RespawnAnchorBlock.CHARGE) > 0) && RespawnAnchorBlock.canSetSpawn(level)) {
            Optional<Vec3> optional = RespawnAnchorBlock.findStandUpPosition(EntityType.PLAYER, level, pos);
            if (!forced && useCharge && optional.isPresent()) {
                level.setBlock(pos, (BlockState)blockState.setValue(RespawnAnchorBlock.CHARGE, blockState.getValue(RespawnAnchorBlock.CHARGE) - 1), 3);
            }
            return optional.map(vec3 -> RespawnPosAngle.of(vec3, pos, false, true));
        }
        if (block instanceof BedBlock && BedBlock.canSetSpawn(level)) {
            return BedBlock.findStandUpPosition(EntityType.PLAYER, level, pos, blockState.getValue(HorizontalDirectionalBlock.FACING), angle).map(vec3 -> RespawnPosAngle.of(vec3, pos, true, false));
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean isPossibleToRespawnInThis = block.isPossibleToRespawnInThis(blockState);
        BlockState blockState1 = level.getBlockState(pos.above());
        boolean isPossibleToRespawnInThis1 = blockState1.getBlock().isPossibleToRespawnInThis(blockState1);
        return isPossibleToRespawnInThis && isPossibleToRespawnInThis1 ? Optional.of(new RespawnPosAngle(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5), angle, false, false)) : Optional.empty();
    }

    public void showEndCredits() {
        this.unRide();
        this.serverLevel().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        if (!this.wonGame) {
            this.wonGame = true;
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
            this.seenCredits = true;
        }
    }

    @Override
    @Nullable
    public ServerPlayer teleport(TeleportTransition teleportTransition) {
        BlockEntity blockEntity;
        if (this.isSleeping()) {
            return null;
        }
        if (this.isRemoved()) {
            return null;
        }
        if (teleportTransition.missingRespawnBlock()) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        ServerLevel level = teleportTransition.newLevel();
        ServerLevel serverLevel = this.serverLevel();
        ResourceKey<LevelStem> resourceKey = serverLevel.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.calculateAbsolute(PositionMoveRotation.of(this), PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
        Location exit = CraftLocation.toBukkit(absolutePosition.position(), (World)level.getWorld(), absolutePosition.yRot(), absolutePosition.xRot());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, teleportTransition.cause());
        if (this.portalProcess != null && this.portalProcess.isSamePortal((EndGatewayBlock)Blocks.END_GATEWAY) && (blockEntity = this.serverLevel().getBlockEntity(this.portalProcess.getEntryPosition())) instanceof TheEndGatewayBlockEntity) {
            TheEndGatewayBlockEntity theEndGatewayBlockEntity = (TheEndGatewayBlockEntity)blockEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, (EndGateway)new CraftEndGateway((World)this.serverLevel().getWorld(), theEndGatewayBlockEntity));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            level = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTransition = new TeleportTransition(level, CraftLocation.toVec3D(newExit), Vec3.ZERO, newExit.getYaw(), newExit.getPitch(), teleportTransition.missingRespawnBlock(), teleportTransition.asPassenger(), Set.of(), teleportTransition.postTeleportTransition(), teleportTransition.cause());
        }
        if (!teleportTransition.asPassenger()) {
            this.stopRiding();
        }
        if (level != null && level.dimension() == serverLevel.dimension()) {
            this.connection.internalTeleport(PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
            this.connection.resetPosition();
            teleportTransition.postTeleportTransition().onTransition(this);
            return this;
        }
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("moving");
        if (level != null && resourceKey == LevelStem.OVERWORLD && level.getTypeKey() == LevelStem.NETHER) {
            this.enteredNetherPosition = this.position();
        }
        profilerFiller.pop();
        profilerFiller.push("placing");
        this.isChangingDimension = true;
        LevelData worlddata = level.getLevelData();
        this.connection.send(new ClientboundRespawnPacket(this.createCommonSpawnInfo(level), 3));
        this.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        PlayerList playerList = this.server.getPlayerList();
        playerList.sendPlayerPermissionLevel(this);
        serverLevel.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        this.setServerLevel(level);
        this.connection.internalTeleport(PositionMoveRotation.of(teleportTransition), teleportTransition.relatives());
        this.connection.resetPosition();
        level.addDuringTeleport(this);
        profilerFiller.pop();
        this.triggerDimensionChangeTriggers(serverLevel);
        this.stopUsingItem();
        this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
        playerList.sendLevelInfo(this, level);
        playerList.sendAllPlayerInfo(this);
        playerList.sendActivePlayerEffects(this);
        teleportTransition.postTeleportTransition().onTransition(this);
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (World)serverLevel.getWorld());
        this.level().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.isBlocking()) {
            this.stopUsingItem();
        }
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((org.bukkit.entity.Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void forceSetRotation(float yRot, float xRot) {
        this.connection.send(new ClientboundPlayerRotationPacket(yRot, xRot));
    }

    public void triggerDimensionChangeTriggers(ServerLevel level) {
        ResourceKey<Level> resourceKey = level.dimension();
        ResourceKey<Level> resourceKey1 = this.level().dimension();
        ResourceKey<Level> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(level);
        ResourceKey<Level> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.level());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourceKey;
            maindimensionkey1 = resourceKey1;
        }
        CriteriaTriggers.CHANGED_DIMENSION.trigger(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourceKey || maindimensionkey1 != resourceKey1) {
            CriteriaTriggers.CHANGED_DIMENSION.trigger(this, resourceKey, resourceKey1);
        }
        if (maindimensionkey == Level.NETHER && maindimensionkey1 == Level.OVERWORLD && this.enteredNetherPosition != null) {
            CriteriaTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if (maindimensionkey1 != Level.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(ServerPlayer player) {
        return player.isSpectator() ? this.getCamera() == this : !this.isSpectator() && super.broadcastToPlayer(player);
    }

    @Override
    public void take(net.minecraft.world.entity.Entity entity, int quantity) {
        super.take(entity, quantity);
        this.containerMenu.broadcastChanges();
    }

    private Either<Player.BedSleepingProblem, Unit> getBedResult(BlockPos at, Direction direction) {
        if (this.isSleeping() || !this.isAlive()) {
            return Either.left(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
        if (!this.level().dimensionType().natural() && !this.level().dimensionType().bedWorks()) {
            return Either.left(Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
        }
        if (!this.bedInRange(at, direction)) {
            return Either.left(Player.BedSleepingProblem.TOO_FAR_AWAY);
        }
        if (this.bedBlocked(at, direction)) {
            return Either.left(Player.BedSleepingProblem.OBSTRUCTED);
        }
        this.setRespawnPosition(this.level().dimension(), at, this.getYRot(), false, true, PlayerSetSpawnEvent.Cause.BED);
        if (this.level().isDay()) {
            return Either.left(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
        if (!this.isCreative()) {
            double d = 8.0;
            double d1 = 5.0;
            Vec3 vec3 = Vec3.atBottomCenterOf(at);
            List<Monster> entitiesOfClass = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), monster -> monster.isPreventingPlayerRest(this.serverLevel(), this));
            if (!entitiesOfClass.isEmpty()) {
                return Either.left(Player.BedSleepingProblem.NOT_SAFE);
            }
        }
        return Either.right(Unit.INSTANCE);
    }

    @Override
    public Either<Player.BedSleepingProblem, Unit> startSleepInBed(BlockPos at, boolean force) {
        Direction enumdirection = this.level().getBlockState(at).getValue(HorizontalDirectionalBlock.FACING);
        Either<Player.BedSleepingProblem, Unit> bedResult = this.getBedResult(at, enumdirection);
        if (bedResult.left().orElse(null) == Player.BedSleepingProblem.OTHER_PROBLEM) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.INSTANCE);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, at, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<Player.BedSleepingProblem, Unit> either = super.startSleepInBed(at, force).ifRight(unit -> {
            this.awardStat(Stats.SLEEP_IN_BED);
            CriteriaTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.serverLevel().canSleepThroughNights()) {
            this.displayClientMessage(net.minecraft.network.chat.Component.translatable("sleep.not_possible"), true);
        }
        ((ServerLevel)this.level()).updateSleepingPlayerList();
        return either;
    }

    @Override
    public void startSleeping(BlockPos pos) {
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        super.startSleeping(pos);
    }

    private boolean bedInRange(BlockPos pos, Direction direction) {
        return this.isReachableBedBlock(pos) || this.isReachableBedBlock(pos.relative(direction.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPos pos) {
        Vec3 vec3 = Vec3.atBottomCenterOf(pos);
        return Math.abs(this.getX() - vec3.x()) <= 3.0 && Math.abs(this.getY() - vec3.y()) <= 2.0 && Math.abs(this.getZ() - vec3.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.above();
        return !this.freeAt(blockPos) || !this.freeAt(blockPos.relative(direction.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        if (!this.isSleeping()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPos bedPosition = this.getSleepingPos().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.level().getWorld().getBlockAt(bedPosition.getX(), bedPosition.getY(), bedPosition.getZ()) : this.level().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((org.bukkit.entity.Player)player, bed, true);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.isSleeping()) {
            this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(this, 2));
        }
        super.stopSleepInBed(wakeImmediately, updateLevelForSleepingPlayers);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void dismountTo(double x, double y, double z) {
        this.removeVehicle();
        this.setPos(x, y, z);
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel level, DamageSource damageSource) {
        return super.isInvulnerableTo(level, damageSource) || this.isChangingDimension() && !damageSource.is(DamageTypes.ENDER_PEARL) || !this.hasClientLoaded() || !this.level().paperConfig().collisions.allowPlayerCrammingDamage && damageSource.is(DamageTypes.CRAMMING);
    }

    @Override
    protected void onChangedBlock(ServerLevel level, BlockPos pos) {
        if (!this.isSpectator()) {
            super.onChangedBlock(level, pos);
        }
    }

    @Override
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        if (this.spawnExtraParticlesOnFall && onGround && this.fallDistance > 0.0f) {
            Vec3 vec3 = pos.getCenter().add(0.0, 0.5, 0.0);
            int i = (int)Mth.clamp(50.0f * this.fallDistance, 0.0f, 200.0f);
            this.serverLevel().sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, state), vec3.x, vec3.y, vec3.z, i, 0.3f, 0.3f, 0.3f, 0.15f);
            this.spawnExtraParticlesOnFall = false;
        }
        super.checkFallDamage(y, onGround, state, pos);
    }

    @Override
    public void onExplosionHit(@Nullable net.minecraft.world.entity.Entity entity) {
        super.onExplosionHit(entity);
        this.currentImpulseImpactPos = this.position();
        this.currentExplosionCause = entity;
        this.setIgnoreFallDamageFromCurrentImpulse(entity != null && entity.getType() == EntityType.WIND_CHARGE);
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(SignBlockEntity signEntity, boolean isFrontText) {
        this.connection.send(new ClientboundBlockUpdatePacket(this.level(), signEntity.getBlockPos()));
        this.connection.send(new ClientboundOpenSignEditorPacket(signEntity.getBlockPos(), isFrontText));
    }

    public int nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
        return this.containerCounter;
    }

    @Override
    public OptionalInt openMenu(@Nullable MenuProvider menu) {
        if (menu == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        AbstractContainerMenu abstractContainerMenu = menu.createMenu(this.containerCounter, this.getInventory(), this);
        net.minecraft.network.chat.Component title = null;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.setTitle(menu.getDisplayName());
            boolean cancelled = false;
            Pair<Component, AbstractContainerMenu> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, abstractContainerMenu, cancelled);
            abstractContainerMenu = (AbstractContainerMenu)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (abstractContainerMenu == null && !cancelled) {
                if (menu instanceof Container) {
                    ((Container)((Object)menu)).stopOpen(this);
                } else if (menu instanceof ChestBlock.DoubleInventory) {
                    ChestBlock.DoubleInventory doubleInventory = (ChestBlock.DoubleInventory)menu;
                    doubleInventory.container.stopOpen(this);
                } else if (!this.enderChestInventory.isActiveChest(null)) {
                    this.enderChestInventory.stopOpen(this);
                }
                return OptionalInt.empty();
            }
        }
        if (abstractContainerMenu == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(net.minecraft.network.chat.Component.translatable("container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return OptionalInt.empty();
        }
        this.containerMenu = abstractContainerMenu;
        if (!this.isImmobile()) {
            this.connection.send(new ClientboundOpenScreenPacket(abstractContainerMenu.containerId, abstractContainerMenu.getType(), Objects.requireNonNullElseGet(title, abstractContainerMenu::getTitle)));
        }
        this.initMenu(abstractContainerMenu);
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int containerId, MerchantOffers offers, int level, int xp, boolean flag, boolean flag1) {
        this.connection.send(new ClientboundMerchantOffersPacket(containerId, offers, level, xp, flag, flag1));
    }

    @Override
    public void openHorseInventory(AbstractHorse horse, Container inventory) {
        this.nextContainerCounter();
        AbstractContainerMenu container = new HorseInventoryMenu(this.containerCounter, this.getInventory(), inventory, horse, horse.getInventoryColumns());
        container.setTitle(horse.getDisplayName());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.stopOpen(this);
            return;
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int inventoryColumns = horse.getInventoryColumns();
        this.connection.send(new ClientboundHorseScreenOpenPacket(this.containerCounter, inventoryColumns, horse.getId()));
        this.containerMenu = container;
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack stack, InteractionHand hand) {
        if (stack.has(DataComponents.WRITTEN_BOOK_CONTENT)) {
            if (WrittenBookItem.resolveBookComponents(stack, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new ClientboundOpenBookPacket(hand));
        }
    }

    @Override
    public void openCommandBlock(CommandBlockEntity commandBlock) {
        this.connection.send(ClientboundBlockEntityDataPacket.create(commandBlock, BlockEntity::saveCustomOnly));
    }

    @Override
    public void closeContainer() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.connection.send(new ClientboundContainerClosePacket(this.containerMenu.containerId));
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    public void rideTick() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    public void checkMovementStatistics(double dx, double dy, double dz) {
        if (!this.isPassenger() && !ServerPlayer.didNotMove(dx, dy, dz)) {
            if (this.isSwimming()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.awardStat(Stats.SWIM_ONE_CM, rounded);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (this.isEyeInFluid(FluidTags.WATER)) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.awardStat(Stats.WALK_UNDER_WATER_ONE_CM, rounded);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.isInWater()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    this.awardStat(Stats.WALK_ON_WATER_ONE_CM, rounded);
                    this.causeFoodExhaustion(this.level().spigotConfig.swimMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.onClimbable()) {
                if (dy > 0.0) {
                    this.awardStat(Stats.CLIMB_ONE_CM, (int)Math.round(dy * 100.0));
                }
            } else if (this.onGround()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 0) {
                    if (this.isSprinting()) {
                        this.awardStat(Stats.SPRINT_ONE_CM, rounded);
                        this.causeFoodExhaustion(this.level().spigotConfig.sprintMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.isCrouching()) {
                        this.awardStat(Stats.CROUCH_ONE_CM, rounded);
                        this.causeFoodExhaustion(this.level().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.awardStat(Stats.WALK_ONE_CM, rounded);
                        this.causeFoodExhaustion(this.level().spigotConfig.otherMultiplier * (float)rounded * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.isFallFlying()) {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
                this.awardStat(Stats.AVIATE_ONE_CM, rounded);
            } else {
                int rounded = Math.round((float)Math.sqrt(dx * dx + dz * dz) * 100.0f);
                if (rounded > 25) {
                    this.awardStat(Stats.FLY_ONE_CM, rounded);
                }
            }
        }
    }

    private void checkRidingStatistics(double dx, double dy, double dz) {
        if (this.isPassenger() && !ServerPlayer.didNotMove(dx, dy, dz)) {
            int rounded = Math.round((float)Math.sqrt(dx * dx + dy * dy + dz * dz) * 100.0f);
            net.minecraft.world.entity.Entity vehicle = this.getVehicle();
            if (vehicle instanceof AbstractMinecart) {
                this.awardStat(Stats.MINECART_ONE_CM, rounded);
            } else if (vehicle instanceof AbstractBoat) {
                this.awardStat(Stats.BOAT_ONE_CM, rounded);
            } else if (vehicle instanceof Pig) {
                this.awardStat(Stats.PIG_ONE_CM, rounded);
            } else if (vehicle instanceof AbstractHorse) {
                this.awardStat(Stats.HORSE_ONE_CM, rounded);
            } else if (vehicle instanceof Strider) {
                this.awardStat(Stats.STRIDER_ONE_CM, rounded);
            }
        }
    }

    private static boolean didNotMove(double dx, double dy, double dz) {
        return dx == 0.0 && dy == 0.0 && dz == 0.0;
    }

    @Override
    public void awardStat(Stat<?> stat, int amount) {
        this.stats.increment(this, stat, amount);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, score -> score.add(amount));
    }

    @Override
    public void resetStat(Stat<?> stat) {
        this.stats.setValue(this, stat, 0);
        this.level().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> recipes) {
        return this.recipeBook.addRecipes(recipes, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> recipe, List<ItemStack> items) {
        CriteriaTriggers.RECIPE_CRAFTED.trigger(this, recipe.id(), items);
    }

    @Override
    public void awardRecipesByKey(List<ResourceKey<Recipe<?>>> recipes) {
        List<RecipeHolder<?>> list = recipes.stream().flatMap(resourceKey -> this.server.getRecipeManager().byKey((ResourceKey<Recipe<?>>)resourceKey).stream()).collect(Collectors.toList());
        this.awardRecipes(list);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> recipes) {
        return this.recipeBook.removeRecipes(recipes, this);
    }

    @Override
    public void jumpFromGround() {
        super.jumpFromGround();
        this.awardStat(Stats.JUMP);
        if (this.isSprinting()) {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.level().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void giveExperiencePoints(int xpPoints) {
        super.giveExperiencePoints(xpPoints);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isPassenger() && this.getVehicle() instanceof ServerPlayer) {
            this.stopRiding();
        }
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
        this.lastSentExp = -1;
    }

    @Override
    public void displayClientMessage(net.minecraft.network.chat.Component chatComponent, boolean actionBar) {
        this.sendSystemMessage(chatComponent, actionBar);
    }

    @Override
    public void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new ClientboundEntityEventPacket(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        super.lookAt(anchor, target);
        this.connection.send(new ClientboundPlayerLookAtPacket(anchor, target.x, target.y, target.z));
    }

    public void lookAt(EntityAnchorArgument.Anchor fromAnchor, net.minecraft.world.entity.Entity entity, EntityAnchorArgument.Anchor toAnchor) {
        Vec3 vec3 = toAnchor.apply(entity);
        super.lookAt(fromAnchor, vec3);
        this.connection.send(new ClientboundPlayerLookAtPacket(fromAnchor, entity, toAnchor));
    }

    public void restoreFrom(ServerPlayer that, boolean keepEverything) {
        this.wardenSpawnTracker = that.wardenSpawnTracker;
        this.chatSession = that.chatSession;
        this.gameMode.setGameModeForPlayer(that.gameMode.getGameModeForPlayer(), that.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        if (keepEverything) {
            this.getAttributes().assignBaseValues(that.getAttributes());
            this.setHealth(that.getHealth());
            this.foodData = that.foodData;
            for (MobEffectInstance mobEffectInstance : that.getActiveEffects()) {
            }
            this.getInventory().replaceWith(that.getInventory());
            this.experienceLevel = that.experienceLevel;
            this.totalExperience = that.totalExperience;
            this.experienceProgress = that.experienceProgress;
            this.setScore(that.getScore());
            this.portalProcess = that.portalProcess;
        } else {
            this.getAttributes().assignBaseValues(that.getAttributes());
            if (this.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || that.isSpectator()) {
                this.getInventory().replaceWith(that.getInventory());
                this.experienceLevel = that.experienceLevel;
                this.totalExperience = that.totalExperience;
                this.experienceProgress = that.experienceProgress;
                this.setScore(that.getScore());
            }
        }
        this.enchantmentSeed = that.enchantmentSeed;
        this.enderChestInventory = that.enderChestInventory;
        this.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, that.getEntityData().get(Player.DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.seenCredits = that.seenCredits;
        this.enteredNetherPosition = that.enteredNetherPosition;
        this.chunkTrackingView = that.chunkTrackingView;
        this.setShoulderEntityLeft(that.getShoulderEntityLeft());
        this.setShoulderEntityRight(that.getShoulderEntityRight());
        this.setLastDeathLocation(that.getLastDeathLocation());
    }

    @Override
    protected void onEffectAdded(MobEffectInstance effectInstance, @Nullable net.minecraft.world.entity.Entity entity) {
        super.onEffectAdded(effectInstance, entity);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effectInstance, true));
        if (effectInstance.is(MobEffects.LEVITATION)) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, entity);
    }

    @Override
    protected void onEffectUpdated(MobEffectInstance effectInstance, boolean forced, @Nullable net.minecraft.world.entity.Entity entity) {
        super.onEffectUpdated(effectInstance, forced, entity);
        this.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effectInstance, false));
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, entity);
    }

    @Override
    protected void onEffectsRemoved(Collection<MobEffectInstance> effects) {
        super.onEffectsRemoved(effects);
        for (MobEffectInstance mobEffectInstance : effects) {
            this.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), mobEffectInstance.getEffect()));
            if (!mobEffectInstance.is(MobEffects.LEVITATION)) continue;
            this.levitationStartPos = null;
        }
        CriteriaTriggers.EFFECTS_CHANGED.trigger(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(x, y, z), Vec3.ZERO, 0.0f, 0.0f), Relative.union(Relative.DELTA, Relative.ROTATION));
    }

    @Override
    public void teleportRelative(double dx, double dy, double dz) {
        this.connection.teleport(new PositionMoveRotation(new Vec3(dx, dy, dz), Vec3.ZERO, 0.0f, 0.0f), Relative.ALL);
    }

    @Override
    public boolean teleportTo(ServerLevel level, double x, double y, double z, Set<Relative> relativeMovements, float yaw, float pitch, boolean setCamera, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag;
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (setCamera) {
            this.setCamera(this);
        }
        if (flag = super.teleportTo(level, x, y, z, relativeMovements, yaw, pitch, setCamera, cause)) {
            this.setYHeadRot(relativeMovements.contains((Object)Relative.Y_ROT) ? this.getYHeadRot() + yaw : yaw);
        }
        return flag;
    }

    @Override
    public void moveTo(double x, double y, double z) {
        super.moveTo(x, y, z);
        this.connection.resetPosition();
    }

    @Override
    public void crit(net.minecraft.world.entity.Entity entityHit) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(entityHit, 4));
    }

    @Override
    public void magicCrit(net.minecraft.world.entity.Entity entityHit) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new ClientboundAnimatePacket(entityHit, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection != null) {
            this.connection.send(new ClientboundPlayerAbilitiesPacket(this.getAbilities()));
            this.updateInvisibilityStatus();
        }
    }

    public ServerLevel serverLevel() {
        return (ServerLevel)this.level();
    }

    public boolean setGameMode(GameType gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(GameType gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean isSpectator = this.isSpectator();
        PlayerGameModeChangeEvent event = this.gameMode.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.CHANGE_GAME_MODE, gameMode.getId()));
        if (gameMode == GameType.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
            EnchantmentHelper.stopLocationBasedEffects(this);
        } else {
            this.setCamera(this);
            if (isSpectator) {
                EnchantmentHelper.runLocationChangedEffects(this.serverLevel(), this);
            }
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return event;
    }

    @Override
    public boolean isSpectator() {
        return this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        return this.gameMode.getGameModeForPlayer() == GameType.CREATIVE;
    }

    public CommandSource commandSource() {
        return this.commandSource;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this.commandSource(), this.position(), this.getRotationVector(), this.serverLevel(), this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.server, this);
    }

    public void sendSystemMessage(net.minecraft.network.chat.Component mesage) {
        this.sendSystemMessage(mesage, false);
    }

    public void sendSystemMessage(net.minecraft.network.chat.Component message, boolean overlay) {
        if (this.acceptsSystemMessages(overlay)) {
            this.connection.send(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.exceptionallySend(() -> {
                if (this.acceptsSystemMessages(false)) {
                    int i = 256;
                    String string = message.getString(256);
                    MutableComponent component = net.minecraft.network.chat.Component.literal(string).withStyle(ChatFormatting.YELLOW);
                    return new ClientboundSystemChatPacket(net.minecraft.network.chat.Component.translatable("multiplayer.message_not_delivered", component).withStyle(ChatFormatting.RED), false);
                }
                return null;
            }));
        }
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatType.Bound boundType) {
        this.sendChatMessage(message, filtered, boundType, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filtered, ChatType.Bound boundType, @Nullable net.minecraft.network.chat.Component unsigned) {
        if (this.acceptsChatMessages()) {
            message.sendToPlayer(this, filtered, boundType, unsigned);
        }
    }

    public String getIpAddress() {
        String string;
        SocketAddress socketAddress = this.connection.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            string = InetAddresses.toAddrString((InetAddress)inetSocketAddress.getAddress());
        } else {
            string = "<unknown>";
        }
        return string;
    }

    public void updateOptions(ClientInformation clientInformation) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Map)Util.make(new IdentityHashMap(), map -> {
            map.put(ClientOption.LOCALE, clientInformation.language());
            map.put(ClientOption.VIEW_DISTANCE, clientInformation.viewDistance());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientInformation.chatVisibility().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientInformation.chatColors());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientInformation.modelCustomisation()));
            map.put(ClientOption.MAIN_HAND, clientInformation.mainHand() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientInformation.textFilteringEnabled());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientInformation.allowsListing());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientInformation.particleStatus().name()));
        })).callEvent();
        if (this.getMainArm() != clientInformation.mainHand()) {
            event = new PlayerChangedMainHandEvent((org.bukkit.entity.Player)this.getBukkitEntity(), clientInformation.mainHand() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        if (this.language == null || !this.language.equals(clientInformation.language())) {
            event = new PlayerLocaleChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), clientInformation.language());
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientInformation);
    }

    public void updateOptionsNoEvents(ClientInformation clientInformation) {
        this.language = clientInformation.language();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.language), Locale.US);
        this.requestedViewDistance = clientInformation.viewDistance();
        this.chatVisibility = clientInformation.chatVisibility();
        this.canChatColor = clientInformation.chatColors();
        this.textFilteringEnabled = clientInformation.textFilteringEnabled();
        this.allowsListing = clientInformation.allowsListing();
        this.particleStatus = clientInformation.particleStatus();
        this.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (byte)clientInformation.modelCustomisation());
        this.getEntityData().set(Player.DATA_PLAYER_MAIN_HAND, (byte)clientInformation.mainHand().getId());
    }

    public ClientInformation clientInformation() {
        byte i = this.getEntityData().get(Player.DATA_PLAYER_MODE_CUSTOMISATION);
        HumanoidArm humanoidArm = HumanoidArm.BY_ID.apply(this.getEntityData().get(Player.DATA_PLAYER_MAIN_HAND).byteValue());
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, i, humanoidArm, this.textFilteringEnabled, this.allowsListing, this.particleStatus);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public ChatVisiblity getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean overlay) {
        return this.chatVisibility != ChatVisiblity.HIDDEN || overlay;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == ChatVisiblity.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerStatus serverStatus) {
        this.connection.send(new ClientboundServerDataPacket(serverStatus.description(), serverStatus.favicon().map(ServerStatus.Favicon::iconBytes)));
    }

    @Override
    public int getPermissionLevel() {
        return this.server.getProfilePermissions(this.getGameProfile());
    }

    public void resetLastActionTime() {
        this.lastActionTime = Util.getMillis();
    }

    public ServerStatsCounter getStats() {
        return this.stats;
    }

    public ServerRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public net.minecraft.world.entity.Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable net.minecraft.world.entity.Entity entityToSpectate) {
        net.minecraft.world.entity.Entity camera = this.getCamera();
        net.minecraft.world.entity.Entity entity = this.camera = entityToSpectate == null ? this : entityToSpectate;
        if (camera != this.camera) {
            Level level;
            if (this.camera == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.camera = camera;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (Entity)camera.getBukkitEntity(), (Entity)entityToSpectate.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.camera = camera;
                    return;
                }
            }
            if ((level = this.camera.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.teleportTo(serverLevel, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entityToSpectate != null) {
                this.serverLevel().getChunkSource().move(this);
            }
            this.connection.send(new ClientboundSetCameraPacket(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(net.minecraft.world.entity.Entity targetEntity) {
        if (this.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            this.setCamera(targetEntity);
        } else {
            super.attack(targetEntity);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Nullable
    public net.minecraft.network.chat.Component getTabListDisplayName() {
        return this.listName;
    }

    public int getTabListOrder() {
        return this.listOrder;
    }

    @Override
    public void swing(InteractionHand hand) {
        super.swing(hand);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public PlayerAdvancements getAdvancements() {
        return this.advancements;
    }

    @Nullable
    public BlockPos getRespawnPosition() {
        return this.respawnPosition;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public ResourceKey<Level> getRespawnDimension() {
        return this.respawnDimension;
    }

    public boolean isRespawnForced() {
        return this.respawnForced;
    }

    public void copyRespawnPosition(ServerPlayer player) {
        this.setRespawnPosition(player.getRespawnDimension(), player.getRespawnPosition(), player.getRespawnAngle(), player.isRespawnForced(), false);
    }

    @Deprecated
    public void setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos position, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, position, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos position, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, position, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<Level> dimension, @Nullable BlockPos position, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (position != null) {
            boolean flag = position.equals(this.respawnPosition) && dimension.equals(this.respawnDimension);
            spawnLoc = MCUtil.toLocation(this.getServer().getLevel(dimension), position);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((org.bukkit.entity.Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().dimension() : dimension;
            position = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.sendSystemMessage(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.respawnPosition = position;
            this.respawnDimension = dimension;
            this.respawnAngle = angle;
            this.respawnForced = forced;
        } else {
            this.respawnPosition = null;
            this.respawnDimension = Level.OVERWORLD;
            this.respawnAngle = 0.0f;
            this.respawnForced = false;
        }
        return true;
    }

    public SectionPos getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPos sectionPos) {
        this.lastSectionPos = sectionPos;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView chunkTrackingView) {
        this.chunkTrackingView = chunkTrackingView;
    }

    @Override
    public void playNotifySound(SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), source, this.getX(), this.getY(), this.getZ(), volume, pitch, this.random.nextLong()));
    }

    @Override
    public ItemEntity drop(ItemStack droppedItem, boolean dropAround, boolean traceItem, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        MapItemSavedData mapData;
        ItemEntity itemEntity = this.createItemStackToDrop(droppedItem, dropAround, traceItem);
        if (itemEntity == null) {
            return null;
        }
        if (entityOperation != null) {
            entityOperation.accept((Item)itemEntity.getBukkitEntity());
        }
        if (callEvent) {
            CraftPlayer player = this.getBukkitEntity();
            Item drop = (Item)itemEntity.getBukkitEntity();
            PlayerDropItemEvent event = new PlayerDropItemEvent((org.bukkit.entity.Player)player, drop);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                if (traceItem && (cur == null || cur.getAmount() == 0)) {
                    player.getInventory().setItemInHand(drop.getItemStack());
                } else if (traceItem && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                    cur.setAmount(cur.getAmount() + 1);
                    player.getInventory().setItemInHand(cur);
                } else {
                    player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                }
                return null;
            }
        }
        this.level().addFreshEntity(itemEntity);
        ItemStack item = itemEntity.getItem();
        if (traceItem) {
            if (!item.isEmpty()) {
                this.awardStat(Stats.ITEM_DROPPED.get(item.getItem()), item.getCount());
            }
            this.awardStat(Stats.DROP);
        }
        if (item.getItem() == Items.FILLED_MAP && (mapData = MapItem.getSavedData(item, this.level())) != null) {
            mapData.tickCarriedBy(this, item);
        }
        return itemEntity;
    }

    @Nullable
    private ItemEntity createItemStackToDrop(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName) {
        if (droppedItem.isEmpty()) {
            return null;
        }
        double d = this.getEyeY() - (double)0.3f;
        ItemStack tmp = droppedItem.copy();
        droppedItem.setCount(0);
        droppedItem = tmp;
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), d, this.getZ(), droppedItem);
        itemEntity.setPickUpDelay(40);
        if (includeThrowerName) {
            itemEntity.setThrower(this);
        }
        if (dropAround) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.setDeltaMovement(-Mth.sin(f1) * f, 0.2f, Mth.cos(f1) * f);
        } else {
            float f = 0.3f;
            float f1 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float cos = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float sin = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float cos1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f3 = 0.02f * this.random.nextFloat();
            itemEntity.setDeltaMovement((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f3, -f1 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f3);
        }
        return itemEntity;
    }

    public TextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(ServerLevel level) {
        this.setLevel(level);
        this.gameMode.setLevel(level);
    }

    @Nullable
    private static GameType readPlayerMode(@Nullable CompoundTag tag, String key) {
        return tag != null && tag.contains(key, 99) ? GameType.byId(tag.getInt(key)) : null;
    }

    private GameType calculateGameModeForNewPlayer(@Nullable GameType gameType) {
        GameType forcedGameType = this.server.getForcedGameType();
        if (forcedGameType != null) {
            return forcedGameType;
        }
        return gameType != null ? gameType : this.server.getDefaultGameType();
    }

    public void loadGameTypes(@Nullable CompoundTag tag) {
        if (this.server.getForcedGameType() != null && this.server.getForcedGameType() != ServerPlayer.readPlayerMode(tag, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), GameMode.getByValue((int)this.server.getDefaultGameType().getId()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.gameMode.setGameModeForPlayer(this.server.getForcedGameType(), GameType.DEFAULT_MODE);
            } else {
                this.gameMode.setGameModeForPlayer(ServerPlayer.readPlayerMode(tag, "playerGameType"), ServerPlayer.readPlayerMode(tag, "previousPlayerGameType"));
            }
            return;
        }
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(ServerPlayer.readPlayerMode(tag, "playerGameType")), ServerPlayer.readPlayerMode(tag, "previousPlayerGameType"));
    }

    private void storeGameTypes(CompoundTag tag) {
        tag.putInt("playerGameType", this.gameMode.getGameModeForPlayer().getId());
        GameType previousGameModeForPlayer = this.gameMode.getPreviousGameModeForPlayer();
        if (previousGameModeForPlayer != null) {
            tag.putInt("previousPlayerGameType", previousGameModeForPlayer.getId());
        }
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(ServerPlayer player) {
        return player != this && (this.textFilteringEnabled || player.textFilteringEnabled);
    }

    @Override
    public boolean mayInteract(ServerLevel level, BlockPos pos) {
        return super.mayInteract(level, pos) && level.mayInteract(this, pos);
    }

    @Override
    protected void updateUsingItem(ItemStack usingItem) {
        CriteriaTriggers.USING_ITEM.trigger(this, usingItem);
        super.updateUsingItem(usingItem);
    }

    public boolean drop(boolean dropStack) {
        Inventory inventory = this.getInventory();
        ItemStack itemStack = inventory.removeFromSelected(dropStack);
        this.containerMenu.findSlot(inventory, inventory.selected).ifPresent(i -> this.containerMenu.setRemoteSlot(i, inventory.getSelected()));
        return this.drop(itemStack, false, true) != null;
    }

    @Override
    public void handleExtraItemsCreatedOnUse(ItemStack stack) {
        if (!this.getInventory().add(stack)) {
            this.drop(stack, false);
        }
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    public void setSpawnExtraParticlesOnFall(boolean spawnExtraParticlesOnFall) {
        this.spawnExtraParticlesOnFall = spawnExtraParticlesOnFall;
    }

    @Override
    public void onItemPickup(ItemEntity itemEntity) {
        super.onItemPickup(itemEntity);
        net.minecraft.world.entity.Entity owner = itemEntity.getOwner();
        if (owner != null) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, itemEntity.getItem(), owner);
        }
    }

    public void setChatSession(RemoteChatSession chatSession) {
        this.chatSession = chatSession;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        return this.chatSession != null && this.chatSession.hasExpired() ? null : this.chatSession;
    }

    @Override
    public void indicateDamage(double xDistance, double zDistance) {
        this.hurtDir = (float)(Mth.atan2(zDistance, xDistance) * 180.0 / 3.1415927410125732 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(net.minecraft.world.entity.Entity vehicle, boolean force) {
        if (super.startRiding(vehicle, force)) {
            vehicle.positionRider(this);
            this.connection.teleport(new PositionMoveRotation(this.position(), Vec3.ZERO, 0.0f, 0.0f), Relative.ROTATION);
            if (vehicle instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)vehicle;
                this.server.getPlayerList().sendActiveEffects(livingEntity, this.connection);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stopRiding() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity vehicle = this.getVehicle();
        super.stopRiding(suppressCancellation);
        if (vehicle instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)vehicle;
            for (MobEffectInstance mobEffectInstance : livingEntity.getActiveEffects()) {
                this.connection.send(new ClientboundRemoveMobEffectPacket(vehicle.getId(), mobEffectInstance.getEffect()));
            }
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(ServerLevel level) {
        return new CommonPlayerSpawnInfo(level.dimensionTypeRegistration(), level.dimension(), BiomeManager.obfuscateSeed(level.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), level.isDebug(), level.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown(), level.getSeaLevel());
    }

    public void setRaidOmenPosition(BlockPos raidOmenPosition) {
        this.raidOmenPosition = raidOmenPosition;
    }

    public void clearRaidOmenPosition() {
        this.raidOmenPosition = null;
    }

    @Nullable
    public BlockPos getRaidOmenPosition() {
        return this.raidOmenPosition;
    }

    @Override
    public Vec3 getKnownMovement() {
        net.minecraft.world.entity.Entity vehicle = this.getVehicle();
        return vehicle != null && vehicle.getControllingPassenger() != this ? vehicle.getKnownMovement() : this.lastKnownClientMovement;
    }

    public void setKnownMovement(Vec3 knownMovement) {
        this.lastKnownClientMovement = knownMovement;
    }

    @Override
    protected float getEnchantedDamage(net.minecraft.world.entity.Entity entity, float damage, DamageSource damageSource) {
        return EnchantmentHelper.modifyDamage(this.serverLevel(), this.getWeaponItem(), entity, damageSource, damage);
    }

    @Override
    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EquipmentSlot slot) {
        super.onEquippedItemBroken(item, slot);
        this.awardStat(Stats.ITEM_BROKEN.get(item));
    }

    public Input getLastClientInput() {
        return this.lastClientInput;
    }

    public void setLastClientInput(Input lastClientInput) {
        this.lastClientInput = lastClientInput;
    }

    public Vec3 getLastClientMoveIntent() {
        float f;
        float f2 = this.lastClientInput.left() == this.lastClientInput.right() ? 0.0f : (f = this.lastClientInput.left() ? 1.0f : -1.0f);
        float f1 = this.lastClientInput.forward() == this.lastClientInput.backward() ? 0.0f : (this.lastClientInput.forward() ? 1.0f : -1.0f);
        return ServerPlayer.getInputVector(new Vec3(f, 0.0, f1), 1.0f, this.getYRot());
    }

    public void registerEnderPearl(ThrownEnderpearl enderPearl) {
        this.enderPearls.add(enderPearl);
    }

    public void deregisterEnderPearl(ThrownEnderpearl enderPearl) {
        this.enderPearls.remove(enderPearl);
    }

    public Set<ThrownEnderpearl> getEnderPearls() {
        return this.enderPearls;
    }

    public long registerAndUpdateEnderPearlTicket(ThrownEnderpearl enderPearl) {
        Level level = enderPearl.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos chunkPos = enderPearl.chunkPosition();
            this.registerEnderPearl(enderPearl);
            serverLevel.resetEmptyTime();
            return ServerPlayer.placeEnderPearlTicket(serverLevel, chunkPos) - 1L;
        }
        return 0L;
    }

    public static long placeEnderPearlTicket(ServerLevel level, ChunkPos pos) {
        if (!level.paperConfig().misc.legacyEnderPearlBehavior) {
            level.getChunkSource().addRegionTicket(TicketType.ENDER_PEARL, pos, 2, pos);
        }
        return TicketType.ENDER_PEARL.timeout();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.level().getDayTime() + this.timeOffset;
        }
        return this.level().getDayTime() - this.level().getDayTime() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f));
        } else {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, newThunder));
            } else {
                this.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = Mth.clamp(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.level().getLevelData().isRaining() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getScoreboardName() + " at " + this.getX() + "," + this.getY() + "," + this.getZ() + ")";
    }

    public void forceSetPositionRotation(double x, double y, double z, float yaw, float pitch) {
        this.moveTo(x, y, z, yaw, pitch);
        this.connection.resetPosition();
    }

    @Override
    public boolean isImmobile() {
        return super.isImmobile() || this.connection != null && this.connection.isDisconnected();
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.experienceProgress;
            this.newTotalExp = this.totalExperience;
            this.newLevel = this.experienceLevel;
        }
        this.setHealth(this.getMaxHealth());
        this.stopUsingItem();
        this.setAirSupply(this.getMaxAirSupply());
        this.setRemainingFireTicks(0);
        this.fallDistance = 0.0f;
        this.foodData = new FoodData();
        this.experienceLevel = this.newLevel;
        this.totalExperience = this.newTotalExp;
        this.experienceProgress = 0.0f;
        this.deathTime = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.effectsDirty = true;
        this.containerMenu = this.inventoryMenu;
        this.lastHurtByPlayer = null;
        this.lastHurtByMob = null;
        this.combatTracker = new CombatTracker(this);
        this.lastSentExp = -1;
        if (this.keepLevel) {
            this.experienceProgress = exp;
        } else {
            this.giveExperiencePoints(this.newExp);
        }
        this.keepLevel = false;
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.skipDropExperience = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnPosAngle(Vec3 position, float yaw, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3 position, BlockPos towardsPos, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(position, RespawnPosAngle.calculateLookAtYaw(position, towardsPos), isBedSpawn, isAnchorSpawn);
        }

        private static float calculateLookAtYaw(Vec3 position, BlockPos towardsPos) {
            Vec3 vec3 = Vec3.atBottomCenterOf(towardsPos).subtract(position).normalize();
            return (float)Mth.wrapDegrees(Mth.atan2(vec3.z, vec3.x) * 180.0 / 3.1415927410125732 - 90.0);
        }
    }
}

