/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class ServerPlayerGameMode {
    private static final Logger LOGGER = LogUtils.getLogger();
    public ServerLevel level;
    protected final ServerPlayer player;
    private GameType gameModeForPlayer = GameType.DEFAULT_MODE;
    @Nullable
    private GameType previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;
    public boolean captureSentBlockEntities = false;
    public boolean capturedBlockEntity = false;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPos interactPosition;
    public InteractionHand interactHand;
    public ItemStack interactItemStack;

    public ServerPlayerGameMode(ServerPlayer player) {
        this.player = player;
        this.level = player.serverLevel();
    }

    @Deprecated
    @DoNotUse
    public boolean changeGameModeForPlayer(GameType gameModeForPlayer) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameModeForPlayer, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent changeGameModeForPlayer(GameType gameModeForPlayer, PlayerGameModeChangeEvent.Cause playerGameModeChangeCause, @Nullable Component cancelMessage) {
        if (gameModeForPlayer == this.gameModeForPlayer) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.player.getBukkitEntity(), GameMode.getByValue((int)gameModeForPlayer.getId()), playerGameModeChangeCause, cancelMessage);
        if (!event.callEvent()) {
            return event;
        }
        this.setGameModeForPlayer(gameModeForPlayer, this.gameModeForPlayer);
        this.player.onUpdateAbilities();
        this.player.server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.player), this.player);
        this.level.updateSleepingPlayerList();
        if (gameModeForPlayer == GameType.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return event;
    }

    protected void setGameModeForPlayer(GameType gameModeForPlayer, @Nullable GameType previousGameModeForPlayer) {
        this.previousGameModeForPlayer = previousGameModeForPlayer;
        this.gameModeForPlayer = gameModeForPlayer;
        gameModeForPlayer.updatePlayerAbilities(this.player.getAbilities());
    }

    public GameType getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    @Nullable
    public GameType getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        this.gameTicks = (int)this.level.getLagCompensationTick();
        if (this.hasDelayedDestroy) {
            net.minecraft.world.level.block.state.BlockState blockState = this.level.getBlockStateIfLoaded(this.delayedDestroyPos);
            if (blockState == null || blockState.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float f = this.incrementDestroyProgress(blockState, this.delayedDestroyPos, this.delayedTickStart);
                if (f >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            net.minecraft.world.level.block.state.BlockState blockState = this.level.getBlockStateIfLoaded(this.destroyPos);
            if (blockState == null) {
                this.isDestroyingBlock = false;
                return;
            }
            if (blockState.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress(blockState, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(net.minecraft.world.level.block.state.BlockState state, BlockPos pos, int startTick) {
        int i = this.gameTicks - startTick;
        float f = state.getDestroyProgress(this.player, this.player.level(), pos) * (float)(i + 1);
        int i1 = (int)(f * 10.0f);
        if (i1 != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), pos, i1);
            this.lastSentState = i1;
        }
        return f;
    }

    private void debugLogging(BlockPos pos, boolean terminate, int sequence, String message) {
    }

    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction face, int maxBuildHeight, int sequence) {
        if (!this.player.canInteractWithBlock(pos, 1.0)) {
            return;
        }
        if (pos.getY() > maxBuildHeight) {
            this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, pos, face, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
                this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "may not interact");
                this.capturedBlockEntity = true;
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, pos, face, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
            if (event.isCancelled()) {
                this.capturedBlockEntity = true;
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(pos, sequence, "creative destroy");
                return;
            }
            if (this.player.getMainHandItem().is(Items.DEBUG_STICK) && ((DebugStickItem)Items.DEBUG_STICK).handleInteraction(this.player, this.level.getBlockState(pos), this.level, pos, false, this.player.getMainHandItem())) {
                return;
            }
            if (this.player.blockActionRestricted(this.level, pos, this.gameModeForPlayer)) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f = 1.0f;
            net.minecraft.world.level.block.state.BlockState blockState = this.level.getBlockState(pos);
            if (event.useInteractedBlock() != Event.Result.DENY && !blockState.isAir()) {
                EnchantmentHelper.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EquipmentSlot.MAINHAND, Vec3.atCenterOf(pos), blockState, item -> this.player.onEquippedItemBroken((Item)item, EquipmentSlot.MAINHAND));
                blockState.attack(this.level, pos, this.player);
                f = blockState.getDestroyProgress(this.player, this.player.level(), pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.player, pos, face, this.player.getInventory().getSelected(), f >= 1.0f);
            if (blockEvent.isCancelled()) {
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!blockState.isAir() && f >= 1.0f) {
                this.destroyAndAck(pos, sequence, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = pos.immutable();
                int i = (int)(f * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), pos, i);
                this.debugLogging(pos, true, sequence, "actual start of destroying");
                this.lastSentState = i;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals(this.destroyPos)) {
                int i1 = this.gameTicks - this.destroyProgressStart;
                net.minecraft.world.level.block.state.BlockState blockStatex = this.level.getBlockState(pos);
                if (!blockStatex.isAir()) {
                    float f1 = blockStatex.getDestroyProgress(this.player, this.player.level(), pos) * (float)(i1 + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), pos, -1);
                        this.destroyAndAck(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = pos;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(pos, true, sequence, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, pos) && !BlockPos.ZERO.equals(this.destroyPos)) {
                LOGGER.debug("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)pos);
                net.minecraft.world.level.block.state.BlockState type = this.level.getBlockStateIfLoaded(this.destroyPos);
                if (type != null) {
                    this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                    this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
                }
                this.destroyPos = BlockPos.ZERO;
            }
            this.level.destroyBlockProgress(this.player.getId(), pos, -1);
            this.debugLogging(pos, true, sequence, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.player, pos, this.player.getInventory().getSelected());
        }
        this.level.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, face, maxBuildHeight, sequence);
    }

    public void destroyAndAck(BlockPos pos, int sequence, String message) {
        if (this.destroyBlock(pos)) {
            this.debugLogging(pos, true, sequence, message);
        } else {
            this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, message);
        }
    }

    public boolean destroyBlock(BlockPos pos) {
        net.minecraft.world.level.block.state.BlockState blockState = this.level.getBlockState(pos);
        CraftBlock bblock = CraftBlock.at(this.level, pos);
        BlockBreakEvent event = null;
        if (this.player instanceof ServerPlayer) {
            boolean canAttackBlock = !this.player.getMainHandItem().getItem().canAttackBlock(blockState, this.level, pos, this.player);
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.player.getBukkitEntity());
            event.setCancelled(canAttackBlock);
            net.minecraft.world.level.block.state.BlockState updatedBlockState = this.level.getBlockState(pos);
            Block block = updatedBlockState.getBlock();
            if (!event.isCancelled() && !this.isCreative() && this.player.hasCorrectToolForDrops(block.defaultBlockState())) {
                ItemStack itemInHand = this.player.getItemBySlot(EquipmentSlot.MAINHAND);
                event.setExpToDrop(block.getExpDrop(updatedBlockState, this.level, pos, itemInHand, true));
            }
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (canAttackBlock) {
                    return false;
                }
                if (!this.captureSentBlockEntities) {
                    BlockEntity blockEntity = this.level.getBlockEntity(pos);
                    if (blockEntity != null) {
                        this.player.connection.send(blockEntity.getUpdatePacket());
                    }
                } else {
                    this.capturedBlockEntity = true;
                }
                return false;
            }
        }
        if ((blockState = this.level.getBlockState(pos)).isAir()) {
            return false;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        Block block = blockState.getBlock();
        if (!(!(block instanceof GameMasterBlock) || this.player.canUseGameMasterBlocks() || block instanceof CommandBlock && this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.level.sendBlockUpdated(pos, blockState, blockState, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, pos, this.gameModeForPlayer)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.level.captureDrops = new ArrayList<ItemEntity>();
        net.minecraft.world.level.block.state.BlockState blockState1 = block.playerWillDestroy(this.level, pos, blockState, this.player);
        boolean flag = this.level.removeBlock(pos, false);
        if (flag) {
            block.destroy(this.level, pos, blockState1);
        }
        ItemStack mainHandStack = null;
        boolean isCorrectTool = false;
        if (!this.isCreative()) {
            ItemStack mainHandItem = this.player.getMainHandItem();
            ItemStack itemStack = mainHandItem.copy();
            boolean hasCorrectToolForDrops = this.player.hasCorrectToolForDrops(blockState1);
            mainHandStack = itemStack;
            isCorrectTool = hasCorrectToolForDrops;
            mainHandItem.mineBlock(this.level, blockState1, pos, this.player);
            if (flag && hasCorrectToolForDrops) {
                block.playerDestroy(this.level, this.player, pos, blockState1, blockEntity, itemStack, event.isDropItems(), false);
            }
        }
        List<ItemEntity> itemsToDrop = this.level.captureDrops;
        this.level.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.player, itemsToDrop);
        }
        if (flag) {
            blockState.getBlock().popExperience(this.level, pos, event.getExpToDrop(), this.player);
        }
        if (mainHandStack != null && flag && isCorrectTool && event.isDropItems() && block instanceof BeehiveBlock && blockEntity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)blockEntity;
            CriteriaTriggers.BEE_NEST_DESTROYED.trigger(this.player, blockState, mainHandStack, beehiveBlockEntity.getOccupantCount());
        }
        return true;
    }

    public InteractionResult useItem(ServerPlayer player, Level level, ItemStack stack, InteractionHand hand) {
        ItemStack itemStack;
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (player.getCooldowns().isOnCooldown(stack)) {
            return InteractionResult.PASS;
        }
        int count = stack.getCount();
        int damageValue = stack.getDamageValue();
        InteractionResult interactionResult = stack.use(level, player, hand);
        if (interactionResult instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)interactionResult;
            itemStack = Objects.requireNonNullElse(success.heldItemTransformedTo(), player.getItemInHand(hand));
        } else {
            itemStack = player.getItemInHand(hand);
        }
        if (itemStack == stack && itemStack.getCount() == count && itemStack.getUseDuration(player) <= 0 && itemStack.getDamageValue() == damageValue) {
            return interactionResult;
        }
        if (interactionResult instanceof InteractionResult.Fail && itemStack.getUseDuration(player) > 0 && !player.isUsingItem()) {
            return interactionResult;
        }
        if (stack != itemStack) {
            player.setItemInHand(hand, itemStack);
        }
        if (itemStack.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        if (!player.isUsingItem()) {
            player.inventoryMenu.sendAllDataToRemote();
        }
        return interactionResult;
    }

    public InteractionResult useItemOn(ServerPlayer player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult interactionResult1;
        BlockPos blockPos = hitResult.getBlockPos();
        net.minecraft.world.level.block.state.BlockState blockState = level.getBlockState(blockPos);
        boolean cancelledBlock = false;
        boolean cancelledItem = false;
        if (!blockState.getBlock().isEnabled(level.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider menuProvider = blockState.getMenuProvider(level, blockPos);
            boolean bl = cancelledBlock = !(menuProvider instanceof MenuProvider);
        }
        if (player.getCooldowns().isOnCooldown(stack)) {
            cancelledItem = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockPos, hitResult.getDirection(), stack, cancelledBlock, cancelledItem, hand, hitResult.getLocation());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockPos.immutable();
        this.interactHand = hand;
        this.interactItemStack = stack.copy();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (blockState.getBlock() instanceof CakeBlock) {
                player.getBukkitEntity().sendHealthUpdate();
            } else if (blockState.is(Blocks.JIGSAW) || blockState.is(Blocks.STRUCTURE_BLOCK) || blockState.getBlock() instanceof CommandBlock) {
                player.connection.send(new ClientboundContainerClosePacket(this.player.containerMenu.containerId));
            }
            player.getBukkitEntity().updateInventory();
            this.player.resyncUsingItem(this.player);
            return event.useItemInHand() != Event.Result.ALLOW ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider menuProvider = blockState.getMenuProvider(level, blockPos);
            if (menuProvider != null && player.openMenu(menuProvider).isPresent()) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        boolean flag = !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
        boolean flag1 = player.isSecondaryUseActive() && flag;
        ItemStack itemStack = stack.copy();
        if (!flag1) {
            InteractionResult interactionResult = blockState.useItemOn(player.getItemInHand(hand), level, player, hand, hitResult);
            if (interactionResult.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, blockPos, itemStack);
                return interactionResult;
            }
            if (interactionResult instanceof InteractionResult.TryEmptyHandInteraction && hand == InteractionHand.MAIN_HAND && (interactionResult1 = blockState.useWithoutItem(level, player, hitResult)).consumesAction()) {
                CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(player, blockPos);
                return interactionResult1;
            }
        }
        if (!stack.isEmpty() && !this.interactResult) {
            UseOnContext useOnContext = new UseOnContext(player, hand, hitResult);
            if (this.isCreative()) {
                int count = stack.getCount();
                interactionResult1 = stack.useOn(useOnContext);
                stack.setCount(count);
            } else {
                interactionResult1 = stack.useOn(useOnContext);
            }
            if (interactionResult1.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, blockPos, itemStack);
            }
            return interactionResult1;
        }
        if (this.interactResult && this.interactResult != cancelledItem) {
            this.player.resyncUsingItem(this.player);
        }
        return InteractionResult.PASS;
    }

    public void setLevel(ServerLevel serverLevel) {
        this.level = serverLevel;
    }
}

