/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;

public class ThreadedLevelLightEngine
extends LevelLightEngine
implements AutoCloseable,
StarLightLightingProvider {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ChunkMap chunkMap;
    private final int taskPerBatch = 1000;
    private final AtomicLong chunkWorkCounter = new AtomicLong();

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> supplier) {
        ServerLevel world = (ServerLevel)this.starlight$getLightEngine().getWorld();
        ChunkAccess center = this.starlight$getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT)) {
            return;
        }
        StarLightInterface.ServerLightQueue.ServerChunkTasks scheduledTask = (StarLightInterface.ServerLightQueue.ServerChunkTasks)supplier.get();
        if (scheduledTask == null) {
            return;
        }
        if (!scheduledTask.markTicketAdded()) {
            return;
        }
        Long ticketId = this.chunkWorkCounter.getAndIncrement();
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        world.getChunkSource().addRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, ticketId);
        scheduledTask.queueOrRunTask(() -> world.getChunkSource().removeRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, ticketId));
    }

    @Override
    public final int starlight$serverRelightChunks(Collection<ChunkPos> chunks0, Consumer<ChunkPos> chunkLightCallback, IntConsumer onComplete) {
        LinkedHashSet<ChunkPos> chunks = new LinkedHashSet<ChunkPos>(chunks0);
        HashMap<ChunkPos, Long> ticketIds = new HashMap<ChunkPos, Long>();
        ServerLevel world = (ServerLevel)this.starlight$getLightEngine().getWorld();
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkPos pos = (ChunkPos)iterator.next();
            Long id = ChunkTaskScheduler.getNextChunkRelightId();
            world.getChunkSource().addRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, id);
            ticketIds.put(pos, id);
            ChunkAccess chunk = (ChunkAccess)world.getChunkSource().getChunkForLighting(pos.x, pos.z);
            if (chunk != null && chunk.isLightCorrect() && chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT)) continue;
            iterator.remove();
            ticketIds.remove(pos);
            world.getChunkSource().removeRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, id);
        }
        world.moonrise$getChunkTaskScheduler().radiusAwareScheduler.queueInfiniteRadiusTask(() -> this.starlight$getLightEngine().relightChunks(chunks, pos -> {
            if (chunkLightCallback != null) {
                chunkLightCallback.accept((ChunkPos)pos);
            }
            world.moonrise$getChunkTaskScheduler().scheduleChunkTask(pos.x, pos.z, () -> {
                NewChunkHolder chunkHolder = world.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos.x, pos.z);
                if (chunkHolder == null) {
                    return;
                }
                List<ServerPlayer> players = chunkHolder.vanillaChunkHolder.moonrise$getPlayers(false);
                if (players.isEmpty()) {
                    return;
                }
                ClientboundLightUpdatePacket relightPacket = new ClientboundLightUpdatePacket((ChunkPos)pos, this, null, null);
                for (ServerPlayer player : players) {
                    ServerGamePacketListenerImpl conn = player.connection;
                    if (conn == null) continue;
                    conn.send(relightPacket);
                }
            });
        }, relight -> {
            if (onComplete != null) {
                onComplete.accept(relight);
            }
            for (Map.Entry entry : ticketIds.entrySet()) {
                world.getChunkSource().removeRegionTicket(ChunkTaskScheduler.CHUNK_RELIGHT, (ChunkPos)entry.getKey(), StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Long)entry.getValue());
            }
        }));
        return chunks.size();
    }

    public ThreadedLevelLightEngine(LightChunkGetter lightChunkGetter, ChunkMap chunkMap, boolean skyLight, ConsecutiveExecutor consecutiveExecutor, ChunkTaskDispatcher taskDispatcher) {
        super(lightChunkGetter, true, skyLight);
        this.chunkMap = chunkMap;
    }

    @Override
    public void close() {
    }

    @Override
    public int runLightUpdates() {
        throw Util.pauseInIde(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void checkBlock(BlockPos pos) {
        BlockPos posCopy = pos.immutable();
        this.queueTaskForSection(posCopy.getX() >> 4, posCopy.getY() >> 4, posCopy.getZ() >> 4, () -> this.starlight$getLightEngine().blockChange(posCopy));
    }

    protected void updateChunkStatus(ChunkPos chunkPos) {
    }

    @Override
    public void updateSectionStatus(SectionPos pos, boolean isEmpty) {
        this.queueTaskForSection(pos.getX(), pos.getY(), pos.getZ(), () -> this.starlight$getLightEngine().sectionChange(pos, isEmpty));
    }

    @Override
    public void propagateLightSources(ChunkPos chunkPos) {
    }

    @Override
    public void setLightEnabled(ChunkPos chunkPos, boolean lightEnabled) {
    }

    @Override
    public void queueSectionData(LightLayer lightLayer, SectionPos sectionPos, @Nullable DataLayer dataLayer) {
    }

    private void addTask(int chunkX, int chunkZ, TaskType type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    private void addTask(int chunkX, int chunkZ, IntSupplier queueLevelSupplier, TaskType type, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retainData(ChunkPos pos, boolean retain) {
    }

    public CompletableFuture<ChunkAccess> initializeLight(ChunkAccess chunk, boolean lightEnabled) {
        return CompletableFuture.completedFuture(chunk);
    }

    public CompletableFuture<ChunkAccess> lightChunk(ChunkAccess chunk, boolean isLighted) {
        throw new UnsupportedOperationException();
    }

    public void tryScheduleUpdate() {
    }

    private void runUpdate() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> waitForPendingTasks(int x, int z) {
        throw new UnsupportedOperationException();
    }

    static enum TaskType {
        PRE_UPDATE,
        POST_UPDATE;

    }
}

