/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import java.util.Objects;
import net.minecraft.server.level.TicketType;

public final class Ticket<T>
implements Comparable<Ticket<?>>,
ChunkSystemTicket<T> {
    private final TicketType<T> type;
    private final int ticketLevel;
    public final T key;
    private long removeDelay;

    @Override
    public final long moonrise$getRemoveDelay() {
        return this.removeDelay;
    }

    @Override
    public final void moonrise$setRemoveDelay(long removeDelay) {
        this.removeDelay = removeDelay;
    }

    public Ticket(TicketType<T> type, int ticketLevel, T key) {
        this.type = type;
        this.ticketLevel = ticketLevel;
        this.key = key;
    }

    @Override
    public int compareTo(Ticket<?> other) {
        int i = Integer.compare(this.ticketLevel, other.ticketLevel);
        if (i != 0) {
            return i;
        }
        int i1 = Integer.compare(System.identityHashCode(this.type), System.identityHashCode(other.type));
        return i1 != 0 ? i1 : this.type.getComparator().compare(this.key, other.key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof Ticket)) return false;
        Ticket ticket = (Ticket)other;
        if (this.ticketLevel != ticket.ticketLevel) return false;
        if (!Objects.equals(this.type, ticket.type)) return false;
        if (!Objects.equals(this.key, ticket.key)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ticketLevel, this.key);
    }

    public String toString() {
        return "Ticket[" + String.valueOf(this.type) + " " + this.ticketLevel + " (" + String.valueOf(this.key) + ")] to die in " + this.removeDelay;
    }

    public TicketType<T> getType() {
        return this.type;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    protected void setCreatedTick(long timestamp) {
        throw new UnsupportedOperationException();
    }

    protected boolean timedOut(long currentTime) {
        throw new UnsupportedOperationException();
    }
}

