/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.plugin.Plugin;

public class TicketType<T> {
    public static final TicketType<Long> FUTURE_AWAIT = TicketType.create("future_await", Long::compareTo);
    private final String name;
    private final Comparator<T> comparator;
    public long timeout;
    public static final TicketType<Unit> START = TicketType.create("start", (unit1, unit2) -> 0);
    public static final TicketType<Unit> DRAGON = TicketType.create("dragon", (unit1, unit2) -> 0);
    public static final TicketType<ChunkPos> PLAYER = TicketType.create("player", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<ChunkPos> FORCED = TicketType.create("forced", Comparator.comparingLong(ChunkPos::toLong));
    public static final TicketType<BlockPos> PORTAL = TicketType.create("portal", Vec3i::compareTo, 300);
    public static final TicketType<ChunkPos> ENDER_PEARL = TicketType.create("ender_pearl", Comparator.comparingLong(ChunkPos::toLong), 40);
    public static final TicketType<ChunkPos> UNKNOWN = TicketType.create("unknown", Comparator.comparingLong(ChunkPos::toLong), 1);
    public static final TicketType<Unit> PLUGIN = TicketType.create("plugin", (a, b) -> 0);
    public static final TicketType<Plugin> PLUGIN_TICKET = TicketType.create("plugin_ticket", (plugin1, plugin2) -> plugin1.getClass().getName().compareTo(plugin2.getClass().getName()));
    public static final TicketType<Integer> POST_TELEPORT = TicketType.create("post_teleport", Integer::compare, 5);

    public static <T> TicketType<T> create(String name, Comparator<T> comparator) {
        return new TicketType<T>(name, comparator, 0L);
    }

    public static <T> TicketType<T> create(String name, Comparator<T> comparator, int lifespan) {
        return new TicketType<T>(name, comparator, lifespan);
    }

    protected TicketType(String name, Comparator<T> comparator, long timeout) {
        this.name = name;
        this.comparator = comparator;
        this.timeout = timeout;
    }

    public String toString() {
        return this.name;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public long timeout() {
        return this.timeout;
    }
}

